/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class TryHelper {
    public static boolean enhanceTryStats(RootStatement root) {
        boolean ret = TryHelper.makeTryWithResourceRec(root);
        if (ret) {
            SequenceHelper.condenseSequences(root);
            if (TryHelper.collapseTryRec(root)) {
                SequenceHelper.condenseSequences(root);
            }
        }
        return ret;
    }

    private static boolean makeTryWithResourceRec(Statement stat) {
        if (stat.type == 12 && ((CatchAllStatement)stat).isFinally() && TryHelper.makeTryWithResource((CatchAllStatement)stat)) {
            return true;
        }
        for (Statement st : stat.getStats()) {
            if (!TryHelper.makeTryWithResourceRec(st)) continue;
            return true;
        }
        return false;
    }

    private static boolean collapseTryRec(Statement stat) {
        if (stat.type == 7 && TryHelper.collapseTry((CatchStatement)stat)) {
            return true;
        }
        for (Statement st : stat.getStats()) {
            if (!TryHelper.collapseTryRec(st)) continue;
            return true;
        }
        return false;
    }

    private static boolean makeTryWithResource(CatchAllStatement finallyStat) {
        Exprent exp;
        Statement handler = finallyStat.getHandler();
        if (handler.getStats().size() != 2) {
            return false;
        }
        Statement toCheck = finallyStat.getHandler().getFirst();
        if (toCheck.type != 2 || ((IfStatement)toCheck).getIfstat().type != 2) {
            return false;
        }
        if (((IfStatement)(toCheck = ((IfStatement)toCheck).getIfstat())).getElsestat() == null) {
            return false;
        }
        Statement elseBlock = ((IfStatement)toCheck).getElsestat();
        VarExprent var = null;
        if (elseBlock.getExprents() != null && elseBlock.getExprents().size() == 1 && TryHelper.isCloseable(exp = elseBlock.getExprents().get(0))) {
            var = (VarExprent)((InvocationExprent)exp).getInstance();
        }
        if (var != null) {
            AssignmentExprent ass = null;
            BasicBlockStatement initBlock = null;
            for (StatEdge edge : finallyStat.getAllPredecessorEdges()) {
                if (!edge.getDestination().equals(finallyStat) || edge.getSource().type != 8 || (ass = TryHelper.findResourceDef(var, edge.getSource())) == null) continue;
                initBlock = (BasicBlockStatement)edge.getSource();
                break;
            }
            if (ass != null) {
                Statement stat = finallyStat.getParent();
                Statement stat2 = finallyStat.getFirst();
                if (stat2.type == 7) {
                    CatchStatement child = (CatchStatement)stat2;
                    AssignmentExprent resourceDef = (AssignmentExprent)ass.copy();
                    if (ass.getRight().getExprType().equals(VarType.VARTYPE_NULL) && child.getFirst() != null) {
                        TryHelper.fixResourceAssignment(resourceDef, child.getFirst());
                    }
                    if (resourceDef.getRight().getExprType().equals(VarType.VARTYPE_NULL)) {
                        return false;
                    }
                    child.setTryType(1);
                    initBlock.getExprents().remove(ass);
                    child.getResources().add(resourceDef);
                    if (!finallyStat.getVarDefinitions().isEmpty()) {
                        child.getVarDefinitions().addAll(0, finallyStat.getVarDefinitions());
                    }
                    stat.replaceStatement(finallyStat, child);
                    TryHelper.removeRedundantThrow(initBlock, child);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean collapseTry(CatchStatement catchStat) {
        CatchStatement toRemove;
        Statement parent = catchStat;
        if (parent.getFirst() != null && parent.getFirst().type == 15) {
            parent = parent.getFirst();
        }
        if (parent != null && parent.getFirst() != null && parent.getFirst().type == 7 && (toRemove = (CatchStatement)parent.getFirst()).getTryType() == 1) {
            catchStat.setTryType(1);
            catchStat.getResources().addAll(toRemove.getResources());
            catchStat.getVarDefinitions().addAll(toRemove.getVarDefinitions());
            parent.replaceStatement(toRemove, toRemove.getFirst());
            if (!toRemove.getVars().isEmpty()) {
                for (int i = 0; i < toRemove.getVars().size(); ++i) {
                    catchStat.getVars().add(i, toRemove.getVars().get(i));
                    catchStat.getExctStrings().add(i, toRemove.getExctStrings().get(i));
                    catchStat.getStats().add(i + 1, (Statement)catchStat.getStats().get(i + 1));
                }
            }
            return true;
        }
        return false;
    }

    private static AssignmentExprent findResourceDef(VarExprent var, Statement prevStatement) {
        for (Exprent exp : prevStatement.getExprents()) {
            VarExprent left;
            if (exp.type != 2) continue;
            AssignmentExprent ass = (AssignmentExprent)exp;
            if (ass.getLeft().type != 12 || !(left = (VarExprent)ass.getLeft()).getVarVersionPair().equals(var.getVarVersionPair())) continue;
            return ass;
        }
        return null;
    }

    private static boolean isCloseable(Exprent exp) {
        InvocationExprent invocExp;
        if (exp.type == 8 && (invocExp = (InvocationExprent)exp).getName().equals("close") && invocExp.getStringDescriptor().equals("()V") && invocExp.getInstance() != null && invocExp.getInstance().type == 12) {
            return DecompilerContext.getStructContext().instanceOf(invocExp.getClassname(), "java/lang/AutoCloseable");
        }
        return false;
    }

    private static void fixResourceAssignment(AssignmentExprent ass, Statement statement) {
        if (statement.getExprents() != null) {
            for (Exprent exp : statement.getExprents()) {
                if (exp.type != 2) continue;
                AssignmentExprent toRemove = (AssignmentExprent)exp;
                if (!ass.getLeft().equals(toRemove.getLeft()) || toRemove.getRight().getExprType().equals(VarType.VARTYPE_NULL)) continue;
                ass.setRight(toRemove.getRight());
                statement.getExprents().remove(toRemove);
                break;
            }
        }
    }

    private static boolean removeRedundantThrow(BasicBlockStatement initBlock, CatchStatement catchStat) {
        if (catchStat.getStats().size() > 1) {
            boolean removed = false;
            Statement temp = null;
            for (int i = 1; i < catchStat.getStats().size(); ++i) {
                ExitExprent exitExprent;
                temp = (Statement)catchStat.getStats().get(i);
                if (temp.type != 8 || temp.getExprents() == null || temp.getExprents().size() < 2 || !catchStat.getVars().get((int)(i - 1)).getVarType().value.equals("java/lang/Throwable") || temp.getExprents().get((int)(temp.getExprents().size() - 1)).type != 4 || (exitExprent = (ExitExprent)temp.getExprents().get(temp.getExprents().size() - 1)).getExitType() != 1 || !exitExprent.getValue().equals(catchStat.getVars().get(i - 1))) continue;
                catchStat.getExctStrings().remove(i - 1);
                catchStat.getVars().remove(i - 1);
                catchStat.getStats().remove(i);
                for (StatEdge edge : temp.getAllPredecessorEdges()) {
                    edge.getSource().removeSuccessor(edge);
                }
                for (StatEdge edge : temp.getAllSuccessorEdges()) {
                    edge.getDestination().removePredecessor(edge);
                }
                removed = true;
                break;
            }
            if (removed && temp.getExprents().get((int)(temp.getExprents().size() - 2)).type == 2) {
                AssignmentExprent assignmentExp = (AssignmentExprent)temp.getExprents().get(temp.getExprents().size() - 2);
                if (assignmentExp.getLeft().getExprType().value.equals("java/lang/Throwable")) {
                    for (Exprent exprent : initBlock.getExprents()) {
                        AssignmentExprent toRemove;
                        if (exprent.type != 2 || !(toRemove = (AssignmentExprent)exprent).getLeft().equals(assignmentExp.getLeft())) continue;
                        initBlock.getExprents().remove(toRemove);
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

