/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.util.TextUtil;

public class ThreadedPrintStreamLogger
extends IFernflowerLogger {
    private final PrintStream stream;
    private final ThreadLocal<AtomicInteger> indent = ThreadLocal.withInitial(AtomicInteger::new);

    public ThreadedPrintStreamLogger(PrintStream printStream) {
        this.stream = printStream;
    }

    @Override
    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (this.accepts(severity)) {
            Thread th = Thread.currentThread();
            this.stream.println(th.getName() + ": " + severity.prefix + TextUtil.getIndentString(this.indent.get().get()) + message);
        }
    }

    @Override
    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
        if (this.accepts(severity)) {
            this.writeMessage(message, severity);
            t.printStackTrace(this.stream);
        }
    }

    @Override
    public void startProcessingClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("PreProcessing class " + className, IFernflowerLogger.Severity.INFO);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endProcessingClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
        }
    }

    @Override
    public void startReadingClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Decompiling class " + className, IFernflowerLogger.Severity.INFO);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endReadingClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
        }
    }

    @Override
    public void startClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Processing class " + className, IFernflowerLogger.Severity.TRACE);
            this.indent.get().decrementAndGet();
        }
    }

    @Override
    public void endClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
        }
    }

    @Override
    public void startMethod(String methodName) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Processing method " + methodName, IFernflowerLogger.Severity.TRACE);
            this.indent.get().decrementAndGet();
        }
    }

    @Override
    public void endMethod() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
        }
    }

    @Override
    public void startWriteClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Writing class " + className, IFernflowerLogger.Severity.TRACE);
            this.indent.get().decrementAndGet();
        }
    }

    @Override
    public void endWriteClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... written", IFernflowerLogger.Severity.TRACE);
        }
    }
}

