/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ImportCollector {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private final Map<String, String> mapSimpleNames = new HashMap<String, String>();
    private final Set<String> setNotImportedNames = new HashSet<String>();
    private final Set<String> setFieldNames = new HashSet<String>();
    private final Map<String, Map<String, String>> mapInnerClassNames = new HashMap<String, Map<String, String>>();
    private final String currentPackageSlash;
    private final String currentPackagePoint;

    public ImportCollector(ClassesProcessor.ClassNode root) {
        String clName = root.classStruct.qualifiedName;
        int index = clName.lastIndexOf(47);
        if (index >= 0) {
            String packageName = clName.substring(0, index);
            this.currentPackageSlash = packageName + '/';
            this.currentPackagePoint = packageName.replace('/', '.');
        } else {
            this.currentPackageSlash = "";
            this.currentPackagePoint = "";
        }
        Map<String, StructClass> classes = DecompilerContext.getStructContext().getClasses();
        StructClass currentClass = root.classStruct;
        while (currentClass != null) {
            for (StructField f : currentClass.getFields()) {
                this.setFieldNames.add(f.getName());
            }
            currentClass = currentClass.superClass != null ? classes.get(currentClass.superClass.getString()) : null;
        }
        this.collectConflictingShortNames(root, new HashMap<String, String>());
    }

    public String getShortNameInClassContext(String classToName) {
        String shortName = this.getShortName(classToName);
        if (this.setFieldNames.contains(shortName)) {
            return classToName;
        }
        return shortName;
    }

    public String getShortName(String fullName) {
        return this.getShortName(fullName, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getShortName(String fullName, boolean imported) {
        StructContext context;
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(fullName.replace('.', '/'));
        String result = null;
        if (node != null && node.classStruct.isOwn()) {
            result = node.simpleName;
            while (node.parent != null && node.type == 1) {
                result = node.parent.simpleName + '.' + result;
                node = node.parent;
            }
            if (node.type != 0) return result;
            fullName = node.classStruct.qualifiedName;
            fullName = fullName.replace('/', '.');
        } else {
            fullName = fullName.replace('$', '.');
        }
        String shortName = fullName;
        String packageName = "";
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot >= 0) {
            shortName = fullName.substring(lastDot + 1);
            packageName = fullName.substring(0, lastDot);
        }
        boolean existsDefaultClass = (context = DecompilerContext.getStructContext()).getClass(this.currentPackageSlash + shortName) != null && !packageName.equals(this.currentPackagePoint) || context.getClass(shortName) != null && !this.currentPackagePoint.isEmpty();
        ClassesProcessor.ClassNode currCls = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        String mapKey = currCls == null ? "" : currCls.classStruct.qualifiedName;
        Map innerClassNames = this.mapInnerClassNames.getOrDefault(mapKey, new HashMap());
        if (!existsDefaultClass && innerClassNames.containsKey(shortName) && !((String)innerClassNames.get(shortName)).equals(fullName)) {
            if (context.getClass(packageName.replace('.', '/') + "$" + shortName) != null) {
                if ((lastDot = fullName.lastIndexOf(".", lastDot - 1)) >= 0) {
                    result = fullName.substring(lastDot + 1);
                    shortName = packageName.substring(lastDot + 1);
                    packageName = packageName.substring(0, lastDot);
                    if (innerClassNames.containsKey(shortName) && !((String)innerClassNames.get(shortName)).equals(packageName + '.' + shortName)) {
                        existsDefaultClass = true;
                        result = null;
                    }
                }
            } else {
                existsDefaultClass = true;
            }
        }
        if (existsDefaultClass || this.mapSimpleNames.containsKey(shortName) && !packageName.equals(this.mapSimpleNames.get(shortName))) {
            return result == null ? fullName : packageName + "." + result;
        }
        if (this.mapSimpleNames.containsKey(shortName)) return result == null ? shortName : result;
        this.mapSimpleNames.put(shortName, packageName);
        if (imported) return result == null ? shortName : result;
        this.setNotImportedNames.add(shortName);
        return result == null ? shortName : result;
    }

    public int writeImports(TextBuffer buffer) {
        int importLinesWritten = 0;
        List<String> imports = this.packImports();
        for (String s : imports) {
            buffer.append("import ");
            buffer.append(s);
            buffer.append(';');
            buffer.appendLineSeparator();
            ++importLinesWritten;
        }
        return importLinesWritten;
    }

    private List<String> packImports() {
        return this.mapSimpleNames.entrySet().stream().filter(ent -> !this.setNotImportedNames.contains(ent.getKey()) && !((String)ent.getValue()).isEmpty() && !JAVA_LANG_PACKAGE.equals(ent.getValue()) && !((String)ent.getValue()).equals(this.currentPackagePoint)).sorted(Map.Entry.comparingByValue().thenComparing(Map.Entry.comparingByKey())).map(ent -> (String)ent.getValue() + "." + (String)ent.getKey()).collect(Collectors.toList());
    }

    private void collectConflictingShortNames(ClassesProcessor.ClassNode root, Map<String, String> rootNames) {
        HashMap<String, String> names = new HashMap<String, String>(rootNames);
        this.getSuperClassInnerClasses(root, names);
        this.mapInnerClassNames.put(root.classStruct.qualifiedName, names);
        for (ClassesProcessor.ClassNode nested : root.nested) {
            this.collectConflictingShortNames(nested, names);
        }
    }

    private void getSuperClassInnerClasses(ClassesProcessor.ClassNode node, Map<String, String> names) {
        Map<String, StructClass> classes = DecompilerContext.getStructContext().getClasses();
        LinkedList<String> queue = new LinkedList<String>();
        StructClass currentClass = node.classStruct;
        while (currentClass != null) {
            if (currentClass.superClass != null) {
                queue.add(currentClass.superClass.getString());
            }
            Collections.addAll(queue, currentClass.getInterfaceNames());
            StructInnerClassesAttribute attribute = currentClass.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES);
            if (attribute != null) {
                for (StructInnerClassesAttribute.Entry entry : attribute.getEntries()) {
                    if (entry.enclosingName == null || !entry.enclosingName.equals(currentClass.qualifiedName)) continue;
                    names.put(entry.simpleName, entry.innerName.replace('/', '.').replace('$', '.'));
                }
            }
            StructClass structClass = currentClass = !queue.isEmpty() ? classes.get(queue.removeFirst()) : null;
            while (currentClass == null && !queue.isEmpty()) {
                currentClass = classes.get(queue.removeFirst());
            }
        }
    }
}

