/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.File;
import java.util.HashSet;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.struct.StructContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ClasspathScanner {
    public static void addAllClasspath(StructContext ctx) {
        String[] props;
        HashSet<String> found = new HashSet<String>();
        for (String prop : props = new String[]{System.getProperty("java.class.path"), System.getProperty("sun.boot.class.path")}) {
            if (prop == null) continue;
            for (String path : prop.split(File.pathSeparator)) {
                File file = new File(path);
                if (found.contains(file.getAbsolutePath()) || !file.exists() || !file.getName().endsWith(".class") && !file.getName().endsWith(".jar")) continue;
                DecompilerContext.getLogger().writeMessage("Adding File to context from classpath: " + file, IFernflowerLogger.Severity.INFO);
                ctx.addSpace(file, false);
                found.add(file.getAbsolutePath());
            }
        }
    }
}

