/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class NewExprent
extends Exprent {
    private InvocationExprent constructor;
    private final VarType newType;
    private List<Exprent> lstDims = new ArrayList<Exprent>();
    private List<Exprent> lstArrayElements = new ArrayList<Exprent>();
    private boolean directArrayInit;
    private boolean isVarArgParam;
    private boolean anonymous;
    private boolean lambda;
    private boolean methodReference = false;
    private boolean enumConst;
    private List<VarType> genericArgs = new ArrayList<VarType>();
    private VarType inferredLambdaType = null;

    public NewExprent(VarType newType, ListStack<Exprent> stack, int arrayDim, BitSet bytecodeOffsets) {
        this(newType, NewExprent.getDimensions(arrayDim, stack), bytecodeOffsets);
    }

    public NewExprent(VarType newType, List<Exprent> lstDims, BitSet bytecodeOffsets) {
        super(10);
        ClassesProcessor.ClassNode node;
        this.newType = newType;
        this.lstDims = lstDims;
        this.anonymous = false;
        this.lambda = false;
        if (newType.type == 8 && newType.arrayDim == 0 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(newType.value)) != null && (node.type == 2 || node.type == 8)) {
            this.anonymous = true;
            if (node.type == 8) {
                this.lambda = true;
                this.methodReference = node.lambdaInformation.is_method_reference;
            }
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private static List<Exprent> getDimensions(int arrayDim, ListStack<Exprent> stack) {
        ArrayList<Exprent> lstDims = new ArrayList<Exprent>();
        for (int i = 0; i < arrayDim; ++i) {
            lstDims.add(0, stack.pop());
        }
        return lstDims;
    }

    @Override
    public VarType getExprType() {
        return this.anonymous ? DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)this.newType.value).anonymousClassType : this.newType;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        Object node;
        this.genericArgs.clear();
        if (!this.lambda && this.newType.type == 8) {
            node = DecompilerContext.getStructContext().getClass(this.newType.value);
            if (node != null && ((StructClass)node).getSignature() != null && this.newType.arrayDim == 0 && !((StructClass)node).getSignature().fparameters.isEmpty()) {
                GenericClassDescriptor sig = ((StructClass)node).getSignature();
                if (this.constructor != null) {
                    return this.constructor.getInferredExprType(upperBound);
                }
                HashMap<VarType, VarType> genericsMap = new HashMap<VarType, VarType>();
                this.gatherGenerics(upperBound, sig.genericType, genericsMap);
                this.getGenericArgs(sig.fparameters, genericsMap, this.genericArgs);
                VarType _new = sig.genericType.remap(genericsMap);
                if (sig.genericType != _new) {
                    return _new;
                }
            } else if (this.newType.arrayDim > 0 && !this.lstArrayElements.isEmpty() && this.newType.value.equals(VarType.VARTYPE_OBJECT.value)) {
                VarType first = this.lstArrayElements.get(0).getInferredExprType(null);
                if (first.type == 18) {
                    boolean matches = true;
                    for (int i = 1; i < this.lstArrayElements.size(); ++i) {
                        VarType type = this.lstArrayElements.get(i).getInferredExprType(null);
                        if (type.equals(first)) continue;
                        matches = false;
                        break;
                    }
                    if (matches) {
                        return first.resizeArrayDim(this.newType.arrayDim);
                    }
                }
            }
        }
        if (this.lambda && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value)) != null) {
            VarType classType = ((ClassesProcessor.ClassNode)node).anonymousClassType;
            StructClass cls = DecompilerContext.getStructContext().getClass(classType.value);
            MethodDescriptor desc = MethodDescriptor.parseDescriptor(((ClassesProcessor.ClassNode)node).lambdaInformation.method_descriptor);
            StructClass methodCls = DecompilerContext.getStructContext().getClass(((ClassesProcessor.ClassNode)node).lambdaInformation.content_class_name);
            if (cls != null && cls.getSignature() != null && methodCls != null) {
                StructMethod refMethod = cls.getMethod(this.getLambdaMethodKey());
                StructMethod method = methodCls.getMethod(((ClassesProcessor.ClassNode)node).lambdaInformation.content_method_name, ((ClassesProcessor.ClassNode)node).lambdaInformation.content_method_descriptor);
                if (method != null && refMethod != null && refMethod.getSignature() != null) {
                    VarType _new;
                    GenericType ret = cls.getSignature().genericType;
                    HashMap<VarType, VarType> genericsMap = new HashMap<VarType, VarType>();
                    Map<VarType, List<VarType>> named = this.getNamedGenerics();
                    this.gatherGenerics(upperBound, ret, genericsMap);
                    for (VarType from : new HashSet<VarType>(genericsMap.keySet())) {
                        VarType to = genericsMap.get(from);
                        if (to != null && (to.type != 18 || named.containsKey(to))) continue;
                        genericsMap.remove(from);
                    }
                    HashMap<VarType, VarType> instanceMap = new HashMap<VarType, VarType>();
                    if (this.isMethodReference() && methodCls.getSignature() != null) {
                        VarType current;
                        VarType first = ret.getArguments().get(0);
                        if (this.constructor.getInstance() != null) {
                            VarType instanceType = this.constructor.getInstance().getInferredExprType(null);
                            if (instanceType.isGeneric()) {
                                methodCls.getSignature().genericType.mapGenVarsTo((GenericType)instanceType, instanceMap);
                            }
                        } else if (genericsMap.containsKey(first) && (current = genericsMap.get(first)).isGeneric()) {
                            methodCls.getSignature().genericType.mapGenVarsTo((GenericType)current, instanceMap);
                        }
                    }
                    List<VarType> types = method.getSignature() != null ? method.getSignature().parameterTypes : Arrays.asList(desc.params);
                    for (int i = 0; i < types.size(); ++i) {
                        if (refMethod.getSignature().parameterTypes.get((int)i).type != 18 || genericsMap.containsKey(refMethod.getSignature().parameterTypes.get(i)) || types.get(i).equals(VarType.VARTYPE_OBJECT) && named.containsKey(refMethod.getSignature().parameterTypes.get(i))) continue;
                        VarType realType = types.get(i);
                        StructClass typeCls = DecompilerContext.getStructContext().getClass(realType.value);
                        if (typeCls != null && typeCls.getSignature() != null && !realType.equals(typeCls.getSignature().genericType)) {
                            realType = typeCls.getSignature().genericType.resizeArrayDim(realType.arrayDim);
                        }
                        genericsMap.put(refMethod.getSignature().parameterTypes.get(i), realType);
                    }
                    if (refMethod.getSignature().returnType.type == 18) {
                        VarType key = refMethod.getSignature().returnType;
                        if (method.getName().equals("<init>")) {
                            if (methodCls.getSignature() != null) {
                                genericsMap.put(key, methodCls.getSignature().genericType);
                            } else {
                                genericsMap.put(key, GenericType.parse("L" + methodCls.qualifiedName + ";"));
                            }
                        } else if (method.getSignature() != null || !desc.ret.equals(VarType.VARTYPE_OBJECT)) {
                            boolean add;
                            VarType retUB;
                            VarType realType;
                            StructClass retCls;
                            VarType current = genericsMap.get(key);
                            VarType returnType = method.getSignature() != null ? method.getSignature().returnType.remap(instanceMap) : desc.ret;
                            StructClass structClass = retCls = returnType == null ? null : DecompilerContext.getStructContext().getClass(returnType.value);
                            if (!this.isMethodReference() && retCls != null && retCls.getSignature() != null && !retCls.getSignature().genericType.equalsExact(returnType) && (realType = NewExprent.getLambdaReturnType((ClassesProcessor.ClassNode)node, refMethod, retUB = current != null && current.equals(returnType) ? current : returnType, genericsMap)) != null) {
                                returnType = realType;
                            }
                            boolean bl = add = current == null || returnType == null || returnType.isGeneric() || !returnType.equals(genericsMap.get(key)) && (current.type != 18 || !named.containsKey(current));
                            if (add) {
                                genericsMap.put(key, returnType);
                            }
                        }
                    }
                    if (!(genericsMap.isEmpty() || (_new = ret.remap(genericsMap)) == ret || _new.isGeneric() && ((GenericType)_new).hasUnknownGenericType(named.keySet()))) {
                        this.inferredLambdaType = _new;
                        return this.inferredLambdaType;
                    }
                }
            }
        }
        return this.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.newType.arrayDim != 0) {
            for (Exprent dim : this.lstDims) {
                result.addMinTypeExprent(dim, VarType.VARTYPE_BYTECHAR);
                result.addMaxTypeExprent(dim, VarType.VARTYPE_INT);
            }
            if (this.newType.arrayDim == 1) {
                VarType leftType = this.newType.decreaseArrayDim();
                for (Exprent element : this.lstArrayElements) {
                    result.addMinTypeExprent(element, VarType.getMinTypeInFamily(leftType.typeFamily));
                    result.addMaxTypeExprent(element, leftType);
                }
            }
        } else if (this.constructor != null) {
            return this.constructor.checkExprTypeBounds();
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.newType.arrayDim != 0) {
            lst.addAll(this.lstDims);
            lst.addAll(this.lstArrayElements);
        } else if (this.constructor != null) {
            Exprent constructor = this.constructor.getInstance();
            if (constructor != null) {
                lst.add(constructor);
            }
            lst.addAll(this.constructor.getLstParameters());
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        for (Exprent expr : this.lstDims) {
            lst.add(expr.copy());
        }
        NewExprent ret = new NewExprent(this.newType, lst, this.bytecode);
        ret.setConstructor(this.constructor == null ? null : (InvocationExprent)this.constructor.copy());
        ret.setLstArrayElements(this.lstArrayElements);
        ret.setDirectArrayInit(this.directArrayInit);
        ret.setAnonymous(this.anonymous);
        ret.setEnumConst(this.enumConst);
        return ret;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        if (this.anonymous) {
            boolean selfReference;
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value);
            boolean bl = selfReference = DecompilerContext.getProperty("CURRENT_CLASS_NODE") == child;
            if (!(this.enumConst || this.lambda && !DecompilerContext.getOption("lac"))) {
                String enclosing = null;
                if (!this.lambda && this.constructor != null && (enclosing = NewExprent.getQualifiedNewInstance(child.anonymousClassType.value, this.constructor.getLstParameters(), indent, tracer)) != null) {
                    buf.append(enclosing).append('.');
                }
                buf.append("new ");
                if (selfReference) {
                    buf.append("<anonymous constructor>");
                } else {
                    GenericClassDescriptor descriptor;
                    String typename = ExprProcessor.getCastTypeName(child.anonymousClassType);
                    if (enclosing != null) {
                        ClassesProcessor.ClassNode anonymousNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(child.anonymousClassType.value);
                        typename = anonymousNode != null ? anonymousNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                    }
                    if ((descriptor = child.getWrapper().getClassStruct().getSignature()) != null) {
                        if (descriptor.superinterfaces.isEmpty()) {
                            buf.append(ExprProcessor.getCastTypeName(descriptor.superclass));
                        } else {
                            if (descriptor.superinterfaces.size() > 1 && !this.lambda) {
                                DecompilerContext.getLogger().writeMessage("Inconsistent anonymous class signature: " + child.classStruct.qualifiedName, IFernflowerLogger.Severity.WARN);
                            }
                            buf.append(ExprProcessor.getCastTypeName(descriptor.superinterfaces.get(0)));
                        }
                    } else {
                        buf.append(typename);
                    }
                }
            }
            if (!this.lambda && this.constructor != null) {
                this.appendParameters(buf, this.constructor.getGenericArgs());
                buf.append('(').append(this.constructor.appendParamList(indent, tracer));
            } else {
                this.appendParameters(buf, this.genericArgs);
                buf.append('(');
            }
            buf.append(')');
            if (this.enumConst && buf.length() == 2) {
                buf.setLength(0);
            }
            if (this.lambda) {
                if (!DecompilerContext.getOption("lac")) {
                    buf.setLength(0);
                }
                this.setLambdaGenericTypes();
                Exprent methodObject = this.constructor == null ? null : this.constructor.getInstance();
                TextBuffer clsBuf = new TextBuffer();
                new ClassWriter().classLambdaToJava(child, clsBuf, methodObject, indent, tracer);
                buf.append(clsBuf);
                tracer.incrementCurrentSourceLine(clsBuf.countLines());
            } else if (!selfReference) {
                TextBuffer clsBuf = new TextBuffer();
                new ClassWriter().classToJava(child, clsBuf, indent, tracer);
                buf.append(clsBuf);
                tracer.incrementCurrentSourceLine(clsBuf.countLines());
            }
        } else if (this.directArrayInit) {
            VarType leftType = this.newType.decreaseArrayDim();
            buf.append('{');
            for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
            }
            buf.append('}');
        } else if (this.newType.arrayDim == 0) {
            if (!this.enumConst) {
                String enclosing = null;
                if (this.constructor != null && (enclosing = NewExprent.getQualifiedNewInstance(this.newType.value, this.constructor.getLstParameters(), indent, tracer)) != null) {
                    buf.append(enclosing).append('.');
                }
                buf.append("new ");
                String typename = ExprProcessor.getTypeName(this.newType);
                if (enclosing != null) {
                    ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value);
                    typename = newNode != null ? newNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                }
                buf.append(typename);
            }
            if (this.constructor != null) {
                int start;
                int n = start = this.enumConst ? 2 : 0;
                if (!this.enumConst || start < this.constructor.getLstParameters().size()) {
                    this.appendParameters(buf, this.constructor.getGenericArgs());
                    buf.append('(').append(this.constructor.appendParamList(indent, tracer)).append(')');
                }
            }
        } else if (this.isVarArgParam) {
            VarType leftType = this.newType.decreaseArrayDim();
            for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                Exprent element = this.lstArrayElements.get(i);
                if (element.type == 10) {
                    ((NewExprent)element).setDirectArrayInit(false);
                }
                ExprProcessor.getCastedExprent(element, leftType, buf, indent, false, tracer);
            }
            if (this.lstArrayElements.size() == 1) {
                VarType elementType = this.lstArrayElements.get(0).getExprType();
                if (elementType.type == 8 && elementType.value.equals("java/lang/Object") && elementType.arrayDim >= 1) {
                    buf.prepend("(Object)");
                }
            }
        } else {
            buf.append("new ").append(ExprProcessor.getTypeName(this.newType));
            if (this.lstArrayElements.isEmpty()) {
                for (int i = 0; i < this.newType.arrayDim; ++i) {
                    buf.append('[');
                    if (i < this.lstDims.size()) {
                        buf.append(this.lstDims.get(i).toJava(indent, tracer));
                    }
                    buf.append(']');
                }
            } else {
                for (int i = 0; i < this.newType.arrayDim; ++i) {
                    buf.append("[]");
                }
                VarType leftType = this.newType.decreaseArrayDim();
                buf.append('{');
                for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
                }
                buf.append('}');
            }
        }
        return buf;
    }

    public static boolean probablySyntheticParameter(String className) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(className);
        return node != null && node.type == 2;
    }

    private static String getQualifiedNewInstance(String classname, List<Exprent> lstParams, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
        if (node != null && node.type != 0 && node.type != 4 && (node.access & 8) == 0 && !lstParams.isEmpty()) {
            Exprent enclosing = lstParams.get(0);
            boolean isQualifiedNew = false;
            if (enclosing.type == 12) {
                VarExprent varEnclosing = (VarExprent)enclosing;
                StructClass current_class = ((ClassesProcessor.ClassNode)DecompilerContext.getProperty((String)"CURRENT_CLASS_NODE")).classStruct;
                String this_classname = varEnclosing.getProcessor().getThisVars().get(new VarVersionPair(varEnclosing));
                if (!current_class.qualifiedName.equals(this_classname)) {
                    isQualifiedNew = true;
                }
            } else {
                isQualifiedNew = true;
            }
            if (isQualifiedNew) {
                return enclosing.toJava(indent, tracer).toString();
            }
        }
        return null;
    }

    private static VarType getLambdaReturnType(ClassesProcessor.ClassNode node, StructMethod desc, VarType upperBound, Map<VarType, VarType> genericsMap) {
        MethodWrapper mt;
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper != null && (mt = wrapper.getMethodWrapper(node.lambdaInformation.content_method_name, node.lambdaInformation.content_method_descriptor)) != null && mt.root != null) {
            ArrayList<String> paramNames = new ArrayList<String>();
            MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
            MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
            int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
            int start_index = md_content.params.length - md_lambda.params.length;
            int j = 0;
            for (int i = 0; i < md_content.params.length; ++i) {
                if (i >= start_index) {
                    VarType infType;
                    VarVersionPair vpp = new VarVersionPair(index, 0);
                    VarType curType = mt.varproc.getVarType(vpp);
                    if ((infType = desc.getSignature().parameterTypes.get(j++).remap(genericsMap)) != null && !infType.equals(VarType.VARTYPE_VOID) && (!curType.equals(infType) || infType.isGeneric() && !((GenericType)infType).equalsExact(curType))) {
                        String varName = mt.varproc.getVarName(vpp);
                        paramNames.add(varName);
                        inferredLambdaTypes.put(varName, infType);
                    }
                }
                index += md_content.params[i].stackSize;
            }
            DummyExitStatement dummyExit = mt.root.getDummyExit();
            for (StatEdge edge : dummyExit.getAllPredecessorEdges()) {
                VarType realRetType;
                ExitExprent ex;
                Statement source = edge.getSource();
                List<Exprent> lstExpr = source.getExprents();
                if (lstExpr == null || lstExpr.isEmpty()) continue;
                Exprent expr = lstExpr.get(lstExpr.size() - 1);
                if (expr.type != 4 || (ex = (ExitExprent)expr).getExitType() != 0 || !(realRetType = ex.getValue().getInferredExprType(upperBound)).isGeneric()) continue;
                paramNames.forEach(inferredLambdaTypes::remove);
                return realRetType;
            }
            paramNames.forEach(inferredLambdaTypes::remove);
        }
        return null;
    }

    private void setLambdaGenericTypes() {
        if (this.inferredLambdaType != null && this.inferredLambdaType.isGeneric()) {
            ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value);
            StructClass cls = DecompilerContext.getStructContext().getClass(this.inferredLambdaType.value);
            if (node != null && cls != null) {
                MethodWrapper methodWrapper;
                StructMethod desc = cls.getMethod(this.getLambdaMethodKey());
                ClassWrapper wrapper = node.getWrapper();
                MethodWrapper methodWrapper2 = methodWrapper = wrapper != null ? wrapper.getMethodWrapper(node.lambdaInformation.content_method_name, node.lambdaInformation.content_method_descriptor) : null;
                if (desc != null && desc.getSignature() != null && methodWrapper != null && methodWrapper.root != null) {
                    if (!desc.getClassStruct().qualifiedName.equals(this.inferredLambdaType.value) && desc.getClassStruct().getSignature() != null) {
                        cls = desc.getClassStruct();
                        this.inferredLambdaType = GenericType.getGenericSuperType(this.inferredLambdaType, desc.getClassStruct().getSignature().genericType);
                    }
                    HashMap<VarType, VarType> tempMap = new HashMap<VarType, VarType>();
                    cls.getSignature().genericType.mapGenVarsTo((GenericType)this.inferredLambdaType, tempMap);
                    MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                    MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                    int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
                    int start_index = md_content.params.length - md_lambda.params.length;
                    int j = 0;
                    for (int i = 0; i < md_content.params.length; ++i) {
                        if (i >= start_index) {
                            VarType infType;
                            VarVersionPair vpp = new VarVersionPair(index, 0);
                            VarType curType = methodWrapper.varproc.getVarType(vpp);
                            if ((infType = desc.getSignature().parameterTypes.get(j++).remap(tempMap)) != null && !infType.equals(VarType.VARTYPE_VOID) && (!curType.equals(infType) || infType.isGeneric() && !((GenericType)infType).equalsExact(curType))) {
                                methodWrapper.varproc.setVarType(vpp, infType);
                                String paramName = methodWrapper.varproc.getVarName(vpp);
                                LinkedList<ClassesProcessor.ClassNode> nested = new LinkedList<ClassesProcessor.ClassNode>(node.nested);
                                while (!nested.isEmpty()) {
                                    MethodWrapper enclosedMethod;
                                    ClassesProcessor.ClassNode childNode = nested.removeFirst();
                                    nested.addAll(childNode.nested);
                                    if (childNode.type != 8 || childNode.lambdaInformation.is_method_reference || (enclosedMethod = wrapper.getMethodWrapper(childNode.lambdaInformation.content_method_name, childNode.lambdaInformation.content_method_descriptor)) == null || !paramName.equals(enclosedMethod.varproc.getVarName(vpp))) continue;
                                    enclosedMethod.varproc.setVarType(vpp, infType);
                                }
                            }
                        }
                        index += md_content.params[i].stackSize;
                    }
                    VarType curType = md_content.ret;
                    VarType infType = desc.getSignature().returnType.remap(tempMap);
                    if (infType != null && !infType.equals(VarType.VARTYPE_VOID) && (!curType.equals(infType) || infType.isGeneric() && !((GenericType)infType).equalsExact(curType))) {
                        GenericMethodDescriptor genDesc = new GenericMethodDescriptor(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), infType, Collections.emptyList());
                        DummyExitStatement dummyExit = methodWrapper.root.getDummyExit();
                        for (StatEdge edge : dummyExit.getAllPredecessorEdges()) {
                            ExitExprent ex;
                            Statement source = edge.getSource();
                            List<Exprent> lstExpr = source.getExprents();
                            if (lstExpr == null || lstExpr.isEmpty()) continue;
                            Exprent expr = lstExpr.get(lstExpr.size() - 1);
                            if (expr.type != 4 || (ex = (ExitExprent)expr).getExitType() != 0) continue;
                            ex.getMethodDescriptor().genericInfo = genDesc;
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        int i;
        if (oldExpr == this.constructor) {
            this.constructor = (InvocationExprent)newExpr;
        }
        if (this.constructor != null) {
            this.constructor.replaceExprent(oldExpr, newExpr);
        }
        for (i = 0; i < this.lstDims.size(); ++i) {
            if (oldExpr != this.lstDims.get(i)) continue;
            this.lstDims.set(i, newExpr);
        }
        for (i = 0; i < this.lstArrayElements.size(); ++i) {
            if (oldExpr != this.lstArrayElements.get(i)) continue;
            this.lstArrayElements.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewExprent)) {
            return false;
        }
        NewExprent ne = (NewExprent)o;
        return InterpreterUtil.equalObjects(this.newType, ne.getNewType()) && InterpreterUtil.equalLists(this.lstDims, ne.getLstDims()) && InterpreterUtil.equalObjects(this.constructor, ne.getConstructor()) && this.directArrayInit == ne.directArrayInit && InterpreterUtil.equalLists(this.lstArrayElements, ne.getLstArrayElements());
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        NewExprent.measureBytecode(values, this.lstArrayElements);
        NewExprent.measureBytecode(values, this.lstDims);
        NewExprent.measureBytecode(values, this.constructor);
        this.measureBytecode(values);
    }

    public InvocationExprent getConstructor() {
        return this.constructor;
    }

    public void setConstructor(InvocationExprent constructor) {
        this.constructor = constructor;
    }

    public List<Exprent> getLstDims() {
        return this.lstDims;
    }

    public VarType getNewType() {
        return this.newType;
    }

    public List<Exprent> getLstArrayElements() {
        return this.lstArrayElements;
    }

    public void setLstArrayElements(List<Exprent> lstArrayElements) {
        this.lstArrayElements = lstArrayElements;
    }

    public void setDirectArrayInit(boolean directArrayInit) {
        this.directArrayInit = directArrayInit;
    }

    public void setVarArgParam(boolean isVarArgParam) {
        this.isVarArgParam = isVarArgParam;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setEnumConst(boolean enumConst) {
        this.enumConst = enumConst;
    }

    public boolean isMethodReference() {
        return this.methodReference;
    }

    public String getLambdaMethodKey() {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value);
        if (node != null && this.constructor != null) {
            String descriptor = ((PrimitiveConstant)this.constructor.getBootstrapArguments().get(0)).getString();
            return InterpreterUtil.makeUniqueKey(node.lambdaInformation.method_name, descriptor);
        }
        return "";
    }

    @Override
    public void setInvocationInstance() {
        if (this.constructor != null) {
            this.constructor.setInvocationInstance();
        }
    }
}

