/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class ConstExprent
extends Exprent {
    private static final Map<Integer, String> CHAR_ESCAPES = new HashMap<Integer, String>();
    private static final Map<Double, String[]> PI_DOUBLES;
    private static final Map<Float, String[]> PI_FLOATS;
    private VarType constType;
    private final Object value;
    private final boolean boolPermitted;

    public ConstExprent(int val, boolean boolPermitted, BitSet bytecodeOffsets) {
        this(ConstExprent.guessType(val, boolPermitted), val, boolPermitted, bytecodeOffsets);
    }

    public ConstExprent(VarType constType, Object value, BitSet bytecodeOffsets) {
        this(constType, value, false, bytecodeOffsets);
    }

    private ConstExprent(VarType constType, Object value, boolean boolPermitted, BitSet bytecodeOffsets) {
        super(3);
        this.constType = constType;
        this.value = value;
        this.boolPermitted = boolPermitted;
        this.addBytecodeOffsets(bytecodeOffsets);
        if (constType.equals(VarType.VARTYPE_CLASS) && value != null) {
            String stringVal;
            List<VarType> args = Collections.singletonList(new VarType(stringVal, !(stringVal = value.toString()).startsWith("[")));
            this.constType = new GenericType(constType.type, constType.arrayDim, constType.value, null, args, 4);
        }
    }

    private static VarType guessType(int val, boolean boolPermitted) {
        if (boolPermitted) {
            VarType constType = VarType.VARTYPE_BOOLEAN;
            if (val != 0 && val != 1) {
                constType = constType.copy(true);
            }
            return constType;
        }
        if (0 <= val && val <= 127) {
            return VarType.VARTYPE_BYTECHAR;
        }
        if (-128 <= val && val <= 127) {
            return VarType.VARTYPE_BYTE;
        }
        if (0 <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORTCHAR;
        }
        if (Short.MIN_VALUE <= val && val <= Short.MAX_VALUE) {
            return VarType.VARTYPE_SHORT;
        }
        if (0 <= val && val <= 65535) {
            return VarType.VARTYPE_CHAR;
        }
        return VarType.VARTYPE_INT;
    }

    @Override
    public Exprent copy() {
        return new ConstExprent(this.constType, this.value, this.bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.constType;
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        boolean literal = DecompilerContext.getOption("lit");
        boolean ascii = DecompilerContext.getOption("asc");
        tracer.addMapping(this.bytecode);
        if (this.constType.type != 13 && this.value == null) {
            return new TextBuffer(ExprProcessor.getCastTypeName(this.constType));
        }
        switch (this.constType.type) {
            case 7: {
                return new TextBuffer(Boolean.toString((Integer)this.value != 0));
            }
            case 1: {
                Integer val = (Integer)this.value;
                String ret = CHAR_ESCAPES.get(val);
                if (ret == null) {
                    char c = (char)val.intValue();
                    ret = ConstExprent.isPrintableAscii(c) || !ascii && TextUtil.isPrintableUnicode(c) ? String.valueOf(c) : TextUtil.charToUnicodeLiteral(c);
                }
                return new TextBuffer(ret).enclose("'", "'");
            }
            case 0: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                int intVal = (Integer)this.value;
                if (!literal) {
                    if (intVal == Integer.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (intVal == Integer.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Integer", true, null, FieldDescriptor.INTEGER_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                return new TextBuffer(this.value.toString());
            }
            case 5: {
                long longVal = (Long)this.value;
                if (!literal) {
                    if (longVal == Long.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (longVal == Long.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Long", true, null, FieldDescriptor.LONG_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                }
                return new TextBuffer(this.value.toString()).append('L');
            }
            case 3: {
                return this.createFloat(literal, ((Float)this.value).floatValue(), tracer);
            }
            case 2: {
                double doubleVal = (Double)this.value;
                if (!literal) {
                    if (Double.isNaN(doubleVal)) {
                        return new FieldExprent("NaN", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY) {
                        return new FieldExprent("POSITIVE_INFINITY", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY) {
                        return new FieldExprent("NEGATIVE_INFINITY", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MAX_VALUE) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MIN_NORMAL) {
                        return new FieldExprent("MIN_NORMAL", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == Double.MIN_VALUE) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (doubleVal == -1.7976931348623157E308) {
                        return new FieldExprent("MAX_VALUE", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
                    }
                    if (doubleVal == -2.2250738585072014E-308) {
                        return new FieldExprent("MIN_NORMAL", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
                    }
                    if (doubleVal == -4.9E-324) {
                        return new FieldExprent("MIN_VALUE", "java/lang/Double", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
                    }
                    if (doubleVal == Math.E) {
                        return new FieldExprent("E", "java/lang/Math", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
                    }
                    if (PI_DOUBLES.containsKey(doubleVal)) {
                        String[] parts = PI_DOUBLES.get(doubleVal);
                        return this.getPiDouble(tracer).enclose(parts[0], parts[1]);
                    }
                    float nearestFloatVal = (float)doubleVal;
                    if (doubleVal == (double)nearestFloatVal && Float.toString(nearestFloatVal).length() < Double.toString(doubleVal).length()) {
                        return this.createFloat(literal, nearestFloatVal, tracer).prepend("(double)");
                    }
                } else {
                    if (Double.isNaN(doubleVal)) {
                        return new TextBuffer("0.0D / 0.0D");
                    }
                    if (doubleVal == Double.POSITIVE_INFINITY) {
                        return new TextBuffer("1.0D / 0.0D");
                    }
                    if (doubleVal == Double.NEGATIVE_INFINITY) {
                        return new TextBuffer("-1.0D / 0.0D");
                    }
                }
                return new TextBuffer(ConstExprent.trimZeros(this.value.toString())).append('D');
            }
            case 13: {
                return new TextBuffer("null");
            }
            case 8: {
                String stringVal;
                if (this.constType.equals(VarType.VARTYPE_STRING)) {
                    return new TextBuffer(ConstExprent.convertStringToJava(this.value.toString(), ascii)).enclose("\"", "\"");
                }
                if (!this.constType.equals(VarType.VARTYPE_CLASS)) break;
                VarType type = new VarType(stringVal, !(stringVal = this.value.toString()).startsWith("["));
                return new TextBuffer(ExprProcessor.getCastTypeName(type)).append(".class");
            }
        }
        throw new RuntimeException("invalid constant type: " + this.constType);
    }

    private TextBuffer createFloat(boolean literal, float floatVal, BytecodeMappingTracer tracer) {
        if (!literal) {
            if (Float.isNaN(floatVal)) {
                return new FieldExprent("NaN", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.POSITIVE_INFINITY) {
                return new FieldExprent("POSITIVE_INFINITY", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.NEGATIVE_INFINITY) {
                return new FieldExprent("NEGATIVE_INFINITY", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.MAX_VALUE) {
                return new FieldExprent("MAX_VALUE", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.MIN_NORMAL) {
                return new FieldExprent("MIN_NORMAL", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == Float.MIN_VALUE) {
                return new FieldExprent("MIN_VALUE", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer);
            }
            if (floatVal == -3.4028235E38f) {
                return new FieldExprent("MAX_VALUE", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
            }
            if (floatVal == -1.1754944E-38f) {
                return new FieldExprent("MIN_NORMAL", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
            }
            if (floatVal == -1.4E-45f) {
                return new FieldExprent("MIN_VALUE", "java/lang/Float", true, null, FieldDescriptor.FLOAT_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("-");
            }
            if (floatVal == (float)Math.E) {
                return new FieldExprent("E", "java/lang/Math", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer).prepend("(float)");
            }
            if (PI_FLOATS.containsKey(Float.valueOf(floatVal))) {
                String[] parts = PI_FLOATS.get(Float.valueOf(floatVal));
                return this.getPiFloat(tracer).enclose(parts[0], parts[1]);
            }
        } else {
            if (Float.isNaN(floatVal)) {
                return new TextBuffer("0.0F / 0.0F");
            }
            if (floatVal == Float.POSITIVE_INFINITY) {
                return new TextBuffer("1.0F / 0.0F");
            }
            if (floatVal == Float.NEGATIVE_INFINITY) {
                return new TextBuffer("-1.0F / 0.0F");
            }
        }
        return new TextBuffer(ConstExprent.trimZeros(Float.toString(floatVal))).append('F');
    }

    private TextBuffer getPiDouble(BytecodeMappingTracer tracer) {
        return new FieldExprent("PI", "java/lang/Math", true, null, FieldDescriptor.DOUBLE_DESCRIPTOR, this.bytecode).toJava(0, tracer);
    }

    private TextBuffer getPiFloat(BytecodeMappingTracer tracer) {
        return this.getPiDouble(tracer).prepend("(float)");
    }

    private static String trimZeros(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && value.charAt(i) == '0'; --i) {
        }
        if (value.charAt(i) == '.') {
            ++i;
        }
        return value.substring(0, i + 1);
    }

    public boolean isNull() {
        return 13 == this.constType.type;
    }

    private static String convertStringToJava(String value, boolean ascii) {
        char[] arr = value.toCharArray();
        StringBuilder buffer = new StringBuilder(arr.length);
        block9: for (char c : arr) {
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block9;
                }
                default: {
                    if (ConstExprent.isPrintableAscii(c) || !ascii && TextUtil.isPrintableUnicode(c)) {
                        buffer.append(c);
                        continue block9;
                    }
                    buffer.append(TextUtil.charToUnicodeLiteral(c));
                }
            }
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstExprent)) {
            return false;
        }
        ConstExprent cn = (ConstExprent)o;
        return InterpreterUtil.equalObjects(this.constType, cn.getConstType()) && InterpreterUtil.equalObjects(this.value, cn.getValue());
    }

    public int hashCode() {
        int result = this.constType != null ? this.constType.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public boolean hasBooleanValue() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                int value = (Integer)this.value;
                return value == 0 || DecompilerContext.getOption("bto") && value == 1;
            }
        }
        return false;
    }

    public boolean hasValueOne() {
        switch (this.constType.type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return (Integer)this.value == 1;
            }
            case 5: {
                return ((Long)this.value).intValue() == 1;
            }
            case 2: {
                return ((Double)this.value).intValue() == 1;
            }
            case 3: {
                return ((Float)this.value).intValue() == 1;
            }
        }
        return false;
    }

    public static ConstExprent getZeroConstant(int type) {
        switch (type) {
            case 4: {
                return new ConstExprent(VarType.VARTYPE_INT, 0, null);
            }
            case 5: {
                return new ConstExprent(VarType.VARTYPE_LONG, 0L, null);
            }
            case 2: {
                return new ConstExprent(VarType.VARTYPE_DOUBLE, 0.0, null);
            }
            case 3: {
                return new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(0.0f), null);
            }
        }
        throw new RuntimeException("Invalid argument: " + type);
    }

    public VarType getConstType() {
        return this.constType;
    }

    public void setConstType(VarType constType) {
        this.constType = constType;
    }

    public void adjustConstType(VarType expectedType) {
        if ((expectedType.equals(VarType.VARTYPE_CHAR) || expectedType.equals(VarType.VARTYPE_CHARACTER)) && (this.constType.equals(VarType.VARTYPE_BYTECHAR) || this.constType.equals(VarType.VARTYPE_SHORTCHAR))) {
            int intValue = this.getIntValue();
            if (ConstExprent.isPrintableAscii(intValue) || CHAR_ESCAPES.containsKey(intValue)) {
                this.setConstType(VarType.VARTYPE_CHAR);
            }
        } else if ((expectedType.equals(VarType.VARTYPE_INT) || expectedType.equals(VarType.VARTYPE_INTEGER)) && this.constType.typeFamily == 2) {
            this.setConstType(VarType.VARTYPE_INT);
        }
    }

    private static boolean isPrintableAscii(int c) {
        return c >= 32 && c < 127;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public boolean isBoolPermitted() {
        return this.boolPermitted;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        this.measureBytecode(values);
    }

    @Override
    public String toString() {
        return "const(" + this.toJava(0, new BytecodeMappingTracer()) + ")";
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_CONSTTYPE ? !value.value.equals(this.constType) : key == IMatchable.MatchProperties.EXPRENT_CONSTVALUE && value.isVariable() && !engine.checkAndSetVariableValue(value.value.toString(), this.value))) continue;
            return false;
        }
        return true;
    }

    static {
        CHAR_ESCAPES.put(8, "\\b");
        CHAR_ESCAPES.put(9, "\\t");
        CHAR_ESCAPES.put(10, "\\n");
        CHAR_ESCAPES.put(12, "\\f");
        CHAR_ESCAPES.put(13, "\\r");
        CHAR_ESCAPES.put(39, "\\'");
        CHAR_ESCAPES.put(92, "\\\\");
        PI_DOUBLES = new HashMap<Double, String[]>();
        PI_FLOATS = new HashMap<Float, String[]>();
        double PI_D = Math.PI;
        float PI_F = (float)Math.PI;
        PI_DOUBLES.put(Math.PI, new String[]{"", ""});
        PI_DOUBLES.put(-Math.PI, new String[]{"-", ""});
        PI_FLOATS.put(Float.valueOf((float)Math.PI), new String[]{"", ""});
        PI_FLOATS.put(Float.valueOf((float)(-Math.PI)), new String[]{"-", ""});
        PI_DOUBLES.put(Math.PI * 2, new String[]{"(", " * 2D)"});
        PI_DOUBLES.put(Math.PI * -2, new String[]{"(-", " * 2D)"});
        PI_FLOATS.put(Float.valueOf((float)Math.PI * 2), new String[]{"(", " * 2F)"});
        PI_FLOATS.put(Float.valueOf((float)Math.PI * -2), new String[]{"(-", " * 2F)"});
        PI_DOUBLES.put(1.5707963267948966, new String[]{"(", " / 2D)"});
        PI_DOUBLES.put(-1.5707963267948966, new String[]{"(-", " / 2D)"});
        PI_FLOATS.put(Float.valueOf(1.5707964f), new String[]{"(", " / 2F)"});
        PI_FLOATS.put(Float.valueOf(-1.5707964f), new String[]{"(-", " / 2F)"});
        PI_DOUBLES.put(4.71238898038469, new String[]{"(", " * 1.5D)"});
        PI_DOUBLES.put(-4.71238898038469, new String[]{"(-", " * 1.5D)"});
        PI_FLOATS.put(Float.valueOf(4.712389f), new String[]{"(", " * 1.5F)"});
        PI_FLOATS.put(Float.valueOf(-4.712389f), new String[]{"(-", " * 1.5F)"});
        PI_DOUBLES.put(1.0471975511965976, new String[]{"(", " / 3D)"});
        PI_DOUBLES.put(-1.0471975511965976, new String[]{"(-", " / 3D)"});
        PI_FLOATS.put(Float.valueOf(1.0471976f), new String[]{"(", " / 3F)"});
        PI_FLOATS.put(Float.valueOf(-1.0471976f), new String[]{"(-", " / 3F)"});
        PI_DOUBLES.put(0.7853981633974483, new String[]{"(", " / 4D)"});
        PI_DOUBLES.put(-0.7853981633974483, new String[]{"(-", " / 4D)"});
        PI_FLOATS.put(Float.valueOf(0.7853982f), new String[]{"(", " / 4F)"});
        PI_FLOATS.put(Float.valueOf(-0.7853982f), new String[]{"(-", " / 4F)"});
        PI_DOUBLES.put(0.6283185307179586, new String[]{"(", " / 5D)"});
        PI_DOUBLES.put(-0.6283185307179586, new String[]{"(-", " / 5D)"});
        PI_FLOATS.put(Float.valueOf(0.62831855f), new String[]{"(", " / 5F)"});
        PI_FLOATS.put(Float.valueOf(-0.62831855f), new String[]{"(-", " / 5F)"});
        PI_DOUBLES.put(0.5235987755982988, new String[]{"(", " / 6D)"});
        PI_DOUBLES.put(-0.5235987755982988, new String[]{"(-", " / 6D)"});
        PI_FLOATS.put(Float.valueOf(0.5235988f), new String[]{"(", " / 6F)"});
        PI_FLOATS.put(Float.valueOf(-0.5235988f), new String[]{"(-", " / 6F)"});
        PI_DOUBLES.put(0.39269908169872414, new String[]{"(", " / 8D)"});
        PI_DOUBLES.put(-0.39269908169872414, new String[]{"(-", " / 8D)"});
        PI_FLOATS.put(Float.valueOf(0.3926991f), new String[]{"(", " / 8F)"});
        PI_FLOATS.put(Float.valueOf(-0.3926991f), new String[]{"(-", " / 8F)"});
        PI_DOUBLES.put(0.3141592653589793, new String[]{"(", " / 10D)"});
        PI_DOUBLES.put(-0.3141592653589793, new String[]{"(-", " / 10D)"});
        PI_FLOATS.put(Float.valueOf(0.31415927f), new String[]{"(", " / 10F)"});
        PI_FLOATS.put(Float.valueOf(-0.31415927f), new String[]{"(-", " / 10F)"});
        PI_DOUBLES.put(Math.PI / 180, new String[]{"(", " / 180D)"});
        PI_DOUBLES.put(57.29577951308232, new String[]{"(180D / ", ")"});
        PI_FLOATS.put(Float.valueOf((float)Math.PI / 180), new String[]{"(", " / 180F)"});
        PI_FLOATS.put(Float.valueOf(57.295776f), new String[]{"(180F / ", ")"});
    }
}

