/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructClass
extends StructMember {
    public final String qualifiedName;
    public final PrimitiveConstant superClass;
    private final boolean own;
    private final LazyLoader loader;
    private final int minorVersion;
    private final int majorVersion;
    private final int[] interfaces;
    private final String[] interfaceNames;
    private final VBStyleCollection<StructField, String> fields;
    private final VBStyleCollection<StructMethod, String> methods;
    private GenericClassDescriptor signature = null;
    private ConstantPool pool;
    private Map<String, Map<VarType, VarType>> genericHiarachy;

    public StructClass(byte[] bytes, boolean own, LazyLoader loader) throws IOException {
        this(new DataInputFullStream(bytes), own, loader);
    }

    public StructClass(DataInputFullStream in, boolean own, LazyLoader loader) throws IOException {
        int i;
        this.own = own;
        this.loader = loader;
        in.discard(4);
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        this.pool = new ConstantPool(in);
        this.accessFlags = in.readUnsignedShort();
        int thisClassIdx = in.readUnsignedShort();
        int superClassIdx = in.readUnsignedShort();
        this.qualifiedName = this.pool.getPrimitiveConstant(thisClassIdx).getString();
        this.superClass = this.pool.getPrimitiveConstant(superClassIdx);
        int length = in.readUnsignedShort();
        this.interfaces = new int[length];
        this.interfaceNames = new String[length];
        for (i = 0; i < length; ++i) {
            this.interfaces[i] = in.readUnsignedShort();
            this.interfaceNames[i] = this.pool.getPrimitiveConstant(this.interfaces[i]).getString();
        }
        length = in.readUnsignedShort();
        this.fields = new VBStyleCollection(length);
        for (i = 0; i < length; ++i) {
            StructField field = new StructField(in, this);
            this.fields.addWithKey(field, InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor()));
        }
        length = in.readUnsignedShort();
        this.methods = new VBStyleCollection(length);
        for (i = 0; i < length; ++i) {
            StructMethod method = new StructMethod(in, this);
            this.methods.addWithKey(method, InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor()));
        }
        this.attributes = this.readAttributes(in, this.pool);
        this.releaseResources();
    }

    public boolean hasField(String name, String descriptor) {
        return this.getField(name, descriptor) != null;
    }

    public StructField getField(String name, String descriptor) {
        return this.fields.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethod(String key) {
        return this.methods.getWithKey(key);
    }

    public StructMethod getMethod(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethodRecursive(String name, String descriptor) {
        StructClass cls;
        StructMethod ret = this.getMethod(name, descriptor);
        if (ret != null) {
            return ret;
        }
        if (this.superClass != null && (ret = (cls = DecompilerContext.getStructContext().getClass((String)this.superClass.value)).getMethodRecursive(name, descriptor)) != null) {
            return ret;
        }
        for (String intf : this.getInterfaceNames()) {
            StructClass cls2 = DecompilerContext.getStructContext().getClass(intf);
            ret = cls2.getMethodRecursive(name, descriptor);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public String getInterface(int i) {
        return this.interfaceNames[i];
    }

    public void releaseResources() {
        if (this.loader != null) {
            this.pool = null;
        }
    }

    public ConstantPool getPool() {
        if (this.pool == null && this.loader != null) {
            this.pool = this.loader.loadPool(this.qualifiedName);
        }
        return this.pool;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public VBStyleCollection<StructMethod, String> getMethods() {
        return this.methods;
    }

    public VBStyleCollection<StructField, String> getFields() {
        return this.fields;
    }

    public boolean isOwn() {
        return this.own;
    }

    public LazyLoader getLoader() {
        return this.loader;
    }

    public boolean isVersionGE_1_5() {
        return this.majorVersion > 48 || this.majorVersion == 48 && this.minorVersion > 0;
    }

    public boolean isVersionGE_1_7() {
        return this.majorVersion >= 51;
    }

    public int getBytecodeVersion() {
        switch (this.majorVersion) {
            case 53: {
                return 6;
            }
            case 52: {
                return 5;
            }
            case 51: {
                return 4;
            }
            case 50: {
                return 3;
            }
            case 49: {
                return 2;
            }
        }
        return 1;
    }

    public String toString() {
        return this.qualifiedName;
    }

    public GenericClassDescriptor getSignature() {
        return this.signature;
    }

    @Override
    protected StructGeneralAttribute readAttribute(DataInputFullStream in, ConstantPool pool, String name) throws IOException {
        StructGeneralAttribute attribute = super.readAttribute(in, pool, name);
        if ("Signature".equals(name) && DecompilerContext.getOption("dgs")) {
            StructGenericSignatureAttribute signature = (StructGenericSignatureAttribute)attribute;
            this.signature = GenericMain.parseClassSignature(this.qualifiedName, signature.getSignature());
        }
        return attribute;
    }

    private Map<VarType, VarType> getGenericMap(VarType type) {
        if (this.signature == null || type == null || !type.isGeneric()) {
            return Collections.emptyMap();
        }
        GenericType gtype = (GenericType)type;
        if (gtype.getArguments().size() != this.signature.fparameters.size()) {
            return Collections.emptyMap();
        }
        HashMap<VarType, VarType> ret = new HashMap<VarType, VarType>();
        for (int x = 0; x < this.signature.fparameters.size(); ++x) {
            VarType var = gtype.getArguments().get(x);
            if (var == null) continue;
            ret.put(GenericType.parse("T" + this.signature.fparameters.get(x) + ";"), var);
        }
        return ret;
    }

    public Map<String, Map<VarType, VarType>> getAllGenerics() {
        StructClass cls;
        if (this.genericHiarachy != null) {
            return this.genericHiarachy;
        }
        HashMap<String, Map<Object, Object>> ret = new HashMap<String, Map<Object, Object>>();
        if (this.signature != null && !this.signature.fparameters.isEmpty()) {
            HashMap<VarType, VarType> mine = new HashMap<VarType, VarType>();
            for (String par : this.signature.fparameters) {
                VarType type = GenericType.parse("T" + par + ";");
                mine.put(type, type);
            }
            ret.put(this.qualifiedName, mine);
        }
        HashSet<String> visited = new HashSet<String>();
        if (this.signature != null) {
            for (VarType intf : this.signature.superinterfaces) {
                visited.add(intf.value);
                StructClass cls2 = DecompilerContext.getStructContext().getClass(intf.value);
                if (cls2 == null) continue;
                Map<VarType, VarType> sig = cls2.getGenericMap(intf);
                for (Map.Entry<String, Map<VarType, VarType>> e : cls2.getAllGenerics().entrySet()) {
                    if (e.getValue().isEmpty()) {
                        ret.put(e.getKey(), e.getValue());
                        continue;
                    }
                    HashMap<VarType, VarType> sub = new HashMap<VarType, VarType>();
                    for (Map.Entry<VarType, VarType> e2 : e.getValue().entrySet()) {
                        sub.put(e2.getKey(), sig.getOrDefault(e2.getValue(), e2.getValue()));
                    }
                    ret.put(e.getKey(), sub);
                }
            }
        }
        for (String intf : this.interfaceNames) {
            StructClass cls3;
            if (visited.contains(intf) || (cls3 = DecompilerContext.getStructContext().getClass(intf)) == null) continue;
            ret.putAll(cls3.getAllGenerics());
        }
        if (this.superClass != null && (cls = DecompilerContext.getStructContext().getClass((String)this.superClass.value)) != null) {
            Map sig;
            Map<Object, VarType> map = sig = this.signature == null ? Collections.emptyMap() : cls.getGenericMap(this.signature.superclass);
            if (sig.isEmpty()) {
                ret.putAll(cls.getAllGenerics());
            } else {
                for (Map.Entry<String, Map<VarType, VarType>> e : cls.getAllGenerics().entrySet()) {
                    if (e.getValue().isEmpty()) {
                        ret.put(e.getKey(), e.getValue());
                        continue;
                    }
                    HashMap<VarType, VarType> sub = new HashMap<VarType, VarType>();
                    for (Map.Entry<VarType, VarType> e2 : e.getValue().entrySet()) {
                        sub.put(e2.getKey(), sig.getOrDefault(e2.getValue(), e2.getValue()));
                    }
                    ret.put(e.getKey(), sub);
                }
            }
        }
        this.genericHiarachy = ret.isEmpty() ? Collections.emptyMap() : ret;
        return this.genericHiarachy;
    }
}

