/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;

public class ExprUtil {
    public static List<VarVersionPair> getSyntheticParametersMask(String className, String descriptor, int parameters) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(className);
        return node != null ? ExprUtil.getSyntheticParametersMask(node, descriptor, parameters) : null;
    }

    public static List<VarVersionPair> getSyntheticParametersMask(ClassesProcessor.ClassNode node, String descriptor, int parameters) {
        List<VarVersionPair> mask = null;
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper != null) {
            mask = wrapper.getMethodWrapper((String)"<init>", (String)descriptor).synthParameters;
        } else if (parameters > 0 && node.type == 1 && !ExprUtil.isStatic(node.classStruct)) {
            mask = new ArrayList<Object>(Collections.nCopies(parameters, null));
            mask.set(0, new VarVersionPair(-1, 0));
        }
        return mask;
    }

    private static boolean isStatic(StructClass struct) {
        if (struct.hasModifier(8)) {
            return true;
        }
        if (struct.hasAttribute("InnerClasses")) {
            StructInnerClassesAttribute attr = (StructInnerClassesAttribute)struct.getAttribute("InnerClasses");
            for (StructInnerClassesAttribute.Entry entry : attr.getEntries()) {
                if (entry.innerName == null || !entry.innerName.equals(struct.qualifiedName)) continue;
                return (entry.accessFlags & 8) == 8;
            }
        }
        return false;
    }
}

