/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class SimplifyExprentsHelper {
    private static final MatchEngine class14Builder = new MatchEngine("statement type:if iftype:if exprsize:-1\n exprent position:head type:if\n  exprent type:function functype:eq\n   exprent type:field name:$fieldname$\n   exprent type:constant consttype:null\n statement type:basicblock\n  exprent position:-1 type:assignment ret:$assignfield$\n   exprent type:var index:$var$\n   exprent type:field name:$fieldname$\n statement type:sequence statsize:2\n  statement type:trycatch\n   statement type:basicblock exprsize:1\n    exprent type:assignment\n     exprent type:var index:$var$\n     exprent type:invocation invclass:java/lang/Class signature:forName(Ljava/lang/String;)Ljava/lang/Class;\n      exprent position:0 type:constant consttype:string constvalue:$classname$\n   statement type:basicblock exprsize:1\n    exprent type:exit exittype:throw\n  statement type:basicblock exprsize:1\n   exprent type:assignment\n    exprent type:field name:$fieldname$ ret:$field$\n    exprent type:var index:$var$");
    private final boolean firstInvocation;

    public SimplifyExprentsHelper(boolean firstInvocation) {
        this.firstInvocation = firstInvocation;
    }

    public boolean simplifyStackVarsStatement(Statement stat, Set<Integer> setReorderedIfs, SSAConstructorSparseEx ssa, StructClass cl) {
        boolean res = false;
        List<Exprent> expressions = stat.getExprents();
        if (expressions == null) {
            boolean changed;
            boolean processClass14 = DecompilerContext.getOption("dc4");
            do {
                changed = false;
                for (Statement st : stat.getStats()) {
                    res |= this.simplifyStackVarsStatement(st, setReorderedIfs, ssa, cl);
                    changed = IfHelper.mergeIfs(st, setReorderedIfs);
                    if (!changed && !(changed = SimplifyExprentsHelper.buildIff(st, ssa)) && (!processClass14 || !(changed = SimplifyExprentsHelper.collapseInlinedClass14(st))) && (st.getStats().isEmpty() || !SimplifyExprentsHelper.hasQualifiedNewGetClass(st, (Statement)st.getStats().get(0)))) continue;
                    break;
                }
                res |= changed;
            } while (changed);
        } else {
            res = this.simplifyStackVarsExprents(expressions, cl);
        }
        return res;
    }

    private boolean simplifyStackVarsExprents(List<Exprent> list, StructClass cl) {
        boolean res = false;
        int index = 0;
        while (index < list.size()) {
            Exprent current = list.get(index);
            Exprent ret = SimplifyExprentsHelper.isSimpleConstructorInvocation(current);
            if (ret != null) {
                list.set(index, ret);
                res = true;
                continue;
            }
            ret = SimplifyExprentsHelper.isLambda(current, cl);
            if (ret != null) {
                list.set(index, ret);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isMonitorExit(current)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isTrivialStackAssignment(current)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (index == list.size() - 1) break;
            Exprent next = list.get(index + 1);
            if (SimplifyExprentsHelper.isConstructorInvocationRemote(list, index)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (DecompilerContext.getOption("rgn") && SimplifyExprentsHelper.isQualifiedNewGetClass(current, next)) {
                list.remove(index);
                res = true;
                continue;
            }
            int arrCount = SimplifyExprentsHelper.isArrayInitializer(list, index);
            if (arrCount > 0) {
                for (int i = 0; i < arrCount; ++i) {
                    list.remove(index + 1);
                }
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.addArrayInitializer(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            Exprent func = SimplifyExprentsHelper.isPPIorMMI(current);
            if (func != null) {
                list.set(index, func);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isIPPorIMM(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isStackAssignment(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (!this.firstInvocation && SimplifyExprentsHelper.isStackAssignment2(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            ++index;
        }
        return res;
    }

    private static boolean addArrayInitializer(Exprent first, Exprent second) {
        if (first.type == 2) {
            NewExprent newExpr;
            AssignmentExprent as = (AssignmentExprent)first;
            if (as.getRight().type == 10 && as.getLeft().type == 12 && !(newExpr = (NewExprent)as.getRight()).getLstArrayElements().isEmpty()) {
                VarExprent arrVar = (VarExprent)as.getLeft();
                if (second.type == 2) {
                    AssignmentExprent aas = (AssignmentExprent)second;
                    if (aas.getLeft().type == 1) {
                        int constValue;
                        ArrayExprent arrExpr = (ArrayExprent)aas.getLeft();
                        if (arrExpr.getArray().type == 12 && arrVar.equals(arrExpr.getArray()) && arrExpr.getIndex().type == 3 && (constValue = ((ConstExprent)arrExpr.getIndex()).getIntValue()) < newExpr.getLstArrayElements().size()) {
                            Exprent tempExpr;
                            VarType arrType;
                            ConstExprent defaultVal;
                            ConstExprent cinit;
                            Exprent init = newExpr.getLstArrayElements().get(constValue);
                            if (init.type == 3 && (cinit = (ConstExprent)init).equals(defaultVal = ExprProcessor.getDefaultArrayValue(arrType = newExpr.getNewType().decreaseArrayDim())) && !(tempExpr = aas.getRight()).containsExprent(arrVar)) {
                                newExpr.getLstArrayElements().set(constValue, tempExpr);
                                if (tempExpr.type == 10) {
                                    NewExprent tempNewExpr = (NewExprent)tempExpr;
                                    int dims = newExpr.getNewType().arrayDim;
                                    if (dims > 1 && !tempNewExpr.getLstArrayElements().isEmpty()) {
                                        tempNewExpr.setDirectArrayInit(true);
                                    }
                                }
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static int isArrayInitializer(List<Exprent> list, int index) {
        Exprent current = list.get(index);
        if (current.type == 2) {
            AssignmentExprent as = (AssignmentExprent)current;
            if (as.getRight().type == 10 && as.getLeft().type == 12) {
                NewExprent newExpr = (NewExprent)as.getRight();
                if (newExpr.getExprType().arrayDim > 0 && newExpr.getLstDims().size() == 1 && newExpr.getLstArrayElements().isEmpty() && newExpr.getLstDims().get((int)0).type == 3) {
                    int size = (Integer)((ConstExprent)newExpr.getLstDims().get(0)).getValue();
                    if (size == 0) {
                        return 0;
                    }
                    VarExprent arrVar = (VarExprent)as.getLeft();
                    HashMap<Integer, Exprent> mapInit = new HashMap<Integer, Exprent>();
                    for (int i = 1; index + i < list.size() && i <= size; ++i) {
                        boolean found = false;
                        Exprent expr = list.get(index + i);
                        if (expr.type == 2) {
                            AssignmentExprent aas = (AssignmentExprent)expr;
                            if (aas.getLeft().type == 1) {
                                int constValue;
                                ArrayExprent arrExpr = (ArrayExprent)aas.getLeft();
                                if (arrExpr.getArray().type == 12 && arrVar.equals(arrExpr.getArray()) && arrExpr.getIndex().type == 3 && (constValue = ((ConstExprent)arrExpr.getIndex()).getIntValue()) < size && !mapInit.containsKey(constValue) && !aas.getRight().containsExprent(arrVar)) {
                                    mapInit.put(constValue, aas.getRight());
                                    found = true;
                                }
                            }
                        }
                        if (!found) break;
                    }
                    double fraction = (double)mapInit.size() / (double)size;
                    if (arrVar.isStack() && fraction > 0.0 || size <= 7 && fraction >= 0.3 || size > 7 && fraction >= 0.7) {
                        ArrayList<Exprent> lstRet = new ArrayList<Exprent>();
                        VarType arrayType = newExpr.getNewType().decreaseArrayDim();
                        ConstExprent defaultVal = ExprProcessor.getDefaultArrayValue(arrayType);
                        for (int j = 0; j < size; ++j) {
                            lstRet.add(defaultVal.copy());
                        }
                        int dims = newExpr.getNewType().arrayDim;
                        for (Map.Entry ent : mapInit.entrySet()) {
                            Exprent tempExpr = (Exprent)ent.getValue();
                            lstRet.set((Integer)ent.getKey(), tempExpr);
                            if (tempExpr.type != 10) continue;
                            NewExprent tempNewExpr = (NewExprent)tempExpr;
                            if (dims <= 1 || tempNewExpr.getLstArrayElements().isEmpty()) continue;
                            tempNewExpr.setDirectArrayInit(true);
                        }
                        newExpr.setLstArrayElements(lstRet);
                        return mapInit.size();
                    }
                }
            }
        }
        return 0;
    }

    private static boolean isTrivialStackAssignment(Exprent first) {
        if (first.type == 2) {
            AssignmentExprent asf = (AssignmentExprent)first;
            if (asf.getLeft().type == 12 && asf.getRight().type == 12) {
                VarExprent left = (VarExprent)asf.getLeft();
                VarExprent right = (VarExprent)asf.getRight();
                return left.getIndex() == right.getIndex() && left.isStack() && right.isStack();
            }
        }
        return false;
    }

    private static boolean isStackAssignment2(Exprent first, Exprent second) {
        if (first.type == 2 && second.type == 2) {
            AssignmentExprent asf = (AssignmentExprent)first;
            AssignmentExprent ass = (AssignmentExprent)second;
            if (asf.getLeft().type == 12 && ass.getRight().type == 12 && asf.getLeft().equals(ass.getRight()) && ((VarExprent)asf.getLeft()).isStack() && (ass.getLeft().type != 12 || !((VarExprent)ass.getLeft()).isStack())) {
                asf.setRight(new AssignmentExprent(ass.getLeft(), asf.getRight(), ass.bytecode));
                return true;
            }
        }
        return false;
    }

    private static boolean isStackAssignment(Exprent first, Exprent second) {
        if (first.type == 2 && second.type == 2) {
            AssignmentExprent asf = (AssignmentExprent)first;
            AssignmentExprent ass = (AssignmentExprent)second;
            while (true) {
                if (asf.getRight().equals(ass.getRight()) && asf.getLeft().type == 12 && ((VarExprent)asf.getLeft()).isStack() && (ass.getLeft().type != 12 || !((VarExprent)ass.getLeft()).isStack()) && !ass.getLeft().containsExprent(asf.getLeft())) {
                    asf.setRight(ass);
                    return true;
                }
                if (asf.getRight().type != 2) break;
                asf = (AssignmentExprent)asf.getRight();
            }
        }
        return false;
    }

    private static Exprent isPPIorMMI(Exprent first) {
        if (first.type == 2) {
            FunctionExprent func;
            AssignmentExprent as = (AssignmentExprent)first;
            if (as.getRight().type == 6 && ((func = (FunctionExprent)as.getRight()).getFuncType() == 0 || func.getFuncType() == 1)) {
                Exprent econd = func.getLstOperands().get(0);
                Exprent econst = func.getLstOperands().get(1);
                if (econst.type != 3 && econd.type == 3 && func.getFuncType() == 0) {
                    econd = econst;
                    econst = func.getLstOperands().get(0);
                }
                if (econst.type == 3 && ((ConstExprent)econst).hasValueOne()) {
                    Exprent left = as.getLeft();
                    if (left.type != 12 && left.equals(econd)) {
                        int type = func.getFuncType() == 0 ? 35 : 33;
                        FunctionExprent ret = new FunctionExprent(type, econd, func.bytecode);
                        ret.setImplicitType(VarType.VARTYPE_INT);
                        return ret;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isIPPorIMM(Exprent first, Exprent second) {
        if (first.type == 2 && second.type == 6) {
            AssignmentExprent as = (AssignmentExprent)first;
            FunctionExprent in = (FunctionExprent)second;
            if ((in.getFuncType() == 33 || in.getFuncType() == 35) && in.getLstOperands().get(0).equals(as.getRight())) {
                if (in.getFuncType() == 33) {
                    in.setFuncType(32);
                } else {
                    in.setFuncType(34);
                }
                as.setRight(in);
                return true;
            }
        }
        return false;
    }

    private static boolean isMonitorExit(Exprent first) {
        if (first.type == 9) {
            MonitorExprent expr = (MonitorExprent)first;
            return expr.getMonType() == 1 && expr.getValue().type == 12 && !((VarExprent)expr.getValue()).isStack();
        }
        return false;
    }

    private static boolean hasQualifiedNewGetClass(Statement parent, Statement child) {
        if (child.type == 8 && child.getExprents() != null && !child.getExprents().isEmpty()) {
            Exprent firstExpr = child.getExprents().get(child.getExprents().size() - 1);
            if (parent.type == 2 && SimplifyExprentsHelper.isQualifiedNewGetClass(firstExpr, ((IfStatement)parent).getHeadexprent().getCondition())) {
                child.getExprents().remove(firstExpr);
                return true;
            }
        }
        return false;
    }

    private static boolean isQualifiedNewGetClass(Exprent first, Exprent second) {
        InvocationExprent invocation;
        if (first.type == 8 && !(invocation = (InvocationExprent)first).isStatic() && (invocation.getInstance().type == 12 || invocation.getInstance().type == 5) && invocation.getName().equals("getClass") && invocation.getStringDescriptor().equals("()Ljava/lang/Class;")) {
            LinkedList<Exprent> lstExprents = new LinkedList<Exprent>();
            lstExprents.add(second);
            while (!lstExprents.isEmpty()) {
                NewExprent newExpr;
                Exprent expr = (Exprent)lstExprents.removeFirst();
                lstExprents.addAll(expr.getAllExprents());
                if (expr.type != 10 || (newExpr = (NewExprent)expr).getConstructor() == null || newExpr.getConstructor().getLstParameters().isEmpty() || !newExpr.getConstructor().getLstParameters().get(0).equals(invocation.getInstance()) && (invocation.getInstance().type != 5 || !newExpr.getConstructor().getLstParameters().get(0).getExprType().equals(invocation.getInstance().getExprType()))) continue;
                String classname = newExpr.getNewType().value;
                ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
                if (node == null || node.type == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConstructorInvocationRemote(List<Exprent> list, int index) {
        Exprent current = list.get(index);
        if (current.type == 2) {
            AssignmentExprent as = (AssignmentExprent)current;
            if (as.getLeft().type == 12 && as.getRight().type == 10) {
                NewExprent newExpr = (NewExprent)as.getRight();
                VarType newType = newExpr.getNewType();
                VarVersionPair leftPair = new VarVersionPair((VarExprent)as.getLeft());
                if (newType.type == 8 && newType.arrayDim == 0 && newExpr.getConstructor() == null) {
                    for (int i = index + 1; i < list.size(); ++i) {
                        InvocationExprent in;
                        Exprent remote = list.get(i);
                        if (remote.type == 8 && (in = (InvocationExprent)remote).getFunctype() == 2 && in.getInstance().type == 12 && as.getLeft().equals(in.getInstance())) {
                            newExpr.setConstructor(in);
                            in.setInstance(null);
                            list.set(i, as.copy());
                            return true;
                        }
                        Set<VarVersionPair> setVars = remote.getAllVariables();
                        if (!setVars.contains(leftPair)) continue;
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private static Exprent isLambda(Exprent exprent, StructClass cl) {
        InvocationExprent in;
        List<Exprent> lst = exprent.getAllExprents();
        for (Exprent expr : lst) {
            Exprent ret = SimplifyExprentsHelper.isLambda(expr, cl);
            if (ret == null) continue;
            exprent.replaceExprent(expr, ret);
        }
        if (exprent.type == 8 && (in = (InvocationExprent)exprent).getInvocationTyp() == 5) {
            String lambda_class_name = cl.qualifiedName + in.getInvokeDynamicClassSuffix();
            ClassesProcessor.ClassNode lambda_class = DecompilerContext.getClassProcessor().getMapRootClasses().get(lambda_class_name);
            if (lambda_class != null) {
                NewExprent newExpr = new NewExprent(new VarType(lambda_class_name, true), null, 0, in.bytecode);
                newExpr.setConstructor(in);
                return newExpr;
            }
        }
        return null;
    }

    private static Exprent isSimpleConstructorInvocation(Exprent exprent) {
        InvocationExprent in;
        List<Exprent> lst = exprent.getAllExprents();
        for (Exprent expr : lst) {
            Exprent ret = SimplifyExprentsHelper.isSimpleConstructorInvocation(expr);
            if (ret == null) continue;
            exprent.replaceExprent(expr, ret);
        }
        if (exprent.type == 8 && (in = (InvocationExprent)exprent).getFunctype() == 2 && in.getInstance().type == 10) {
            NewExprent newExpr = (NewExprent)in.getInstance();
            newExpr.setConstructor(in);
            in.setInstance(null);
            return newExpr;
        }
        return null;
    }

    private static boolean buildIff(Statement stat, SSAConstructorSparseEx ssa) {
        if (stat.type == 2 && stat.getExprents() == null) {
            BitSet ifHeadExprBytecode;
            IfStatement statement = (IfStatement)stat;
            IfExprent ifHeadExpr = statement.getHeadexprent();
            BitSet bitSet = ifHeadExprBytecode = ifHeadExpr == null ? null : ifHeadExpr.bytecode;
            if (statement.iftype == 1) {
                Statement ifStatement = statement.getIfstat();
                Statement elseStatement = statement.getElsestat();
                if (ifStatement.getExprents() != null && ifStatement.getExprents().size() == 1 && elseStatement.getExprents() != null && elseStatement.getExprents().size() == 1 && ifStatement.getAllSuccessorEdges().size() == 1 && elseStatement.getAllSuccessorEdges().size() == 1 && ifStatement.getAllSuccessorEdges().get(0).getDestination() == elseStatement.getAllSuccessorEdges().get(0).getDestination()) {
                    Exprent ifExpr = ifStatement.getExprents().get(0);
                    Exprent elseExpr = elseStatement.getExprents().get(0);
                    if (ifExpr.type == 2 && elseExpr.type == 2) {
                        AssignmentExprent ifAssign = (AssignmentExprent)ifExpr;
                        AssignmentExprent elseAssign = (AssignmentExprent)elseExpr;
                        if (ifAssign.getLeft().type == 12 && elseAssign.getLeft().type == 12) {
                            VarExprent ifVar = (VarExprent)ifAssign.getLeft();
                            VarExprent elseVar = (VarExprent)elseAssign.getLeft();
                            if (ifVar.getIndex() == elseVar.getIndex() && ifVar.isStack()) {
                                boolean found = false;
                                for (Map.Entry<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> ent : ssa.getPhi().entrySet()) {
                                    if (ent.getKey().var != ifVar.getIndex() || !ent.getValue().contains(ifVar.getVersion()) || !ent.getValue().contains(elseVar.getVersion())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) {
                                    ArrayList<Exprent> data = new ArrayList<Exprent>(statement.getFirst().getExprents());
                                    List<Exprent> operands = Arrays.asList(statement.getHeadexprent().getCondition(), ifAssign.getRight(), elseAssign.getRight());
                                    data.add(new AssignmentExprent(ifVar, new FunctionExprent(36, operands, ifHeadExprBytecode), ifHeadExprBytecode));
                                    statement.setExprents(data);
                                    if (statement.getAllSuccessorEdges().isEmpty()) {
                                        StatEdge ifEdge = ifStatement.getAllSuccessorEdges().get(0);
                                        StatEdge edge = new StatEdge(ifEdge.getType(), (Statement)statement, ifEdge.getDestination());
                                        statement.addSuccessor(edge);
                                        if (ifEdge.closure != null) {
                                            ifEdge.closure.addLabeledEdge(edge);
                                        }
                                    }
                                    SequenceHelper.destroyAndFlattenStatement(statement);
                                    return true;
                                }
                            }
                        }
                    } else if (ifExpr.type == 4 && elseExpr.type == 4) {
                        ExitExprent ifExit = (ExitExprent)ifExpr;
                        ExitExprent elseExit = (ExitExprent)elseExpr;
                        if (ifExit.getExitType() == elseExit.getExitType() && ifExit.getValue() != null && elseExit.getValue() != null && ifExit.getExitType() == 0) {
                            if (ifExit.getExitType() == 1 && !ifExit.getValue().getExprType().equals(elseExit.getValue().getExprType())) {
                                return false;
                            }
                            if (SimplifyExprentsHelper.isIff(ifExit.getValue()) || SimplifyExprentsHelper.isIff(elseExit.getValue())) {
                                return false;
                            }
                            ArrayList<Exprent> data = new ArrayList<Exprent>(statement.getFirst().getExprents());
                            data.add(new ExitExprent(ifExit.getExitType(), new FunctionExprent(36, Arrays.asList(statement.getHeadexprent().getCondition(), ifExit.getValue(), elseExit.getValue()), ifHeadExprBytecode), ifExit.getRetType(), ifHeadExprBytecode, ifExit.getMethodDescriptor()));
                            statement.setExprents(data);
                            StatEdge retEdge = ifStatement.getAllSuccessorEdges().get(0);
                            Statement closure = retEdge.closure == statement ? statement.getParent() : retEdge.closure;
                            statement.addSuccessor(new StatEdge(4, statement, retEdge.getDestination(), closure));
                            SequenceHelper.destroyAndFlattenStatement(statement);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean isIff(Exprent exp) {
        return exp.type == 6 && ((FunctionExprent)exp).getFuncType() == 36;
    }

    private static boolean collapseInlinedClass14(Statement stat) {
        boolean ret = class14Builder.match(stat);
        if (ret) {
            String class_name = (String)class14Builder.getVariableValue("$classname$");
            AssignmentExprent assignment = (AssignmentExprent)class14Builder.getVariableValue("$assignfield$");
            FieldExprent fieldExpr = (FieldExprent)class14Builder.getVariableValue("$field$");
            assignment.replaceExprent(assignment.getRight(), new ConstExprent(VarType.VARTYPE_CLASS, class_name, null));
            ArrayList<Exprent> data = new ArrayList<Exprent>(stat.getFirst().getExprents());
            stat.setExprents(data);
            SequenceHelper.destroyAndFlattenStatement(stat);
            ClassWrapper wrapper = (ClassWrapper)DecompilerContext.getProperty("CURRENT_CLASS_WRAPPER");
            if (wrapper != null) {
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fieldExpr.getName(), fieldExpr.getDescriptor().descriptorString));
            }
        }
        return ret;
    }
}

