/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public class MergeHelper {
    public static void enhanceLoops(Statement root) {
        while (MergeHelper.enhanceLoopsRec(root)) {
        }
        SequenceHelper.condenseSequences(root);
    }

    private static boolean enhanceLoopsRec(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            if (st.getExprents() != null) continue;
            res |= MergeHelper.enhanceLoopsRec(st);
        }
        if (stat.type == 5) {
            res |= MergeHelper.enhanceLoop((DoStatement)stat);
        }
        return res;
    }

    private static boolean enhanceLoop(DoStatement stat) {
        int oldloop = stat.getLooptype();
        switch (oldloop) {
            case 0: {
                if (!MergeHelper.matchWhile(stat) || MergeHelper.matchForEach(stat)) break;
                MergeHelper.matchFor(stat);
                break;
            }
            case 2: {
                if (MergeHelper.matchForEach(stat)) break;
                MergeHelper.matchFor(stat);
            }
        }
        return stat.getLooptype() != oldloop;
    }

    private static void matchDoWhile(DoStatement stat) {
        Statement last = stat.getFirst();
        while (last.type == 15) {
            last = last.getStats().getLast();
        }
        if (last.type == 2) {
            IfStatement lastif = (IfStatement)last;
            if (lastif.iftype == 0 && lastif.getIfstat() == null) {
                StatEdge ifedge = lastif.getIfEdge();
                StatEdge elseedge = lastif.getAllSuccessorEdges().get(0);
                if (ifedge.getType() == 4 && elseedge.getType() == 8 && elseedge.closure == stat && MergeHelper.isDirectPath(stat, ifedge.getDestination()) || ifedge.getType() == 8 && elseedge.getType() == 4 && ifedge.closure == stat && MergeHelper.isDirectPath(stat, elseedge.getDestination())) {
                    Set<Statement> set = stat.getNeighboursSet(8, 0);
                    set.remove(last);
                    if (!set.isEmpty()) {
                        return;
                    }
                    stat.setLooptype(1);
                    IfExprent ifexpr = (IfExprent)lastif.getHeadexprent().copy();
                    if (ifedge.getType() == 4) {
                        ifexpr.negateIf();
                    }
                    if (stat.getConditionExprent() != null) {
                        ifexpr.getCondition().addBytecodeOffsets(stat.getConditionExprent().bytecode);
                    }
                    ifexpr.getCondition().addBytecodeOffsets(lastif.getHeadexprent().bytecode);
                    stat.setConditionExprent(ifexpr.getCondition());
                    lastif.getFirst().removeSuccessor(ifedge);
                    lastif.removeSuccessor(elseedge);
                    if (lastif.getFirst().getExprents().isEmpty()) {
                        MergeHelper.removeLastEmptyStatement(stat, lastif);
                    } else {
                        lastif.setExprents(lastif.getFirst().getExprents());
                        StatEdge newedge = new StatEdge(8, (Statement)lastif, stat);
                        lastif.addSuccessor(newedge);
                        stat.addLabeledEdge(newedge);
                    }
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        StatEdge edge = elseedge.getType() == 8 ? ifedge : elseedge;
                        edge.setSource(stat);
                        if (edge.closure == stat) {
                            edge.closure = stat.getParent();
                        }
                        stat.addSuccessor(edge);
                    }
                }
            }
        }
    }

    private static boolean matchWhile(DoStatement stat) {
        IfStatement firstif;
        Statement first = stat.getFirst();
        while (first.type == 15) {
            first = first.getFirst();
        }
        if (first.type == 2 && (firstif = (IfStatement)first).getFirst().getExprents().isEmpty() && firstif.iftype == 0) {
            if (firstif.getIfstat() == null) {
                StatEdge ifedge = firstif.getIfEdge();
                if (MergeHelper.isDirectPath(stat, ifedge.getDestination())) {
                    stat.setLooptype(2);
                    IfExprent ifexpr = (IfExprent)firstif.getHeadexprent().copy();
                    ifexpr.negateIf();
                    if (stat.getConditionExprent() != null) {
                        ifexpr.getCondition().addBytecodeOffsets(stat.getConditionExprent().bytecode);
                    }
                    ifexpr.getCondition().addBytecodeOffsets(firstif.getHeadexprent().bytecode);
                    stat.setConditionExprent(ifexpr.getCondition());
                    firstif.getFirst().removeSuccessor(ifedge);
                    firstif.removeSuccessor(firstif.getAllSuccessorEdges().get(0));
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        ifedge.setSource(stat);
                        if (ifedge.closure == stat) {
                            ifedge.closure = stat.getParent();
                        }
                        stat.addSuccessor(ifedge);
                    }
                    if (firstif == stat.getFirst()) {
                        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                        bstat.setExprents(new ArrayList<Exprent>());
                        stat.replaceStatement(firstif, bstat);
                    } else {
                        Statement sequence = firstif.getParent();
                        sequence.getStats().removeWithKey(firstif.id);
                        sequence.setFirst((Statement)sequence.getStats().get(0));
                    }
                    return true;
                }
            } else {
                StatEdge elseedge = firstif.getAllSuccessorEdges().get(0);
                if (MergeHelper.isDirectPath(stat, elseedge.getDestination())) {
                    stat.setLooptype(2);
                    IfExprent ifexpr = (IfExprent)firstif.getHeadexprent().copy();
                    if (stat.getConditionExprent() != null) {
                        ifexpr.getCondition().addBytecodeOffsets(stat.getConditionExprent().bytecode);
                    }
                    ifexpr.getCondition().addBytecodeOffsets(firstif.getHeadexprent().bytecode);
                    stat.setConditionExprent(ifexpr.getCondition());
                    StatEdge ifedge = firstif.getIfEdge();
                    firstif.getFirst().removeSuccessor(ifedge);
                    firstif.removeSuccessor(elseedge);
                    if (stat.getAllSuccessorEdges().isEmpty()) {
                        elseedge.setSource(stat);
                        if (elseedge.closure == stat) {
                            elseedge.closure = stat.getParent();
                        }
                        stat.addSuccessor(elseedge);
                    }
                    if (firstif.getIfstat() == null) {
                        BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
                        bstat.setExprents(new ArrayList<Exprent>());
                        ifedge.setSource(bstat);
                        bstat.addSuccessor(ifedge);
                        stat.replaceStatement(firstif, bstat);
                    } else {
                        first.getParent().replaceStatement(first, firstif.getIfstat());
                        for (StatEdge prededge : elseedge.getDestination().getPredecessorEdges(4)) {
                            if (!stat.containsStatementStrict(prededge.closure)) continue;
                            stat.addLabeledEdge(prededge);
                        }
                        LabelHelper.lowClosures(stat);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDirectPath(Statement stat, Statement endstat) {
        Set<Statement> setStat = stat.getNeighboursSet(0x40000000, 1);
        if (setStat.isEmpty()) {
            Statement parent = stat.getParent();
            if (parent == null) {
                return false;
            }
            switch (parent.type) {
                case 13: {
                    return endstat.type == 14;
                }
                case 5: {
                    return endstat == parent;
                }
                case 6: {
                    SwitchStatement swst = (SwitchStatement)parent;
                    for (int i = 0; i < swst.getCaseStatements().size() - 1; ++i) {
                        Statement stt = swst.getCaseStatements().get(i);
                        if (stt != stat) continue;
                        Statement stnext = swst.getCaseStatements().get(i + 1);
                        if (stnext.getExprents() != null && stnext.getExprents().isEmpty()) {
                            stnext = stnext.getAllSuccessorEdges().get(0).getDestination();
                        }
                        return endstat == stnext;
                    }
                    break;
                }
            }
            return MergeHelper.isDirectPath(parent, endstat);
        }
        return setStat.contains(endstat);
    }

    private static void matchFor(DoStatement stat) {
        Statement parent;
        boolean haslast;
        Statement preData = null;
        Statement lastData = MergeHelper.getLastDirectData(stat.getFirst());
        if (lastData == null || lastData.getExprents().isEmpty()) {
            return;
        }
        List<Exprent> lstExpr = lastData.getExprents();
        Exprent lastDoExprent = lstExpr.get(lstExpr.size() - 1);
        boolean issingle = false;
        if (lstExpr.size() == 1 && lastData.getAllPredecessorEdges().size() > 1) {
            issingle = true;
        }
        boolean bl = haslast = issingle || lastDoExprent.type == 2 || lastDoExprent.type == 6;
        if (!haslast) {
            return;
        }
        boolean hasinit = false;
        Statement current = stat;
        while ((parent = current.getParent()) != null && parent.type == 15) {
            if (current == parent.getFirst()) {
                current = parent;
                continue;
            }
            preData = current.getNeighbours(1, 0).get(0);
            if (preData.type != 8 || (preData = MergeHelper.getLastDirectData(preData)) == null || preData.getExprents().isEmpty()) break;
            Exprent initDoExprent = preData.getExprents().get(preData.getExprents().size() - 1);
            if (initDoExprent.type != 2) break;
            hasinit = true;
            break;
        }
        if (hasinit || issingle) {
            Exprent exp;
            Set<Statement> set = stat.getNeighboursSet(8, 0);
            set.remove(lastData);
            if (!set.isEmpty()) {
                return;
            }
            stat.setLooptype(3);
            if (hasinit) {
                exp = preData.getExprents().remove(preData.getExprents().size() - 1);
                if (stat.getInitExprent() != null) {
                    exp.addBytecodeOffsets(stat.getInitExprent().bytecode);
                }
                stat.setInitExprent(exp);
            }
            exp = lastData.getExprents().remove(lastData.getExprents().size() - 1);
            if (stat.getIncExprent() != null) {
                exp.addBytecodeOffsets(stat.getIncExprent().bytecode);
            }
            stat.setIncExprent(exp);
        }
        MergeHelper.cleanEmptyStatements(stat, lastData);
    }

    private static void cleanEmptyStatements(DoStatement dostat, Statement stat) {
        if (stat != null && stat.getExprents().isEmpty()) {
            List<StatEdge> lst = stat.getAllSuccessorEdges();
            if (!lst.isEmpty()) {
                stat.removeSuccessor(lst.get(0));
            }
            MergeHelper.removeLastEmptyStatement(dostat, stat);
        }
    }

    private static void removeLastEmptyStatement(DoStatement dostat, Statement stat) {
        if (stat == dostat.getFirst()) {
            BasicBlockStatement bstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            bstat.setExprents(new ArrayList<Exprent>());
            dostat.replaceStatement(stat, bstat);
        } else {
            for (StatEdge edge : stat.getAllPredecessorEdges()) {
                edge.getSource().changeEdgeType(1, edge, 8);
                stat.removePredecessor(edge);
                edge.getSource().changeEdgeNode(1, edge, dostat);
                dostat.addPredecessor(edge);
                dostat.addLabeledEdge(edge);
            }
            stat.getParent().getStats().removeWithKey(stat.id);
        }
    }

    private static Statement getLastDirectData(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        for (int i = stat.getStats().size() - 1; i >= 0; --i) {
            Statement tmp = MergeHelper.getLastDirectData((Statement)stat.getStats().get(i));
            if (tmp != null && tmp.getExprents().isEmpty()) continue;
            return tmp;
        }
        return null;
    }

    private static boolean matchForEach(DoStatement stat) {
        Statement parent;
        AssignmentExprent firstDoExprent = null;
        AssignmentExprent[] initExprents = new AssignmentExprent[3];
        Statement firstData = null;
        Statement preData = null;
        Statement lastData = null;
        Exprent lastExprent = null;
        Statement current = stat;
        while ((parent = current.getParent()) != null && parent.type == 15) {
            if (current == parent.getFirst()) {
                current = parent;
                continue;
            }
            preData = current.getNeighbours(1, 0).get(0);
            if ((preData = MergeHelper.getLastDirectData(preData)) == null || preData.getExprents().isEmpty()) break;
            int size = preData.getExprents().size();
            for (int x = 0; x < initExprents.length; ++x) {
                if (size <= x) continue;
                Exprent exprent = preData.getExprents().get(size - 1 - x);
                if (exprent.type != 2) continue;
                initExprents[x] = (AssignmentExprent)exprent;
            }
        }
        if ((firstData = MergeHelper.getFirstDirectData(stat.getFirst())) != null && firstData.getExprents().get((int)0).type == 2) {
            firstDoExprent = (AssignmentExprent)firstData.getExprents().get(0);
        }
        if ((lastData = MergeHelper.getLastDirectData(stat.getFirst())) != null && !lastData.getExprents().isEmpty()) {
            lastExprent = lastData.getExprents().get(lastData.getExprents().size() - 1);
        }
        if (stat.getLooptype() == 2 && initExprents[0] != null && firstDoExprent != null) {
            if (initExprents[0].type == 2 && MergeHelper.isIteratorCall(initExprents[0].getRight())) {
                InvocationExprent invc = (InvocationExprent)MergeHelper.getUncast(initExprents[0].getRight());
                if (invc.getClassname().contains("java/util/stream")) {
                    return false;
                }
                if (!MergeHelper.isHasNextCall(MergeHelper.drillNots(stat.getConditionExprent())) || firstDoExprent.type != 2) {
                    return false;
                }
                AssignmentExprent ass = firstDoExprent;
                if (!MergeHelper.isNextCall(ass.getRight()) && !MergeHelper.isNextUnboxing(ass.getRight()) || ass.getLeft().type != 12) {
                    return false;
                }
                InvocationExprent next = (InvocationExprent)MergeHelper.getUncast(ass.getRight());
                if (MergeHelper.isNextUnboxing(next)) {
                    next = (InvocationExprent)MergeHelper.getUncast(next.getInstance());
                }
                InvocationExprent hnext = (InvocationExprent)MergeHelper.getUncast(MergeHelper.drillNots(stat.getConditionExprent()));
                if (next.getInstance().type != 12 || hnext.getInstance().type != 12 || ((VarExprent)initExprents[0].getLeft()).isVarReferenced(stat, (VarExprent)next.getInstance(), (VarExprent)hnext.getInstance())) {
                    return false;
                }
                InvocationExprent holder = (InvocationExprent)initExprents[0].getRight();
                initExprents[0].getBytecodeRange(holder.getInstance().bytecode);
                holder.getBytecodeRange(holder.getInstance().bytecode);
                firstDoExprent.getBytecodeRange(ass.getLeft().bytecode);
                ass.getRight().getBytecodeRange(ass.getLeft().bytecode);
                if (stat.getIncExprent() != null) {
                    stat.getIncExprent().getBytecodeRange(holder.getInstance().bytecode);
                }
                if (stat.getInitExprent() != null) {
                    stat.getInitExprent().getBytecodeRange(ass.getLeft().bytecode);
                }
                stat.setLooptype(4);
                stat.setInitExprent(ass.getLeft());
                stat.setIncExprent(holder.getInstance());
                preData.getExprents().remove(initExprents[0]);
                firstData.getExprents().remove(firstDoExprent);
                if (initExprents[1] != null && initExprents[1].getLeft().type == 12 && holder.getInstance().type == 12) {
                    VarExprent copy = (VarExprent)initExprents[1].getLeft();
                    VarExprent inc = (VarExprent)holder.getInstance();
                    if (copy.getIndex() == inc.getIndex() && copy.getVersion() == inc.getVersion() && !inc.isVarReferenced(stat.getTopParent(), copy)) {
                        preData.getExprents().remove(initExprents[1]);
                        initExprents[1].getBytecodeRange(initExprents[1].getRight().bytecode);
                        stat.getIncExprent().getBytecodeRange(initExprents[1].getRight().bytecode);
                        stat.setIncExprent(initExprents[1].getRight());
                    }
                }
                return true;
            }
            if (initExprents[0] != null && initExprents[1] != null && firstDoExprent != null) {
                VarExprent copy;
                if (firstDoExprent.getRight().type != 1 || firstDoExprent.getLeft().type != 12) {
                    return false;
                }
                if (lastExprent == null || lastExprent.type != 6) {
                    return false;
                }
                if (initExprents[0].getRight().type != 3 || initExprents[1].getRight().type != 6 || stat.getConditionExprent().type != 6) {
                    return false;
                }
                FunctionExprent funcRight = (FunctionExprent)initExprents[1].getRight();
                FunctionExprent funcInc = (FunctionExprent)lastExprent;
                ArrayExprent arr = (ArrayExprent)firstDoExprent.getRight();
                int incType = funcInc.getFuncType();
                if (funcRight.getFuncType() != 31 || incType != 35 && incType != 34 || arr.getIndex().type != 12 || arr.getArray().type != 12) {
                    return false;
                }
                VarExprent index = (VarExprent)arr.getIndex();
                VarExprent array = (VarExprent)arr.getArray();
                VarExprent counter = (VarExprent)funcInc.getLstOperands().get(0);
                if (counter.getIndex() != index.getIndex() || counter.getVersion() != index.getVersion()) {
                    return false;
                }
                if (counter.isVarReferenced(stat.getFirst(), index)) {
                    return false;
                }
                funcRight.getLstOperands().get(0).addBytecodeOffsets(initExprents[0].bytecode);
                funcRight.getLstOperands().get(0).addBytecodeOffsets(initExprents[1].bytecode);
                funcRight.getLstOperands().get(0).addBytecodeOffsets(lastExprent.bytecode);
                firstDoExprent.getLeft().addBytecodeOffsets(firstDoExprent.bytecode);
                firstDoExprent.getLeft().addBytecodeOffsets(initExprents[0].bytecode);
                stat.setLooptype(4);
                stat.setInitExprent(firstDoExprent.getLeft());
                stat.setIncExprent(funcRight.getLstOperands().get(0));
                preData.getExprents().remove(initExprents[0]);
                preData.getExprents().remove(initExprents[1]);
                firstData.getExprents().remove(firstDoExprent);
                lastData.getExprents().remove(lastExprent);
                if (initExprents[2] != null && initExprents[2].getLeft().type == 12 && (copy = (VarExprent)initExprents[2].getLeft()).getIndex() == array.getIndex() && copy.getVersion() == array.getVersion()) {
                    preData.getExprents().remove(initExprents[2]);
                    initExprents[2].getRight().addBytecodeOffsets(initExprents[2].bytecode);
                    initExprents[2].getRight().addBytecodeOffsets(stat.getIncExprent().bytecode);
                    stat.setIncExprent(initExprents[2].getRight());
                }
                return true;
            }
        }
        return false;
    }

    private static Exprent drillNots(Exprent exp) {
        while (exp.type == 6) {
            FunctionExprent fun = (FunctionExprent)exp;
            if (fun.getFuncType() == 12) {
                exp = fun.getLstOperands().get(0);
                continue;
            }
            if (fun.getFuncType() == 42 || fun.getFuncType() == 43) {
                return fun.getLstOperands().get(0);
            }
            return null;
        }
        return null;
    }

    private static Statement getFirstDirectData(Statement stat) {
        if (stat.getExprents() != null && !stat.getExprents().isEmpty()) {
            return stat;
        }
        for (Statement tmp : stat.getStats()) {
            Statement ret = MergeHelper.getFirstDirectData(tmp);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private static Exprent getUncast(Exprent exp) {
        FunctionExprent func;
        if (exp.type == 6 && (func = (FunctionExprent)exp).getFuncType() == 29) {
            return MergeHelper.getUncast(func.getLstOperands().get(0));
        }
        return exp;
    }

    private static InvocationExprent asInvocationExprent(Exprent exp) {
        exp = MergeHelper.getUncast(exp);
        if (exp.type == 8) {
            return (InvocationExprent)exp;
        }
        return null;
    }

    private static boolean isIteratorCall(Exprent exp) {
        InvocationExprent iexp = MergeHelper.asInvocationExprent(exp);
        if (iexp == null) {
            return false;
        }
        MethodDescriptor descriptor = iexp.getDescriptor();
        if (!DecompilerContext.getStructContext().instanceOf(descriptor.ret.value, "java/util/Iterator")) {
            return false;
        }
        String name = iexp.getName();
        return "iterator".equals(name) || "listIterator".equals(name);
    }

    private static boolean isHasNextCall(Exprent exp) {
        InvocationExprent iexp = MergeHelper.asInvocationExprent(exp);
        if (iexp == null) {
            return false;
        }
        if (!DecompilerContext.getStructContext().instanceOf(iexp.getClassname(), "java/util/Iterator")) {
            return false;
        }
        return "hasNext".equals(iexp.getName()) && "()Z".equals(iexp.getStringDescriptor());
    }

    private static boolean isNextCall(Exprent exp) {
        InvocationExprent iexp = MergeHelper.asInvocationExprent(exp);
        if (iexp == null) {
            return false;
        }
        if (!DecompilerContext.getStructContext().instanceOf(iexp.getClassname(), "java/util/Iterator")) {
            return false;
        }
        return "next".equals(iexp.getName()) && "()Ljava/lang/Object;".equals(iexp.getStringDescriptor());
    }

    private static boolean isNextUnboxing(Exprent exprent) {
        Exprent exp = MergeHelper.getUncast(exprent);
        if (exp.type != 8) {
            return false;
        }
        InvocationExprent inv = (InvocationExprent)exp;
        return inv.isUnboxingCall() && MergeHelper.isNextCall(inv.getInstance());
    }
}

