/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.interpreter;

import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.DataPoint;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.ListStack;

public class InstructionImpact {
    private static final int[][][] stack_impact = new int[][][]{new int[][]{null, null}, null, null, null, null, null, null, null, null, new int[][]{null, {5}}, new int[][]{null, {5}}, new int[][]{null, {3}}, new int[][]{null, {3}}, new int[][]{null, {3}}, new int[][]{null, {2}}, new int[][]{null, {2}}, new int[][]{null, {4}}, new int[][]{null, {4}}, null, null, null, new int[][]{null, {4}}, new int[][]{null, {5}}, new int[][]{null, {3}}, new int[][]{null, {2}}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new int[][]{{8, 4}, {4}}, new int[][]{{8, 4}, {5}}, new int[][]{{8, 4}, {3}}, new int[][]{{8, 4}, {2}}, null, new int[][]{{8, 4}, {4}}, new int[][]{{8, 4}, {4}}, new int[][]{{8, 4}, {4}}, new int[][]{{4}, null}, new int[][]{{5}, null}, new int[][]{{3}, null}, new int[][]{{2}, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new int[][]{{8, 4, 4}, null}, new int[][]{{8, 4, 5}, null}, new int[][]{{8, 4, 3}, null}, new int[][]{{8, 4, 2}, null}, new int[][]{{8, 4, 8}, null}, new int[][]{{8, 4, 4}, null}, new int[][]{{8, 4, 4}, null}, new int[][]{{8, 4, 4}, null}, new int[][]{{11}, null}, new int[][]{{11, 11}, null}, null, null, null, null, null, null, null, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{3, 3}, {3}}, new int[][]{{2, 2}, {2}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{3, 3}, {3}}, new int[][]{{2, 2}, {2}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{3, 3}, {3}}, new int[][]{{2, 2}, {2}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{3, 3}, {3}}, new int[][]{{2, 2}, {2}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{3, 3}, {3}}, new int[][]{{2, 2}, {2}}, new int[][]{{4}, {4}}, new int[][]{{5}, {5}}, new int[][]{{3}, {3}}, new int[][]{{2}, {2}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 4}, {5}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 4}, {5}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 4}, {5}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{{4, 4}, {4}}, new int[][]{{5, 5}, {5}}, new int[][]{null, null}, new int[][]{{4}, {5}}, new int[][]{{4}, {3}}, new int[][]{{4}, {2}}, new int[][]{{5}, {4}}, new int[][]{{5}, {3}}, new int[][]{{5}, {2}}, new int[][]{{3}, {4}}, new int[][]{{3}, {5}}, new int[][]{{3}, {2}}, new int[][]{{2}, {4}}, new int[][]{{2}, {5}}, new int[][]{{2}, {3}}, new int[][]{{4}, {4}}, new int[][]{{4}, {4}}, new int[][]{{4}, {4}}, new int[][]{{5, 5}, {4}}, new int[][]{{3, 3}, {4}}, new int[][]{{3, 3}, {4}}, new int[][]{{2, 2}, {4}}, new int[][]{{2, 2}, {4}}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{4, 4}, null}, new int[][]{{4, 4}, null}, new int[][]{{4, 4}, null}, new int[][]{{4, 4}, null}, new int[][]{{4, 4}, null}, new int[][]{{4, 4}, null}, new int[][]{{8, 8}, null}, new int[][]{{8, 8}, null}, new int[][]{null, null}, new int[][]{null, {9}}, new int[][]{null, null}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{4}, null}, new int[][]{{5}, null}, new int[][]{{3}, null}, new int[][]{{2}, null}, new int[][]{{8}, null}, new int[][]{null, null}, null, null, null, null, null, null, null, null, null, null, null, null, new int[][]{{8}, {4}}, null, null, null, new int[][]{{8}, null}, new int[][]{{8}, null}, null, null, new int[][]{{8}, null}, new int[][]{{8}, null}, new int[][]{null, null}, new int[][]{null, {9}}};
    private static final int[] arr_type = new int[]{7, 1, 3, 2, 0, 6, 4, 5};

    public static void stepTypes(DataPoint data, Instruction instr, ConstantPool pool) {
        ListStack<VarType> stack = data.getStack();
        int[][] arr = stack_impact[instr.opcode];
        if (arr != null) {
            int[] read = arr[0];
            int[] write = arr[1];
            if (read != null) {
                int depth = 0;
                int[] nArray = read;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int type = nArray[i];
                    ++depth;
                    if (type != 5 && type != 2) continue;
                    ++depth;
                }
                stack.removeMultiple(depth);
            }
            if (write != null) {
                for (int type : write) {
                    stack.push(new VarType(type));
                    if (type != 5 && type != 2) continue;
                    stack.push(new VarType(12));
                }
            }
        } else {
            InstructionImpact.processSpecialInstructions(data, instr, pool);
        }
    }

    private static void processSpecialInstructions(DataPoint data, Instruction instr, ConstantPool pool) {
        ListStack<VarType> stack = data.getStack();
        switch (instr.opcode) {
            case 1: {
                stack.push(new VarType(13, 0, null));
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                PooledConstant constant = pool.getConstant(instr.operand(0));
                switch (constant.type) {
                    case 3: {
                        stack.push(new VarType(4));
                        break;
                    }
                    case 4: {
                        stack.push(new VarType(3));
                        break;
                    }
                    case 5: {
                        stack.push(new VarType(5));
                        stack.push(new VarType(12));
                        break;
                    }
                    case 6: {
                        stack.push(new VarType(2));
                        stack.push(new VarType(12));
                        break;
                    }
                    case 8: {
                        stack.push(new VarType(8, 0, "java/lang/String"));
                        break;
                    }
                    case 7: {
                        stack.push(new VarType(8, 0, "java/lang/Class"));
                        break;
                    }
                    case 15: {
                        stack.push(new VarType(((LinkConstant)constant).descriptor));
                    }
                }
                break;
            }
            case 25: {
                VarType var1 = data.getVariable(instr.operand(0));
                if (var1 != null) {
                    stack.push(var1);
                    break;
                }
                stack.push(new VarType(8, 0, null));
                break;
            }
            case 50: {
                VarType var1 = stack.pop(2);
                stack.push(new VarType(var1.type, var1.arrayDim - 1, var1.value));
                break;
            }
            case 58: {
                data.setVariable(instr.operand(0), stack.pop());
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                int depth1 = 88 - instr.opcode;
                stack.insertByOffset(depth1, stack.getByOffset(-1).copy());
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                int depth2 = 90 - instr.opcode;
                stack.insertByOffset(depth2, stack.getByOffset(-2).copy());
                stack.insertByOffset(depth2, stack.getByOffset(-1).copy());
                break;
            }
            case 95: {
                VarType var1 = stack.pop();
                stack.insertByOffset(-1, var1);
                break;
            }
            case 180: {
                stack.pop();
            }
            case 178: {
                LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                VarType var1 = new VarType(ck.descriptor);
                stack.push(var1);
                if (var1.stackSize != 2) break;
                stack.push(new VarType(12));
                break;
            }
            case 181: {
                stack.pop();
            }
            case 179: {
                LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                VarType var1 = new VarType(ck.descriptor);
                stack.pop(var1.stackSize);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                stack.pop();
            }
            case 184: 
            case 186: {
                if (instr.opcode == 186 && instr.bytecodeVersion < 4) break;
                LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                MethodDescriptor md = MethodDescriptor.parseDescriptor(ck.descriptor);
                for (int i = 0; i < md.params.length; ++i) {
                    stack.pop(md.params[i].stackSize);
                }
                if (md.ret.type == 10) break;
                stack.push(md.ret);
                if (md.ret.stackSize != 2) break;
                stack.push(new VarType(12));
                break;
            }
            case 187: {
                PrimitiveConstant cn = pool.getPrimitiveConstant(instr.operand(0));
                stack.push(new VarType(8, 0, cn.getString()));
                break;
            }
            case 188: {
                stack.pop();
                stack.push(new VarType(arr_type[instr.operand(0) - 4], 1).resizeArrayDim(1));
                break;
            }
            case 191: {
                VarType var1 = stack.pop();
                stack.clear();
                stack.push(var1);
                break;
            }
            case 192: 
            case 193: {
                stack.pop();
                PrimitiveConstant cn = pool.getPrimitiveConstant(instr.operand(0));
                stack.push(new VarType(8, 0, cn.getString()));
                break;
            }
            case 189: 
            case 197: {
                int dimensions = instr.opcode == 189 ? 1 : instr.operand(1);
                stack.pop(dimensions);
                PrimitiveConstant cn = pool.getPrimitiveConstant(instr.operand(0));
                if (cn.isArray) {
                    VarType var1 = new VarType(8, 0, cn.getString());
                    var1 = var1.resizeArrayDim(var1.arrayDim + dimensions);
                    stack.push(var1);
                    break;
                }
                stack.push(new VarType(8, dimensions, cn.getString()));
            }
        }
    }
}

