/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.lazy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class LazyLoader {
    private final Map<String, Link> mapClassLinks = new HashMap<String, Link>();
    private final IBytecodeProvider provider;

    public LazyLoader(IBytecodeProvider provider) {
        this.provider = provider;
    }

    public void addClassLink(String classname, Link link) {
        this.mapClassLinks.put(classname, link);
    }

    public void removeClassLink(String classname) {
        this.mapClassLinks.remove(classname);
    }

    public Link getClassLink(String classname) {
        return this.mapClassLinks.get(classname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConstantPool loadPool(String classname) {
        try (DataInputFullStream in = this.getClassStream(classname);){
            if (in != null) {
                in.discard(8);
                ConstantPool constantPool = new ConstantPool(in);
                return constantPool;
            }
            ConstantPool constantPool = null;
            return constantPool;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] loadBytecode(StructMethod mt, int codeFullLength) {
        String className = mt.getClassStruct().qualifiedName;
        try (DataInputFullStream in = this.getClassStream(className);){
            if (in != null) {
                int i;
                in.discard(8);
                ConstantPool pool = mt.getClassStruct().getPool();
                if (pool == null) {
                    pool = new ConstantPool(in);
                } else {
                    ConstantPool.skipPool(in);
                }
                in.discard(6);
                in.discard(in.readUnsignedShort() * 2);
                int size = in.readUnsignedShort();
                for (i = 0; i < size; ++i) {
                    in.discard(6);
                    LazyLoader.skipAttributes(in);
                }
                size = in.readUnsignedShort();
                for (i = 0; i < size; ++i) {
                    in.discard(2);
                    int nameIndex = in.readUnsignedShort();
                    int descriptorIndex = in.readUnsignedShort();
                    String[] values = pool.getClassElement(2, className, nameIndex, descriptorIndex);
                    if (!mt.getName().equals(values[0]) || !mt.getDescriptor().equals(values[1])) {
                        LazyLoader.skipAttributes(in);
                        continue;
                    }
                    int attrSize = in.readUnsignedShort();
                    for (int j = 0; j < attrSize; ++j) {
                        int attrNameIndex = in.readUnsignedShort();
                        String attrName = pool.getPrimitiveConstant(attrNameIndex).getString();
                        if ("Code".equals(attrName)) {
                            in.discard(12);
                            byte[] byArray = in.read(codeFullLength);
                            return byArray;
                        }
                        in.discard(in.readInt());
                    }
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DataInputFullStream getClassStream(String externalPath, String internalPath) throws IOException {
        byte[] bytes = this.provider.getBytecode(externalPath, internalPath);
        return new DataInputFullStream(bytes);
    }

    public DataInputFullStream getClassStream(String qualifiedClassName) throws IOException {
        Link link = this.mapClassLinks.get(qualifiedClassName);
        return link == null ? null : (link.data != null ? new DataInputFullStream(link.data) : this.getClassStream(link.externalPath, link.internalPath));
    }

    public static void skipAttributes(DataInputFullStream in) throws IOException {
        int length = in.readUnsignedShort();
        for (int i = 0; i < length; ++i) {
            in.discard(2);
            in.discard(in.readInt());
        }
    }

    public static class Link {
        public final String externalPath;
        public final String internalPath;
        public final byte[] data;

        public Link(String externalPath, String internalPath) {
            this(externalPath, internalPath, null);
        }

        public Link(String externalPath, String internalPath, byte[] data) {
            this.externalPath = externalPath;
            this.internalPath = internalPath;
            this.data = data;
        }
    }
}

