/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class IfExprent
extends Exprent {
    public static final int IF_EQ = 0;
    public static final int IF_NE = 1;
    public static final int IF_LT = 2;
    public static final int IF_GE = 3;
    public static final int IF_GT = 4;
    public static final int IF_LE = 5;
    public static final int IF_NULL = 6;
    public static final int IF_NONNULL = 7;
    public static final int IF_ICMPEQ = 8;
    public static final int IF_ICMPNE = 9;
    public static final int IF_ICMPLT = 10;
    public static final int IF_ICMPGE = 11;
    public static final int IF_ICMPGT = 12;
    public static final int IF_ICMPLE = 13;
    public static final int IF_ACMPEQ = 14;
    public static final int IF_ACMPNE = 15;
    public static final int IF_VALUE = 19;
    private static final int[] FUNC_TYPES = new int[]{42, 43, 44, 45, 46, 47, 42, 43, 42, 43, 44, 45, 46, 47, 42, 43, 48, 49, 12, -1};
    private Exprent condition;

    public IfExprent(int ifType, ListStack<Exprent> stack, BitSet bytecodeOffsets) {
        this(null, bytecodeOffsets);
        if (ifType <= 5) {
            stack.push(new ConstExprent(0, true, null));
        } else if (ifType <= 7) {
            stack.push(new ConstExprent(VarType.VARTYPE_NULL, null, null));
        }
        this.condition = ifType == 19 ? stack.pop() : new FunctionExprent(FUNC_TYPES[ifType], stack, bytecodeOffsets);
    }

    private IfExprent(Exprent condition, BitSet bytecodeOffsets) {
        super(7);
        this.condition = condition;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        return new IfExprent(this.condition.copy(), this.bytecode);
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.condition);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        tracer.addMapping(this.bytecode);
        return this.condition.toJava(indent, tracer).enclose("if (", ")");
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.condition) {
            this.condition = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof IfExprent)) {
            return false;
        }
        IfExprent ie = (IfExprent)o;
        return InterpreterUtil.equalObjects(this.condition, ie.getCondition());
    }

    public IfExprent negateIf() {
        this.condition = new FunctionExprent(12, this.condition, this.condition.bytecode);
        return this;
    }

    public Exprent getCondition() {
        return this.condition;
    }

    public void setCondition(Exprent condition) {
        this.condition = condition;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        IfExprent.measureBytecode(values, this.condition);
        this.measureBytecode(values);
    }
}

