/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ClearStructHelper;
import org.jetbrains.java.decompiler.modules.decompiler.DomHelper;
import org.jetbrains.java.decompiler.modules.decompiler.EliminateLoopsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExitHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.FinallyProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IdeaNotNullHelper;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LoopExtractHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.PPandMMHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StackVarsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.deobfuscator.ExceptionDeobfuscator;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public class MethodProcessorRunnable
implements Runnable {
    public final Object lock = new Object();
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProc;
    private volatile RootStatement root;
    private volatile Throwable error;
    private volatile boolean finished = false;

    public MethodProcessorRunnable(StructMethod method, MethodDescriptor methodDescriptor, VarProcessor varProc) {
        this.method = method;
        this.methodDescriptor = methodDescriptor;
        this.varProc = varProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.error = null;
        this.root = null;
        try {
            this.root = MethodProcessorRunnable.codeToJava(this.method, this.methodDescriptor, this.varProc);
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.error = ex;
        }
        this.finished = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static RootStatement codeToJava(StructMethod mt, MethodDescriptor md, VarProcessor varProc) throws IOException {
        StackVarsProcessor stackProc;
        StructClass cl = mt.getClassStruct();
        boolean isInitializer = "<clinit>".equals(mt.getName());
        mt.expandData();
        InstructionSequence seq = mt.getInstructionSequence();
        ControlFlowGraph graph = new ControlFlowGraph(seq);
        DeadCodeHelper.removeDeadBlocks(graph);
        graph.inlineJsr(mt);
        DeadCodeHelper.connectDummyExitBlock(graph);
        DeadCodeHelper.removeGotos(graph);
        ExceptionDeobfuscator.removeCircularRanges(graph);
        ExceptionDeobfuscator.restorePopRanges(graph);
        if (DecompilerContext.getOption("rer")) {
            ExceptionDeobfuscator.removeEmptyRanges(graph);
        }
        if (DecompilerContext.getOption("ner")) {
            DeadCodeHelper.incorporateValueReturns(graph);
        }
        ExceptionDeobfuscator.insertEmptyExceptionHandlerBlocks(graph);
        DeadCodeHelper.mergeBasicBlocks(graph);
        DecompilerContext.getCounterContainer().setCounter(2, mt.getLocalVariables());
        if (ExceptionDeobfuscator.hasObfuscatedExceptions(graph)) {
            DecompilerContext.getLogger().writeMessage("Heavily obfuscated exception ranges found!", IFernflowerLogger.Severity.WARN);
        }
        RootStatement root = DomHelper.parseGraph(graph, mt);
        FinallyProcessor fProc = new FinallyProcessor(md, varProc);
        while (fProc.iterateGraph(mt, root, graph)) {
            root = DomHelper.parseGraph(graph, mt);
        }
        DomHelper.removeSynchronizedHandler(root);
        SequenceHelper.condenseSequences(root);
        ClearStructHelper.clearStatements(root);
        ExprProcessor proc = new ExprProcessor(md, varProc);
        proc.processStatement(root, cl);
        SequenceHelper.condenseSequences(root);
        do {
            stackProc = new StackVarsProcessor();
            stackProc.simplifyStackVars(root, mt, cl);
            varProc.setVarVersions(root);
        } while (new PPandMMHelper(varProc).findPPandMM(root));
        do {
            LabelHelper.cleanUpEdges(root);
            while (true) {
                if (EliminateLoopsHelper.eliminateLoops(root, cl) || LoopExtractHelper.extractLoops(root)) {
                    continue;
                }
                MergeHelper.enhanceLoops(root);
                if (!IfHelper.mergeAllIfs(root)) break;
            }
            if (DecompilerContext.getOption("inn") && IdeaNotNullHelper.removeHardcodedChecks(root, mt)) {
                SequenceHelper.condenseSequences(root);
                stackProc = new StackVarsProcessor();
                stackProc.simplifyStackVars(root, mt, cl);
                varProc.setVarVersions(root);
            }
            LabelHelper.identifyLabels(root);
        } while (InlineSingleBlockHelper.inlineSingleBlocks(root) || !isInitializer && ExitHelper.condenseExits(root));
        ExitHelper.removeRedundantReturns(root);
        SecondaryFunctionsHelper.identifySecondaryFunctions(root, varProc);
        MethodProcessorRunnable.cleanSynchronizedVar(root);
        varProc.setVarDefinitions(root);
        LabelHelper.replaceContinueWithBreak(root);
        mt.releaseResources();
        return root;
    }

    public RootStatement getResult() throws Throwable {
        Throwable t = this.error;
        if (t != null) {
            throw t;
        }
        return this.root;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public static void cleanSynchronizedVar(Statement stat) {
        for (Statement st : stat.getStats()) {
            MethodProcessorRunnable.cleanSynchronizedVar(st);
        }
        if (stat.type == 10) {
            SynchronizedStatement sync = (SynchronizedStatement)stat;
            if (sync.getHeadexprentList().get((int)0).type == 9) {
                MonitorExprent mon = (MonitorExprent)sync.getHeadexprentList().get(0);
                for (Exprent e : sync.getFirst().getExprents()) {
                    if (e.type != 2) continue;
                    AssignmentExprent ass = (AssignmentExprent)e;
                    if (ass.getLeft().type != 12) continue;
                    VarExprent var = (VarExprent)ass.getLeft();
                    if (!ass.getRight().equals(mon.getValue()) || var.isVarReferenced(stat.getParent(), new VarExprent[0])) continue;
                    sync.getFirst().getExprents().remove(e);
                    break;
                }
            }
        }
    }
}

