/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarDefinitionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsProcessor;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextUtil;

public class VarProcessor {
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private Map<VarVersionPair, String> mapVarNames = new HashMap<VarVersionPair, String>();
    private Map<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable> mapVarLVTs = new HashMap<VarVersionPair, StructLocalVariableTableAttribute.LocalVariable>();
    private VarVersionsProcessor varVersions;
    private final Map<VarVersionPair, String> thisVars = new HashMap<VarVersionPair, String>();
    private final Set<VarVersionPair> externalVars = new HashSet<VarVersionPair>();

    public VarProcessor(StructMethod mt, MethodDescriptor md) {
        this.method = mt;
        this.methodDescriptor = md;
    }

    public void setVarVersions(RootStatement root) {
        VarVersionsProcessor oldProcessor = this.varVersions;
        this.varVersions = new VarVersionsProcessor(this.method, this.methodDescriptor);
        this.varVersions.setVarVersions(root, oldProcessor);
    }

    public void setVarDefinitions(Statement root) {
        this.mapVarNames = new HashMap<VarVersionPair, String>();
        new VarDefinitionHelper(root, this.method, this).setVarDefinitions();
    }

    public void setDebugVarNames(Map<VarVersionPair, String> mapDebugVarNames) {
        if (this.varVersions == null) {
            return;
        }
        Map<Integer, VarVersionPair> mapOriginalVarIndices = this.varVersions.getMapOriginalVarIndices();
        ArrayList<VarVersionPair> listVars = new ArrayList<VarVersionPair>(this.mapVarNames.keySet());
        Collections.sort(listVars, Comparator.comparingInt(o -> o.var));
        HashMap<String, Integer> mapNames = new HashMap<String, Integer>();
        for (VarVersionPair pair : listVars) {
            Integer counter;
            String debugName;
            String name = this.mapVarNames.get(pair);
            boolean lvtName = false;
            VarVersionPair key = mapOriginalVarIndices.get(pair.var);
            if (key != null && (debugName = mapDebugVarNames.get(key)) != null && TextUtil.isValidIdentifier(debugName, this.method.getClassStruct().getBytecodeVersion())) {
                name = debugName;
                lvtName = true;
            }
            mapNames.put(name, (counter = (Integer)mapNames.get(name)) == null ? (counter = Integer.valueOf(0)) : (counter = Integer.valueOf(counter + 1)));
            if (counter > 0 && !lvtName) {
                name = name + String.valueOf(counter);
            }
            this.mapVarNames.put(pair, name);
        }
    }

    public Integer getVarOriginalIndex(int index) {
        if (this.varVersions == null) {
            return null;
        }
        return this.varVersions.getMapOriginalVarIndices().get((Object)Integer.valueOf((int)index)).var;
    }

    public void refreshVarNames(VarNamesCollector vc) {
        HashMap<VarVersionPair, String> tempVarNames = new HashMap<VarVersionPair, String>(this.mapVarNames);
        for (Map.Entry ent : tempVarNames.entrySet()) {
            this.mapVarNames.put((VarVersionPair)ent.getKey(), vc.getFreeName((String)ent.getValue()));
        }
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.varVersions == null ? null : this.varVersions.getVarType(pair);
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        if (this.varVersions != null) {
            this.varVersions.setVarType(pair, type);
        }
    }

    public String getVarName(VarVersionPair pair) {
        return this.mapVarNames == null ? null : this.mapVarNames.get(pair);
    }

    public void setVarName(VarVersionPair pair, String name) {
        this.mapVarNames.put(pair, name);
    }

    public Collection<String> getVarNames() {
        return this.mapVarNames != null ? this.mapVarNames.values() : Collections.emptySet();
    }

    public int getVarFinal(VarVersionPair pair) {
        return this.varVersions == null ? 3 : this.varVersions.getVarFinal(pair);
    }

    public void setVarFinal(VarVersionPair pair, int finalType) {
        this.varVersions.setVarFinal(pair, finalType);
    }

    public Map<VarVersionPair, String> getThisVars() {
        return this.thisVars;
    }

    public Set<VarVersionPair> getExternalVars() {
        return this.externalVars;
    }

    public List<StructLocalVariableTableAttribute.LocalVariable> getCandidates(int origindex) {
        if (!this.hasLVT()) {
            return null;
        }
        return this.method.getLocalVariableAttr().matchingVars(origindex).collect(Collectors.toList());
    }

    public void findLVT(VarExprent exprent, int start) {
        if (!this.hasLVT()) {
            return;
        }
        StructLocalVariableTableAttribute.LocalVariable lvt = this.method.getLocalVariableAttr().getVariables().filter(v -> v.getVersion().var == exprent.getIndex() && v.getStart() == start).findFirst().orElse(null);
        if (lvt != null) {
            exprent.setLVT(lvt);
        }
    }

    public void copyVarInfo(VarVersionPair from, VarVersionPair to) {
        this.setVarName(to, this.getVarName(from));
        this.setVarFinal(to, this.getVarFinal(from));
        this.setVarType(to, this.getVarType(from));
        this.varVersions.getMapOriginalVarIndices().put(to.var, this.varVersions.getMapOriginalVarIndices().get(from.var));
    }

    public boolean hasLVT() {
        return this.method.getLocalVariableAttr() != null;
    }

    public Map<Integer, StructLocalVariableTableAttribute.LocalVariable> getLocalVariables(Statement stat) {
        if (!this.hasLVT() || stat == null) {
            return new HashMap<Integer, StructLocalVariableTableAttribute.LocalVariable>();
        }
        StartEndPair sep = stat.getStartEndRange();
        HashSet blacklist = new HashSet();
        Map<Integer, StructLocalVariableTableAttribute.LocalVariable> ret = this.method.getLocalVariableAttr().getVariables().filter(lv -> lv.getEnd() > sep.start && lv.getStart() <= sep.end).collect(Collectors.toMap(lv -> lv.getVersion().var, lv -> lv, (lv1, lv2) -> {
            blacklist.add(lv1.getVersion().var);
            return lv1;
        }));
        for (Integer b : blacklist) {
            ret.remove(b);
        }
        return ret;
    }

    public VarVersionsProcessor getVarVersions() {
        return this.varVersions;
    }

    public void setVarLVT(VarVersionPair var, StructLocalVariableTableAttribute.LocalVariable lvt) {
        this.mapVarLVTs.put(var, lvt);
    }

    public StructLocalVariableTableAttribute.LocalVariable getVarLVT(VarVersionPair var) {
        return this.mapVarLVTs.get(var);
    }
}

