/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class VarExprent
extends Exprent {
    public static final int STACK_BASE = 10000;
    public static final String VAR_NAMELESS_ENCLOSURE = "<VAR_NAMELESS_ENCLOSURE>";
    private int index;
    private VarType varType;
    private boolean definition = false;
    private VarProcessor processor;
    private int version = 0;
    private boolean classDef = false;
    private boolean stack = false;
    private StructLocalVariableTableAttribute.LocalVariable lvt = null;

    public VarExprent(int index, VarType varType, VarProcessor processor) {
        this(index, varType, processor, null);
    }

    public VarExprent(int index, VarType varType, VarProcessor processor, BitSet bytecode) {
        super(12);
        this.index = index;
        this.varType = varType;
        this.processor = processor;
        this.addBytecodeOffsets(bytecode);
    }

    @Override
    public VarType getExprType() {
        return this.getVarType();
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        if (this.lvt != null && this.lvt.getSignature() != null) {
            try {
                return GenericType.parse(this.lvt.getSignature());
            }
            catch (StringIndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
        } else if (this.lvt != null) {
            return this.lvt.getVarType();
        }
        return this.getVarType();
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public Exprent copy() {
        VarExprent var = new VarExprent(this.index, this.getVarType(), this.processor, this.bytecode);
        var.setDefinition(this.definition);
        var.setVersion(this.version);
        var.setClassDef(this.classDef);
        var.setStack(this.stack);
        var.setLVT(this.lvt);
        return var;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buffer = new TextBuffer();
        tracer.addMapping(this.bytecode);
        if (this.classDef) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.varType.value);
            new ClassWriter().classToJava(child, buffer, indent, tracer);
            tracer.incrementCurrentSourceLine(buffer.countLines());
        } else {
            VarVersionPair varVersion = this.getVarVersionPair();
            if (this.definition) {
                if (this.processor != null && this.processor.getVarFinal(varVersion) == 2) {
                    buffer.append("final ");
                }
                this.appendDefinitionType(buffer);
                buffer.append(" ");
            }
            buffer.append(this.getName());
        }
        return buffer;
    }

    public VarVersionPair getVarVersionPair() {
        return new VarVersionPair(this.index, this.version);
    }

    private void appendDefinitionType(TextBuffer buffer) {
        if (DecompilerContext.getOption("udv")) {
            if (this.lvt != null) {
                GenericFieldDescriptor descriptor;
                if (DecompilerContext.getOption("dgs") && this.lvt.getSignature() != null && (descriptor = GenericMain.parseFieldSignature(this.lvt.getSignature())) != null) {
                    buffer.append(ExprProcessor.getCastTypeName(descriptor.type));
                    return;
                }
                buffer.append(ExprProcessor.getCastTypeName(this.getVarType()));
                return;
            }
            MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
            if (method != null) {
                int visibleOffset;
                Integer originalIndex = null;
                if (this.processor != null) {
                    originalIndex = this.processor.getVarOriginalIndex(this.index);
                }
                int n = visibleOffset = this.bytecode == null ? -1 : this.bytecode.length();
                if (originalIndex != null) {
                    String descriptor;
                    GenericFieldDescriptor descriptor2;
                    String signature;
                    StructGeneralAttribute attr;
                    if (DecompilerContext.getOption("dgs") && (attr = (StructLocalVariableTypeTableAttribute)method.methodStruct.getAttribute("LocalVariableTypeTable")) != null && (signature = ((StructLocalVariableTypeTableAttribute)attr).getSignature(originalIndex, visibleOffset)) != null && (descriptor2 = GenericMain.parseFieldSignature(signature)) != null) {
                        buffer.append(ExprProcessor.getCastTypeName(descriptor2.type));
                        return;
                    }
                    attr = method.methodStruct.getLocalVariableAttr();
                    if (attr != null && (descriptor = ((StructLocalVariableTableAttribute)attr).getDescriptor(originalIndex, visibleOffset)) != null) {
                        buffer.append(ExprProcessor.getCastTypeName(new VarType(descriptor)));
                        return;
                    }
                }
            }
        }
        buffer.append(ExprProcessor.getCastTypeName(this.getVarType()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion() && InterpreterUtil.equalObjects(this.getVarType(), ve.getVarType());
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        this.measureBytecode(values);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public VarType getVarType() {
        if (DecompilerContext.getOption("udv") && this.lvt != null) {
            return new VarType(this.lvt.getDescriptor());
        }
        VarType vt = null;
        if (this.processor != null) {
            vt = this.processor.getVarType(this.getVarVersionPair());
        }
        if (vt == null || this.varType != null && this.varType.type != 17) {
            vt = this.varType;
        }
        return vt == null ? VarType.VARTYPE_UNKNOWN : vt;
    }

    public void setVarType(VarType varType) {
        this.varType = varType;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public VarProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(VarProcessor processor) {
        this.processor = processor;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isClassDef() {
        return this.classDef;
    }

    public void setClassDef(boolean classDef) {
        this.classDef = classDef;
    }

    public boolean isStack() {
        return this.stack;
    }

    public void setStack(boolean stack) {
        this.stack = stack;
    }

    public void setLVT(StructLocalVariableTableAttribute.LocalVariable var) {
        this.lvt = var;
        if (this.processor != null && this.lvt != null) {
            this.processor.setVarType(this.getVarVersionPair(), this.lvt.getVarType());
        }
    }

    public StructLocalVariableTableAttribute.LocalVariable getLVT() {
        return this.lvt;
    }

    public String getName() {
        VarVersionPair pair = this.getVarVersionPair();
        if (this.lvt != null) {
            return this.lvt.getName();
        }
        if (this.processor != null) {
            return this.processor.getVarName(pair);
        }
        return pair.version == 0 ? "var" + pair.var : "var" + pair.var + "_" + this.version;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        if (this.lvt != null) {
            CheckTypesResult ret = new CheckTypesResult();
            ret.addMinTypeExprent(this, this.lvt.getVarType());
            return ret;
        }
        return null;
    }

    public boolean isVarReferenced(Statement stat, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (!(obj instanceof Statement ? this.isVarReferenced((Statement)obj, whitelist) : obj instanceof Exprent && this.isVarReferenced((Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                if (!this.isVarReferenced(exp, whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVarReferenced(Exprent exp, VarExprent ... whitelist) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        lst = lst.stream().filter(e -> e != this && e.type == 12 && this.getVarVersionPair().equals(((VarExprent)e).getVarVersionPair())).collect(Collectors.toList());
        for (Exprent var : lst) {
            boolean allowed = false;
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRules().get((Object)IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        return rule == null || !(rule.isVariable() ? !engine.checkAndSetVariableValue((String)rule.value, this.index) : this.index != Integer.valueOf((String)rule.value));
    }
}

