/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.code.interpreter.Util;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ClasspathHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextUtil;

public class InvocationExprent
extends Exprent {
    public static final int INVOKE_SPECIAL = 1;
    public static final int INVOKE_VIRTUAL = 2;
    public static final int INVOKE_STATIC = 3;
    public static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_DYNAMIC = 5;
    public static final int TYP_GENERAL = 1;
    public static final int TYP_INIT = 2;
    public static final int TYP_CLINIT = 3;
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private String name;
    private String classname;
    private boolean isStatic;
    private int functype = 1;
    private Exprent instance;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invokeDynamicClassSuffix;
    private int invocationTyp = 2;
    private List<Exprent> lstParameters = new ArrayList<Exprent>();
    private List<PooledConstant> bootstrapArguments;
    private List<VarType> genericArgs = new ArrayList<VarType>();
    private boolean forceBoxing = false;

    public InvocationExprent() {
        super(8);
    }

    public InvocationExprent(int opcode, LinkConstant cn, List<PooledConstant> bootstrapArguments, ListStack<Exprent> stack, BitSet bytecodeOffsets) {
        this();
        this.name = cn.elementname;
        this.classname = cn.classname;
        this.bootstrapArguments = bootstrapArguments;
        switch (opcode) {
            case 184: {
                this.invocationTyp = 3;
                break;
            }
            case 183: {
                this.invocationTyp = 1;
                break;
            }
            case 182: {
                this.invocationTyp = 2;
                break;
            }
            case 185: {
                this.invocationTyp = 4;
                break;
            }
            case 186: {
                this.invocationTyp = 5;
                this.classname = "java/lang/Class";
                this.invokeDynamicClassSuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.functype = 2;
        } else if ("<clinit>".equals(this.name)) {
            this.functype = 3;
        }
        this.stringDescriptor = cn.descriptor;
        this.descriptor = MethodDescriptor.parseDescriptor(cn.descriptor);
        for (VarType ignored : this.descriptor.params) {
            this.lstParameters.add(0, stack.pop());
        }
        if (opcode == 186) {
            PooledConstant link;
            int dynamicInvocationType = -1;
            if (bootstrapArguments != null && bootstrapArguments.size() > 1 && (link = bootstrapArguments.get(1)) instanceof LinkConstant) {
                dynamicInvocationType = ((LinkConstant)link).index1;
            }
            if (dynamicInvocationType == 6) {
                this.isStatic = true;
            } else if (!this.lstParameters.isEmpty()) {
                this.instance = this.lstParameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private InvocationExprent(InvocationExprent expr) {
        this();
        this.name = expr.getName();
        this.classname = expr.getClassname();
        this.isStatic = expr.isStatic();
        this.functype = expr.getFunctype();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationTyp = expr.getInvocationTyp();
        this.invokeDynamicClassSuffix = expr.getInvokeDynamicClassSuffix();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        this.lstParameters = new ArrayList<Exprent>(expr.getLstParameters());
        ExprProcessor.copyEntries(this.lstParameters);
        this.addBytecodeOffsets(expr.bytecode);
        this.bootstrapArguments = expr.getBootstrapArguments();
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        List<StructMethod> matches = this.getMatchedDescriptors();
        StructMethod desc = null;
        if (matches.size() == 1) {
            desc = matches.get(0);
        }
        this.genericArgs.clear();
        if (desc != null && desc.getSignature() != null) {
            VarType _new;
            StructClass cls;
            VarType instType;
            VarType ret = desc.getSignature().ret;
            if (this.instance != null && (instType = this.instance.getInferredExprType(upperBound)).isGeneric() && (cls = DecompilerContext.getStructContext().getClass(instType.value)) != null && cls.getSignature() != null) {
                HashMap<VarType, VarType> map = new HashMap<VarType, VarType>();
                GenericType ginstance = (GenericType)instType;
                if (cls.getSignature().fparameters.size() == ginstance.getArguments().size()) {
                    for (int x = 0; x < ginstance.getArguments().size(); ++x) {
                        if (ginstance.getArguments().get(x) == null) continue;
                        map.put(GenericType.parse("T" + cls.getSignature().fparameters.get(x) + ";"), ginstance.getArguments().get(x));
                    }
                }
                if (!map.isEmpty()) {
                    ret = ret.remap(map);
                }
            }
            if (desc.getSignature().ret != (_new = this.gatherGenerics(upperBound, ret, desc.getSignature().fparameters, this.genericArgs))) {
                return _new;
            }
        }
        return this.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            Exprent parameter = this.lstParameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.typeFamily));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.lstParameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        GenericType genType;
        VarType inferred;
        ClassesProcessor.ClassNode newNode;
        TextBuffer buf = new TextBuffer();
        String super_qualifier = null;
        boolean isInstanceThis = false;
        tracer.addMapping(this.bytecode);
        if (this.isStatic) {
            if (this.isBoxingCall() && !this.forceBoxing) {
                ExprProcessor.getCastedExprent(this.lstParameters.get(0), this.descriptor.params[0], buf, indent, false, false, false, tracer);
                return buf;
            }
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getShortNameInClassContext(ExprProcessor.buildJavaClassName(this.classname)));
            }
        } else {
            if (this.instance != null && this.instance.type == 12) {
                MethodWrapper currentMethod;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair varPair = new VarVersionPair(instVar);
                VarProcessor varProc = instVar.getProcessor();
                if (varProc == null && (currentMethod = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
                    varProc = currentMethod.varproc;
                }
                String this_classname = null;
                if (varProc != null) {
                    this_classname = varProc.getThisVars().get(varPair);
                }
                if (this_classname != null) {
                    isInstanceThis = true;
                    if (this.invocationTyp == 1 && !this.classname.equals(this_classname)) {
                        super_qualifier = this_classname;
                    }
                }
            }
            if (this.functype == 1) {
                if (super_qualifier != null) {
                    TextUtil.writeQualifiedSuper(buf, super_qualifier);
                } else if (this.instance != null) {
                    TextBuffer res = this.instance.toJava(indent, tracer);
                    VarType rightType = this.instance.getExprType();
                    VarType leftType = new VarType(8, 0, this.classname);
                    if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType)) {
                        buf.append("((").append(ExprProcessor.getCastTypeName(leftType)).append(")");
                        if (this.instance.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                            res.enclose("(", ")");
                        }
                        buf.append(res).append(")");
                    } else if (this.instance.getPrecedence() > this.getPrecedence()) {
                        buf.append("(").append(res).append(")");
                    } else {
                        buf.append(res);
                    }
                }
            }
        }
        switch (this.functype) {
            case 1: {
                if ("<VAR_NAMELESS_ENCLOSURE>".equals(buf.toString())) {
                    buf = new TextBuffer();
                }
                if (buf.length() > 0) {
                    buf.append(".");
                    this.appendParameters(buf, this.genericArgs);
                }
                buf.append(this.name);
                if (this.invocationTyp == 5) {
                    buf.append("<invokedynamic>");
                }
                buf.append("(");
                break;
            }
            case 3: {
                throw new RuntimeException("Explicit invocation of <clinit>");
            }
            case 2: {
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                if (this.instance != null) {
                    buf.append(this.instance.toJava(indent, tracer)).append(".<init>(");
                    break;
                }
                throw new RuntimeException("Unrecognized invocation of <init>");
            }
        }
        List<VarVersionPair> sigFields = null;
        boolean isEnum = false;
        if (this.functype == 2 && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname)) != null) {
            if (newNode.getWrapper() != null) {
                sigFields = newNode.getWrapper().getMethodWrapper((String)"<init>", (String)this.stringDescriptor).signatureFields;
            } else if (newNode.type == 1 && (newNode.access & 8) == 0) {
                sigFields = new ArrayList<VarVersionPair>(Collections.nCopies(this.lstParameters.size(), null));
                sigFields.set(0, new VarVersionPair(-1, 0));
            }
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("den");
        }
        List<StructMethod> matches = this.getMatchedDescriptors();
        BitSet setAmbiguousParameters = this.getAmbiguousParameters(matches);
        StructMethod desc = null;
        if (matches.size() == 1) {
            desc = matches.get(0);
        }
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        HashMap<VarType, VarType> genArgs = new HashMap<VarType, VarType>();
        VarType varType = inferred = this.instance == null ? null : this.instance.getInferredExprType(null);
        if (cl != null && cl.getSignature() != null && this.instance != null && inferred.isGeneric() && (genType = (GenericType)inferred).getArguments().size() == cl.getSignature().fparameters.size()) {
            for (int i = 0; i < cl.getSignature().fparameters.size(); ++i) {
                VarType from = GenericType.parse("T" + cl.getSignature().fparameters.get(i) + ";");
                VarType to = genType.getArguments().get(i);
                if (from == null || to == null) continue;
                genArgs.put(from, to);
            }
        }
        if (this.lstParameters.size() == this.descriptor.params.length && this.isVarArgCall()) {
            Exprent lastParam = this.lstParameters.get(this.lstParameters.size() - 1);
            if (lastParam.type == 10 && lastParam.getExprType().arrayDim >= 1) {
                ((NewExprent)lastParam).setVarArgParam(true);
            }
        }
        int start = isEnum ? 2 : 0;
        ArrayList<Exprent> parameters = new ArrayList<Exprent>(this.lstParameters);
        VarType[] types = Arrays.copyOf(this.descriptor.params, this.descriptor.params.length);
        for (int i = start; i < parameters.size(); ++i) {
            Exprent par = (Exprent)parameters.get(i);
            if (par.type != 8 || !((InvocationExprent)par).isBoxingCall()) continue;
            InvocationExprent inv = (InvocationExprent)par;
            if (!setAmbiguousParameters.get(i)) {
                inv.forceBoxing = true;
                continue;
            }
            Exprent value = inv.lstParameters.get(0);
            types[i] = value.getExprType();
            if (types[i] == VarType.VARTYPE_BYTECHAR || types[i] == VarType.VARTYPE_SHORTCHAR) {
                types[i] = "java/lang/Short".equals(inv.classname) ? VarType.VARTYPE_SHORT : ("java/lang/Byte".equals(inv.classname) ? VarType.VARTYPE_BYTE : VarType.VARTYPE_CHAR);
            }
            int count = 0;
            StructClass stClass = DecompilerContext.getStructContext().getClass(this.classname);
            if (stClass != null) {
                block7: for (StructMethod mt : stClass.getMethods()) {
                    if (!this.name.equals(mt.getName())) continue;
                    MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                    if (md.params.length != this.descriptor.params.length) continue;
                    for (int x = 0; x < md.params.length; ++x) {
                        if (md.params[x].typeFamily != this.descriptor.params[x].typeFamily && md.params[x].typeFamily != types[x].typeFamily) continue block7;
                    }
                    ++count;
                }
            }
            if (count != matches.size()) {
                types[i] = this.descriptor.params[i];
                inv.forceBoxing = true;
                continue;
            }
            value.addBytecodeOffsets(inv.bytecode);
            parameters.set(i, value);
        }
        boolean firstParameter = true;
        for (int i = start; i < parameters.size(); ++i) {
            if (sigFields != null && sigFields.get(i) != null) continue;
            TextBuffer buff = new TextBuffer();
            boolean ambiguous = setAmbiguousParameters.get(i);
            Exprent param = (Exprent)parameters.get(i);
            ExprProcessor.getCastedExprent(param, types[i], buff, indent, true, ambiguous, true, tracer);
            if (buff.length() > 0) {
                if (!firstParameter) {
                    buf.append(", ");
                }
                buf.append(buff);
            }
            firstParameter = false;
        }
        buf.append(")");
        return buf;
    }

    private boolean isVarArgCall() {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl != null) {
            StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
            if (mt != null) {
                return mt.hasModifier(128);
            }
        } else {
            Method mtd = ClasspathHelper.findMethod(this.classname, this.name, this.descriptor);
            return mtd != null && mtd.isVarArgs();
        }
        return false;
    }

    private boolean isBoxingCall() {
        if (this.isStatic && "valueOf".equals(this.name) && this.lstParameters.size() == 1) {
            int paramType = this.lstParameters.get((int)0).getExprType().type;
            if (this.lstParameters.get((int)0).type == 3 && (paramType == 15 || paramType == 16) && (this.classname.equals("java/lang/Character") || this.classname.equals("java/lang/Short"))) {
                return true;
            }
            return this.classname.equals(InvocationExprent.getClassNameForPrimitiveType(paramType));
        }
        return false;
    }

    private static String getClassNameForPrimitiveType(int type) {
        switch (type) {
            case 7: {
                return "java/lang/Boolean";
            }
            case 0: 
            case 15: {
                return "java/lang/Byte";
            }
            case 1: {
                return "java/lang/Character";
            }
            case 6: 
            case 16: {
                return "java/lang/Short";
            }
            case 4: {
                return "java/lang/Integer";
            }
            case 5: {
                return "java/lang/Long";
            }
            case 3: {
                return "java/lang/Float";
            }
            case 2: {
                return "java/lang/Double";
            }
        }
        return null;
    }

    private List<StructMethod> getMatchedDescriptors() {
        ArrayList<StructMethod> matches = new ArrayList<StructMethod>();
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null) {
            return matches;
        }
        block0: for (StructMethod mt : cl.getMethods()) {
            if (!this.name.equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length != this.descriptor.params.length) continue;
            for (int i = 0; i < md.params.length; ++i) {
                if (md.params[i].typeFamily != this.descriptor.params[i].typeFamily) continue block0;
            }
            matches.add(mt);
        }
        return matches;
    }

    private BitSet getAmbiguousParameters(List<StructMethod> matches) {
        int i;
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null || matches.size() == 1) {
            return EMPTY_BIT_SET;
        }
        BitSet missed = new BitSet(this.lstParameters.size());
        StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
        if (mt != null) {
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length == this.lstParameters.size()) {
                boolean exact = true;
                for (i = 0; i < md.params.length; ++i) {
                    if (md.params[i].equals(this.lstParameters.get(i).getExprType())) continue;
                    missed.set(i);
                    exact = false;
                }
                if (exact) {
                    return EMPTY_BIT_SET;
                }
            }
        }
        ArrayList<StructMethod> mtds = new ArrayList<StructMethod>();
        for (StructMethod mtt : matches) {
            boolean failed = false;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
            for (int i2 = 0; i2 < this.lstParameters.size(); ++i2) {
                VarType ptype = this.lstParameters.get(i2).getExprType();
                if (!missed.get(i2)) {
                    if (md.params[i2].equals(ptype)) continue;
                    failed = true;
                    break;
                }
                if (md.params[i2].type != 8 || ptype.type == 13 || Util.instanceOf(DecompilerContext.getStructContext(), ptype.value, md.params[i2].value)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            mtds.add(mtt);
        }
        BitSet ambiguous = new BitSet(this.descriptor.params.length);
        block3: for (i = 0; i < this.descriptor.params.length; ++i) {
            StructMethod mtt;
            VarType paramType = this.descriptor.params[i];
            Iterator iterator = mtds.iterator();
            while (iterator.hasNext() && ((mtt = (StructMethod)iterator.next()).getSignature() == null || !mtt.getSignature().params.get(i).isGeneric())) {
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
                if (paramType.equals(md.params[i])) continue;
                ambiguous.set(i);
                continue block3;
            }
        }
        return ambiguous;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            if (oldExpr != this.lstParameters.get(i)) continue;
            this.lstParameters.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return InterpreterUtil.equalObjects(this.name, it.getName()) && InterpreterUtil.equalObjects(this.classname, it.getClassname()) && this.isStatic == it.isStatic() && InterpreterUtil.equalObjects(this.instance, it.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, it.getDescriptor()) && this.functype == it.getFunctype() && InterpreterUtil.equalLists(this.lstParameters, it.getLstParameters());
    }

    public List<Exprent> getLstParameters() {
        return this.lstParameters;
    }

    public void setLstParameters(List<Exprent> lstParameters) {
        this.lstParameters = lstParameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public int getFunctype() {
        return this.functype;
    }

    public void setFunctype(int functype) {
        this.functype = functype;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public int getInvocationTyp() {
        return this.invocationTyp;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invokeDynamicClassSuffix;
    }

    public List<PooledConstant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        InvocationExprent.measureBytecode(values, this.lstParameters);
        InvocationExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER ? value.isVariable() && (value.parameter >= this.lstParameters.size() || !engine.checkAndSetVariableValue(value.value.toString(), this.lstParameters.get(value.parameter))) : (key == IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS ? !value.value.equals(this.classname) : key == IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE && !value.value.equals(this.name + this.stringDescriptor)))) continue;
            return false;
        }
        return true;
    }
}

