/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmlonlyclient;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModWorkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static boolean loadingComplete;
    private static LoadingFailedException error;

    public static void begin(Minecraft minecraft, PackRepository defaultResourcePacks, ReloadableResourceManager mcResourceManager) {
        Runtime.getRuntime().addShutdownHook(new Thread(LogManager::shutdown));
        loading = true;
        mc = minecraft;
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().gatherAndInitializeMods(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor(), () -> {})).run();
        mcResourceManager.m_7217_(ClientModLoader::onResourceReload);
    }

    private static CompletableFuture<Void> onResourceReload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller executeProfiler, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(ClientModLoader.createRunnableWithCatch(() -> ClientModLoader.startModLoading(ModWorkManager.wrappedExecutor((Executor)syncExecutor), asyncExecutor)), ModWorkManager.parallelExecutor()).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(ModWorkManager.wrappedExecutor((Executor)syncExecutor), asyncExecutor), ModWorkManager.parallelExecutor());
    }

    private static Runnable createRunnableWithCatch(Runnable r) {
        return () -> {
            block3: {
                if (loadingComplete) {
                    return;
                }
                try {
                    r.run();
                }
                catch (LoadingFailedException e) {
                    if (error != null) break block3;
                    error = e;
                }
            }
        };
    }

    private static void startModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        if (error != null) {
            throw error;
        }
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().loadMods(syncExecutor, parallelExecutor, () -> {})).run();
    }

    private static void postSidedRunnable() {
    }

    private static void finishModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        if (error != null) {
            throw error;
        }
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().finishMods(syncExecutor, parallelExecutor, () -> {})).run();
        loading = false;
        loadingComplete = true;
        syncExecutor.execute(() -> ClientModLoader.mc.f_91066_.m_92140_());
    }

    public static boolean completeModLoading() {
        return true;
    }

    public static void renderProgressText() {
    }

    public static boolean isLoading() {
        return loading;
    }

    private static class SpacedRunnable
    implements Runnable {
        static final long NANO_SLEEP_TIME = TimeUnit.MILLISECONDS.toNanos(50L);
        private final Runnable wrapped;
        private long lastRun;

        private SpacedRunnable(Runnable wrapped) {
            this.wrapped = wrapped;
            this.lastRun = System.nanoTime() - NANO_SLEEP_TIME;
        }

        @Override
        public void run() {
            if (System.nanoTime() - this.lastRun > NANO_SLEEP_TIME) {
                this.wrapped.run();
                this.lastRun = System.nanoTime();
            }
        }
    }
}

