/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.progress.Message;
import net.minecraftforge.fml.loading.progress.ProgressMeter;

public class StartupNotificationManager {
    private static volatile EnumMap<Message.MessageType, List<Message>> messages = new EnumMap(Message.MessageType.class);
    private static final Deque<ProgressMeter> progressMeters = new ArrayDeque<ProgressMeter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProgressMeter> getCurrentProgress() {
        Deque<ProgressMeter> deque = progressMeters;
        synchronized (deque) {
            return progressMeters.stream().toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressMeter addProgressBar(String barName, int count) {
        ProgressMeter pm = new ProgressMeter(barName, count, 0, new Message(barName, Message.MessageType.ML));
        Deque<ProgressMeter> deque = progressMeters;
        synchronized (deque) {
            progressMeters.push(pm);
        }
        return pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popBar(ProgressMeter progressMeter) {
        Deque<ProgressMeter> deque = progressMeters;
        synchronized (deque) {
            progressMeters.remove(progressMeter);
        }
    }

    public static List<AgeMessage> getMessages() {
        long ts = System.nanoTime();
        return messages.values().stream().flatMap(Collection::stream).sorted(Comparator.comparingLong(Message::timestamp).thenComparing(Message::getText).reversed()).map(m -> new AgeMessage((int)((ts - m.timestamp()) / 1000000L), (Message)m)).limit(2L).toList();
    }

    private static synchronized void addMessage(Message.MessageType type, String message, int maxSize) {
        EnumMap<Message.MessageType, List<Message>> newMessages = new EnumMap<Message.MessageType, List<Message>>(messages);
        newMessages.compute(type, (key, existingList) -> {
            ArrayList newList = new ArrayList();
            if (existingList != null) {
                if (maxSize < 0) {
                    newList.addAll(existingList);
                } else {
                    newList.addAll(existingList.subList(0, Math.min(existingList.size(), maxSize)));
                }
            }
            newList.add(new Message(message, type));
            return newList;
        });
        messages = newMessages;
    }

    public static void addModMessage(String message) {
        String safeMessage = Ascii.truncate((CharSequence)CharMatcher.ascii().retainFrom((CharSequence)message), (int)80, (String)"~");
        StartupNotificationManager.addMessage(Message.MessageType.MOD, safeMessage, 20);
    }

    public static Optional<Consumer<String>> modLoaderConsumer() {
        return Optional.of(s -> StartupNotificationManager.addMessage(Message.MessageType.ML, s, -1));
    }

    public static Optional<Consumer<String>> locatorConsumer() {
        return Optional.of(s -> StartupNotificationManager.addMessage(Message.MessageType.LOC, s, -1));
    }

    public static Optional<Consumer<String>> mcLoaderConsumer() {
        return Optional.of(s -> StartupNotificationManager.addMessage(Message.MessageType.MC, s, -1));
    }

    public record AgeMessage(int age, Message message) {
    }
}

