/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import org.slf4j.Logger;

public class FMLConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FMLConfig INSTANCE = new FMLConfig();
    private static final ConfigSpec configSpec = new ConfigSpec();
    private static final CommentedConfig configComments = CommentedConfig.inMemory();
    private CommentedFileConfig configData;

    private static Object maxThreads(Object value) {
        int val = (Integer)value;
        if (val <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return val;
    }

    private void loadFrom(Path configFile) {
        this.configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile).sync().onFileNotFound(FileNotFoundAction.copyData((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/META-INF/defaultfmlconfig.toml")))).writingMode(WritingMode.REPLACE).build();
        try {
            this.configData.load();
        }
        catch (ParsingException e) {
            throw new RuntimeException("Failed to load FML config from " + configFile, e);
        }
        if (!configSpec.isCorrect((Config)this.configData)) {
            LOGGER.warn(LogMarkers.CORE, "Configuration file {} is not correct. Correcting", (Object)configFile);
            configSpec.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> LOGGER.info(LogMarkers.CORE, "Incorrect key {} was corrected from {} to {}", new Object[]{path, incorrectValue, correctedValue}));
        }
        this.configData.putAllComments((UnmodifiableCommentedConfig)configComments);
        this.configData.save();
    }

    public static void load() {
        Path configFile = FMLPaths.FMLCONFIG.get();
        INSTANCE.loadFrom(configFile);
        if (LOGGER.isTraceEnabled(LogMarkers.CORE)) {
            LOGGER.trace(LogMarkers.CORE, "Loaded FML config from {}", (Object)FMLPaths.FMLCONFIG.get());
            for (ConfigValue cv : ConfigValue.values()) {
                LOGGER.trace(LogMarkers.CORE, "FMLConfig {} is {}", (Object)cv.entry, cv.getConfigValue(FMLConfig.INSTANCE.configData));
            }
        }
        FMLPaths.getOrCreateGameRelativePath(Paths.get(FMLConfig.getConfigValue(ConfigValue.DEFAULT_CONFIG_PATH), new String[0]));
    }

    public static String getConfigValue(ConfigValue v) {
        return (String)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static boolean getBoolConfigValue(ConfigValue v) {
        return (Boolean)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static int getIntConfigValue(ConfigValue v) {
        return (Integer)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static <A> List<A> getListConfigValue(ConfigValue v) {
        return (List)v.getConfigValue(FMLConfig.INSTANCE.configData);
    }

    public static <T> void updateConfig(ConfigValue v, T value) {
        v.updateValue(FMLConfig.INSTANCE.configData, value);
        FMLConfig.INSTANCE.configData.save();
    }

    public static String defaultConfigPath() {
        return FMLConfig.getConfigValue(ConfigValue.DEFAULT_CONFIG_PATH);
    }

    static {
        for (ConfigValue cv : ConfigValue.values()) {
            cv.buildConfigEntry(configSpec, configComments);
        }
    }

    public static enum ConfigValue {
        EARLY_WINDOW_CONTROL("earlyWindowControl", Boolean.TRUE, "Should we control the window. Disabling this disables new GL features and can be bad for mods that rely on them."),
        MAX_THREADS("maxThreads", -1, "Max threads for early initialization parallelism,  -1 is based on processor count", FMLConfig::maxThreads),
        VERSION_CHECK("versionCheck", Boolean.TRUE, "Enable forge global version checking"),
        DEFAULT_CONFIG_PATH("defaultConfigPath", "defaultconfigs", "Default config path for servers"),
        DISABLE_OPTIMIZED_DFU("disableOptimizedDFU", Boolean.TRUE, "Disables Optimized DFU client-side - already disabled on servers"),
        EARLY_WINDOW_PROVIDER("earlyWindowProvider", "fmlearlywindow", "Early window provider"),
        EARLY_WINDOW_WIDTH("earlyWindowWidth", 854, "Early window width"),
        EARLY_WINDOW_HEIGHT("earlyWindowHeight", 480, "Early window height"),
        EARLY_WINDOW_FBSCALE("earlyWindowFBScale", 1, "Early window framebuffer scale"),
        EARLY_WINDOW_MAXIMIZED("earlyWindowMaximized", Boolean.FALSE, "Early window starts maximized");

        private final String entry;
        private final Object defaultValue;
        private final String comment;
        private final Class<?> valueType;
        private final Function<Object, Object> entryFunction;

        private ConfigValue(String entry, Object defaultValue, String comment) {
            this(entry, defaultValue, comment, Function.identity());
        }

        private ConfigValue(String entry, Object defaultValue, String comment, Function<Object, Object> entryFunction) {
            this.entry = entry;
            this.defaultValue = defaultValue;
            this.comment = comment;
            this.valueType = defaultValue.getClass();
            this.entryFunction = entryFunction;
        }

        void buildConfigEntry(ConfigSpec spec, CommentedConfig commentedConfig) {
            Object object = this.defaultValue;
            if (object instanceof List) {
                List list = (List)object;
                spec.defineList(this.entry, list, e -> e instanceof String);
            } else {
                spec.define(this.entry, this.defaultValue);
            }
            commentedConfig.add(this.entry, this.defaultValue);
            commentedConfig.setComment(this.entry, this.comment);
        }

        private <T> T getConfigValue(CommentedFileConfig config) {
            return (T)this.entryFunction.apply(config.get(this.entry));
        }

        public <T> void updateValue(CommentedFileConfig configData, T value) {
            configData.set(this.entry, value);
        }
    }
}

