/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.minecraftforge.fml.loading.ClasspathLocatorUtils;
import org.apache.logging.log4j.LogManager;

public class ClasspathTransformerDiscoverer
implements ITransformerDiscoveryService {
    private final List<Path> legacyClasspath = Arrays.stream(System.getProperty("legacyClassPath", "").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).toList();
    private static final List<NamedPath> found = new ArrayList<NamedPath>();

    public List<NamedPath> candidates(Path gameDirectory) {
        return Collections.emptyList();
    }

    public List<NamedPath> candidates(Path gameDirectory, String launchTarget) {
        if (launchTarget != null && launchTarget.contains("dev")) {
            this.scan(gameDirectory);
        }
        return List.copyOf(found);
    }

    public static List<Path> allExcluded() {
        return found.stream().map(np -> np.paths()[0]).toList();
    }

    private void scan(Path gameDirectory) {
        try {
            this.locateTransformers("META-INF/services/cpw.mods.modlauncher.api.ITransformationService");
            this.locateTransformers("META-INF/services/net.minecraftforge.forgespi.locating.IModLocator");
        }
        catch (IOException e) {
            LogManager.getLogger().error("Error during discovery of transform services from the classpath", (Throwable)e);
        }
    }

    private void locateTransformers(String resource) throws IOException {
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(resource);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Path path = ClasspathLocatorUtils.findJarPathFor(resource, url.toString(), url);
            if (this.legacyClasspath.stream().anyMatch(path::equals) || !Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) continue;
            found.add(new NamedPath(path.toUri().toString(), new Path[]{path}));
        }
    }
}

