/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.slf4j.Logger;

public class UniqueModListBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ModFile> modFiles;

    public UniqueModListBuilder(List<ModFile> modFiles) {
        this.modFiles = modFiles;
    }

    public UniqueModListData buildUniqueList() {
        Map<String, List<ModFile>> modFilesByFirstId = this.modFiles.stream().filter(mf -> mf.getModFileInfo() != null).collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        Map<String, List<ModFile>> libFilesWithVersionByModuleName = this.modFiles.stream().filter(mf -> mf.getModFileInfo() == null).collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        List<ModFile> uniqueModList = modFilesByFirstId.entrySet().stream().map(this::selectNewestModInfo).toList();
        List<ModFile> uniqueLibListWithVersion = libFilesWithVersionByModuleName.entrySet().stream().map(this::selectNewestModInfo).toList();
        Map<String, List<IModInfo>> modIds = uniqueModList.stream().filter(mf -> mf.getModFileInfo() != null).map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.groupingBy(IModInfo::getModId));
        Map versionedLibIds = uniqueLibListWithVersion.stream().map(UniqueModListBuilder::getModId).collect(Collectors.toMap(Function.identity(), libFilesWithVersionByModuleName::get));
        List<IModInfo> dupedMods = modIds.values().stream().filter(modInfos -> modInfos.size() > 1).map(modInfos -> (IModInfo)modInfos.get(0)).toList();
        if (!dupedMods.isEmpty()) {
            List<EarlyLoadingException.ExceptionData> duplicateModErrors = dupedMods.stream().map(dm -> new EarlyLoadingException.ExceptionData("fml.modloading.dupedmod", (IModInfo)dm, new Object[]{Objects.toString(dm)})).toList();
            throw new EarlyLoadingException("Duplicate mods found", null, duplicateModErrors);
        }
        List<ModFile> dupedLibs = versionedLibIds.values().stream().filter(modFiles -> modFiles.size() > 1).map(modFiles -> (ModFile)modFiles.get(0)).toList();
        if (!dupedLibs.isEmpty()) {
            List<EarlyLoadingException.ExceptionData> duplicateLibErrors = dupedLibs.stream().map(dm -> new EarlyLoadingException.ExceptionData("fml.modloading.dupedlib.versioned", dm, Objects.toString(dm))).toList();
            throw new EarlyLoadingException("Duplicate plugins or libraries found", null, duplicateLibErrors);
        }
        Map<String, List<ModFile>> uniqueModFilesByFirstId = uniqueModList.stream().collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        ArrayList<ModFile> loadedList = new ArrayList<ModFile>();
        loadedList.addAll(uniqueModList);
        loadedList.addAll(uniqueLibListWithVersion);
        return new UniqueModListData(loadedList, uniqueModFilesByFirstId);
    }

    private ModFile selectNewestModInfo(Map.Entry<String, List<ModFile>> fullList) {
        List<ModFile> modInfoList = fullList.getValue();
        if (modInfoList.size() > 1) {
            LOGGER.debug("Found {} mods for first modid {}, selecting most recent based on version data", (Object)modInfoList.size(), (Object)fullList.getKey());
            modInfoList.sort(Comparator.comparing(this::getVersion).reversed());
            LOGGER.debug("Selected file {} for modid {} with version {}", new Object[]{modInfoList.get(0).getFileName(), fullList.getKey(), modInfoList.get(0).getModInfos().get(0).getVersion()});
        }
        return modInfoList.get(0);
    }

    private ArtifactVersion getVersion(ModFile mf) {
        if (mf.getModFileInfo() == null) {
            return mf.getJarVersion();
        }
        return mf.getModInfos().get(0).getVersion();
    }

    private static String getModId(ModFile modFile) {
        if (modFile.getModFileInfo() == null || modFile.getModFileInfo().getMods().isEmpty()) {
            return modFile.getSecureJar().name();
        }
        return modFile.getModFileInfo().moduleName();
    }

    public record UniqueModListData(List<ModFile> modFiles, Map<String, List<ModFile>> modFilesByFirstId) {
    }
}

