/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileDependencyLocator;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.jarjar.selection.JarSelector;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class JarInJarDependencyLocator
extends AbstractJarFileDependencyLocator {
    private static final Logger LOGGER = LogUtils.getLogger();

    public String name() {
        return "JarInJar";
    }

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        ArrayList sources = Lists.newArrayList();
        loadedMods.forEach(sources::add);
        List dependenciesToLoad = JarSelector.detectAndSelect((List)sources, this::loadResourceFromModFile, this::loadModFileFrom, this::identifyMod, this::exception);
        if (dependenciesToLoad.isEmpty()) {
            LOGGER.info("No dependencies to load found. Skipping!");
            return Collections.emptyList();
        }
        LOGGER.info("Found {} dependencies adding them to mods collection", (Object)dependenciesToLoad.size());
        return dependenciesToLoad;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    @Override
    protected String getDefaultJarModType() {
        return IModFile.Type.GAMELIBRARY.name();
    }

    protected EarlyLoadingException exception(Collection<JarSelector.ResolutionFailureInformation<IModFile>> failedDependencies) {
        List<EarlyLoadingException.ExceptionData> errors = failedDependencies.stream().filter(entry -> !entry.sources().isEmpty()).map(entry -> new EarlyLoadingException.ExceptionData(this.getErrorTranslationKey((JarSelector.ResolutionFailureInformation<IModFile>)entry), entry.identifier().group() + ":" + entry.identifier().artifact(), entry.sources().stream().flatMap(this::getModWithVersionRangeStream).map(this::formatError).collect(Collectors.joining(", ")))).toList();
        return new EarlyLoadingException(failedDependencies.size() + " Dependency restrictions were not met.", null, errors);
    }

    @NotNull
    private String getErrorTranslationKey(JarSelector.ResolutionFailureInformation<IModFile> entry) {
        return entry.failureReason() == JarSelector.FailureReason.VERSION_RESOLUTION_FAILED ? "fml.dependencyloading.conflictingdependencies" : "fml.dependencyloading.mismatchedcontaineddependencies";
    }

    @NotNull
    private Stream<ModWithVersionRange> getModWithVersionRangeStream(JarSelector.SourceWithRequestedVersionRange<IModFile> file) {
        return ((IModFile)file.source()).getModFileInfo().getMods().stream().map(modInfo -> new ModWithVersionRange((IModInfo)modInfo, file.requestedVersionRange(), file.includedVersion()));
    }

    @NotNull
    private String formatError(ModWithVersionRange modWithVersionRange) {
        return "\u00a7e" + modWithVersionRange.modInfo().getModId() + "\u00a7r - \u00a74" + modWithVersionRange.versionRange().toString() + "\u00a74 - \u00a72" + modWithVersionRange.artifactVersion().toString() + "\u00a72";
    }

    private record ModWithVersionRange(IModInfo modInfo, VersionRange versionRange, ArtifactVersion artifactVersion) {
    }
}

