/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModValidator;
import net.minecraftforge.fml.loading.moddiscovery.ModsFolderLocator;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.slf4j.Logger;

public class ModDiscoverer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServiceLoader<IModLocator> locators;
    private final List<IModLocator> locatorList;

    public ModDiscoverer(Map<String, ?> arguments) {
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODDIRECTORYFACTORY.get(), v -> ModsFolderLocator::new);
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.PROGRESSMESSAGE.get(), v -> StartupMessageManager.locatorConsumer().orElseGet(() -> s -> {}));
        IModuleLayerManager moduleLayerManager = (IModuleLayerManager)Launcher.INSTANCE.environment().findModuleLayerManager().orElseThrow();
        this.locators = ServiceLoader.load((ModuleLayer)moduleLayerManager.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow(), IModLocator.class);
        this.locatorList = ServiceLoaderUtils.streamServiceLoader(() -> this.locators, sce -> LOGGER.error("Failed to load locator list", (Throwable)sce)).collect(Collectors.toList());
        this.locatorList.forEach(l -> l.initArguments(arguments));
        if (LOGGER.isDebugEnabled(LogMarkers.CORE)) {
            LOGGER.debug(LogMarkers.CORE, "Found Mod Locators : {}", (Object)this.locatorList.stream().map(iModLocator -> "(" + iModLocator.name() + ":" + iModLocator.getClass().getPackage().getImplementationVersion() + ")").collect(Collectors.joining(",")));
        }
    }

    ModDiscoverer(List<IModLocator> locatorList) {
        this.locatorList = locatorList;
        this.locators = null;
    }

    public ModValidator discoverMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning for mods and other resources to load. We know {} ways to find mods", (Object)this.locatorList.size());
        ArrayList loadedFiles = new ArrayList();
        for (IModLocator locator : this.locatorList) {
            LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", (Object)locator);
            List modFiles = locator.scanMods();
            for (IModFile mf : modFiles) {
                LOGGER.info(LogMarkers.SCAN, "Found mod file {} of type {} with locator {}", new Object[]{mf.getFileName(), mf.getType(), mf.getLocator()});
                StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Found mod file " + mf.getFileName() + " of type " + mf.getType()));
            }
            loadedFiles.addAll(modFiles);
        }
        Map<IModFile.Type, List<ModFile>> modFilesMap = loadedFiles.stream().map(ModFile.class::cast).collect(Collectors.groupingBy(IModFile::getType));
        ModValidator validator = new ModValidator(modFilesMap);
        validator.stage1Validation();
        return validator;
    }
}

