/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.AdvancedLogMessageAdapter;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.VersionSupportMatrix;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.toposort.CyclePresentException;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModSorter {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ModFile> modFiles;
    private List<ModInfo> sortedList;
    private Map<String, ModInfo> modIdNameLookup;
    private List<ModFile> forgeAndMC;

    private ModSorter(List<ModFile> modFiles) {
        this.modFiles = modFiles;
    }

    public static LoadingModList sort(List<ModFile> mods, List<EarlyLoadingException.ExceptionData> errors) {
        ModSorter ms = new ModSorter(mods);
        try {
            ms.buildUniqueList();
        }
        catch (EarlyLoadingException e) {
            return LoadingModList.of(ms.forgeAndMC, ms.forgeAndMC.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).collect(Collectors.toList()), e);
        }
        List<EarlyLoadingException.ExceptionData> failedList = Stream.concat(ms.verifyDependencyVersions().stream(), errors.stream()).toList();
        if (!failedList.isEmpty()) {
            return LoadingModList.of(ms.forgeAndMC, ms.forgeAndMC.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).collect(Collectors.toList()), new EarlyLoadingException("failure to validate mod list", null, failedList));
        }
        EarlyLoadingException earlyLoadingException = null;
        try {
            ms.sort();
        }
        catch (EarlyLoadingException e) {
            earlyLoadingException = e;
        }
        return LoadingModList.of(ms.modFiles, ms.sortedList, earlyLoadingException);
    }

    private void sort() {
        List<ModFileInfo> sorted;
        MutableGraph graph = GraphBuilder.directed().build();
        AtomicInteger counter = new AtomicInteger();
        Map infos = this.modFiles.stream().map(ModFile::getModFileInfo).filter(ModFileInfo.class::isInstance).collect(Collectors.toMap(Function.identity(), e -> counter.incrementAndGet()));
        infos.keySet().forEach(i -> graph.addNode((Object)((ModFileInfo)i)));
        this.modFiles.stream().map(ModFile::getModInfos).mapMulti(Iterable::forEach).map(IModInfo::getDependencies).mapMulti(Iterable::forEach).forEach(dep -> this.addDependency((MutableGraph<ModFileInfo>)graph, (IModInfo.ModVersion)dep));
        try {
            sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(infos::get));
        }
        catch (CyclePresentException e2) {
            Set cycles = e2.getCycles();
            LOGGER.error(LogMarkers.LOADING, () -> new AdvancedLogMessageAdapter(buffer -> buffer.append("Mod Sorting failed.\n").append("Detected Cycles: ").append(cycles).append('\n')));
            List<EarlyLoadingException.ExceptionData> dataList = cycles.stream().mapMulti(Iterable::forEach).mapMulti((mf, c) -> mf.getMods().forEach(c)).map(IModInfo::getModId).map(list -> new EarlyLoadingException.ExceptionData("fml.modloading.cycle", list)).toList();
            throw new EarlyLoadingException("Sorting error", e2, dataList);
        }
        this.sortedList = sorted.stream().map(ModFileInfo::getMods).mapMulti(Iterable::forEach).map(ModInfo.class::cast).collect(Collectors.toList());
        this.modFiles = sorted.stream().map(ModFileInfo::getFile).collect(Collectors.toList());
    }

    private void addDependency(MutableGraph<ModFileInfo> topoGraph, IModInfo.ModVersion dep) {
        ModFileInfo self = (ModFileInfo)dep.getOwner().getOwningFile();
        ModInfo targetModInfo = this.modIdNameLookup.get(dep.getModId());
        if (targetModInfo == null) {
            return;
        }
        ModFileInfo target = targetModInfo.getOwningFile();
        if (self == target) {
            return;
        }
        switch (dep.getOrdering()) {
            case BEFORE: {
                topoGraph.putEdge((Object)self, (Object)target);
                break;
            }
            case AFTER: {
                topoGraph.putEdge((Object)target, (Object)self);
            }
        }
    }

    private void buildUniqueList() {
        Map<String, List<IModFile>> modFilesByFirstId = this.modFiles.stream().collect(Collectors.groupingBy(mf -> mf.getModFileInfo().moduleName()));
        this.forgeAndMC = new ArrayList<ModFile>();
        List<IModFile> mc = modFilesByFirstId.get("minecraft");
        if (mc == null || mc.isEmpty()) {
            throw new IllegalStateException("Failed to find minecraft somehow?");
        }
        this.forgeAndMC.add((ModFile)mc.get(0));
        List<IModFile> forge = modFilesByFirstId.get("forge");
        if (forge != null && !forge.isEmpty()) {
            this.forgeAndMC.add((ModFile)forge.get(0));
        }
        this.modFiles = modFilesByFirstId.entrySet().stream().map(this::selectNewestModInfo).map(Map.Entry::getValue).map(ModFile.class::cast).collect(Collectors.toList());
        Map<String, List<ModInfo>> modIds = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.groupingBy(IModInfo::getModId));
        List<ModInfo> dupedMods = modIds.values().stream().filter(modInfos -> modInfos.size() > 1).map(modInfos -> (ModInfo)modInfos.get(0)).toList();
        if (!dupedMods.isEmpty()) {
            List<EarlyLoadingException.ExceptionData> duplicateModErrors = dupedMods.stream().map(dm -> new EarlyLoadingException.ExceptionData("fml.modloading.dupedmod", (IModInfo)dm, new Object[]{Objects.toString(dm)})).toList();
            throw new EarlyLoadingException("Duplicate mods found", null, duplicateModErrors);
        }
        this.modIdNameLookup = modIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ModInfo)((List)e.getValue()).get(0)));
    }

    private Map.Entry<String, IModFile> selectNewestModInfo(Map.Entry<String, List<IModFile>> fullList) {
        List<IModFile> modInfoList = fullList.getValue();
        if (modInfoList.size() > 1) {
            LOGGER.debug("Found {} mods for first modid {}, selecting most recent based on version data", (Object)modInfoList.size(), (Object)fullList.getKey());
            modInfoList.sort(Comparator.comparing(mf -> ((IModInfo)mf.getModInfos().get(0)).getVersion()).reversed());
            LOGGER.debug("Selected file {} for modid {} with version {}", (Object)modInfoList.get(0).getFileName(), (Object)fullList.getKey(), (Object)((IModInfo)modInfoList.get(0).getModInfos().get(0)).getVersion());
        }
        return Map.entry(fullList.getKey(), modInfoList.get(0));
    }

    private List<EarlyLoadingException.ExceptionData> verifyDependencyVersions() {
        Map<String, ArtifactVersion> modVersions = this.modFiles.stream().map(ModFile::getModInfos).mapMulti(Iterable::forEach).collect(Collectors.toMap(IModInfo::getModId, IModInfo::getVersion));
        Map modVersionDependencies = this.modFiles.stream().map(ModFile::getModInfos).mapMulti(Iterable::forEach).collect(Collectors.groupingBy(Function.identity(), Collectors.flatMapping(e -> e.getDependencies().stream(), Collectors.toList())));
        Set modRequirements = modVersionDependencies.values().stream().mapMulti(Iterable::forEach).filter(mv -> mv.getSide().isCorrectSide()).collect(Collectors.toSet());
        long mandatoryRequired = modRequirements.stream().filter(IModInfo.ModVersion::isMandatory).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements ({} mandatory, {} optional)", (Object)modRequirements.size(), (Object)mandatoryRequired, (Object)((long)modRequirements.size() - mandatoryRequired));
        Set missingVersions = modRequirements.stream().filter(mv -> (mv.isMandatory() || modVersions.containsKey(mv.getModId())) && this.modVersionNotContained((IModInfo.ModVersion)mv, modVersions)).collect(Collectors.toSet());
        long mandatoryMissing = missingVersions.stream().filter(IModInfo.ModVersion::isMandatory).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements missing ({} mandatory, {} optional)", (Object)missingVersions.size(), (Object)mandatoryMissing, (Object)((long)missingVersions.size() - mandatoryMissing));
        if (!missingVersions.isEmpty()) {
            if (mandatoryMissing > 0L) {
                LOGGER.error(LogMarkers.LOADING, "Missing mandatory dependencies: {}", (Object)missingVersions.stream().filter(IModInfo.ModVersion::isMandatory).map(IModInfo.ModVersion::getModId).collect(Collectors.joining(", ")));
            }
            if ((long)missingVersions.size() - mandatoryMissing > 0L) {
                LOGGER.error(LogMarkers.LOADING, "Unsupported installed optional dependencies: {}", (Object)missingVersions.stream().filter(ver -> !ver.isMandatory()).map(IModInfo.ModVersion::getModId).collect(Collectors.joining(", ")));
            }
            return missingVersions.stream().map(mv -> new EarlyLoadingException.ExceptionData(mv.isMandatory() ? "fml.modloading.missingdependency" : "fml.modloading.missingdependency.optional", mv.getOwner(), new Object[]{mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), modVersions.getOrDefault(mv.getModId(), (ArtifactVersion)new DefaultArtifactVersion("null"))})).toList();
        }
        return Collections.emptyList();
    }

    private boolean modVersionNotContained(IModInfo.ModVersion mv, Map<String, ArtifactVersion> modVersions) {
        return !VersionSupportMatrix.testVersionSupportMatrix(mv.getVersionRange(), mv.getModId(), "mod", (modId, range) -> modVersions.containsKey(modId) && (range.containsVersion((ArtifactVersion)modVersions.get(modId)) || ((ArtifactVersion)modVersions.get(modId)).toString().equals("0.0NONE")));
    }
}

