/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractJarFileLocator
implements IModLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scan started: {}", (Object)file);
        Function<Path, SecureJar.Status> status = p -> file.getSecureJar().verifyPath(p);
        try (Stream<Path> files = Files.find(file.getSecureJar().getRootPath(), Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            file.setSecurityStatus(files.peek(pathConsumer).map(status).reduce((s1, s2) -> SecureJar.Status.values()[Math.min(s1.ordinal(), s2.ordinal())]).orElse(SecureJar.Status.INVALID));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug(LogMarkers.SCAN, "Scan finished: {}", (Object)file);
    }

    public List<IModFile> scanMods() {
        return this.scanCandidates().map(this::createMod).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public abstract Stream<Path> scanCandidates();

    public boolean isValid(IModFile modFile) {
        return true;
    }

    private Optional<IModFile> createMod(Path path) {
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = SecureJar.from(Manifest::new, jar -> jar.findFile(MODS_TOML).isPresent() ? mjm : JarMetadata.from((SecureJar)jar, (Path[])new Path[]{path}), (root, p) -> true, (Path[])new Path[]{path});
        ModFile mod = null;
        String type = sj.getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (sj.findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", (Object)MODS_TOML, (Object)type, (Object)path);
            mod = new ModFile(sj, this, ModFileParser::modsTomlParser);
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", (Object)MANIFEST, (Object)type, (Object)path);
            mod = new ModFile(sj, this, this::manifestParser);
        } else {
            return Optional.empty();
        }
        mjm.setModFile(mod);
        return Optional.ofNullable(mod);
    }

    private IModFileInfo manifestParser(final IModFile mod) {
        Function<String, Optional> cfg = name -> Optional.ofNullable(mod.getSecureJar().getManifest().getMainAttributes().getValue((String)name));
        final String license = cfg.apply("LICENSE").orElse("");
        IConfigurable dummy = new IConfigurable(){

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new IModFileInfo(){
            final /* synthetic */ 1 val$dummy;
            {
                this.val$dummy = var4_4;
            }

            public List<IModInfo> getMods() {
                return Collections.emptyList();
            }

            public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
                return Collections.emptyList();
            }

            public boolean showAsResourcePack() {
                return false;
            }

            public Map<String, Object> getFileProperties() {
                return Collections.emptyMap();
            }

            public String getLicense() {
                return license;
            }

            public IModFile getFile() {
                return mod;
            }

            public IConfigurable getConfig() {
                return this.val$dummy;
            }

            public String moduleName() {
                return mod.getSecureJar().name();
            }

            public String versionString() {
                return null;
            }

            public List<String> usesServices() {
                return null;
            }

            public String toString() {
                return "IModFileInfo(" + mod.getFilePath() + ")";
            }
        };
    }
}

