/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.MavenCoordinateResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibraryFinder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Path libsPath;

    static Path findLibsPath() {
        if (libsPath == null && !Files.isDirectory(libsPath = Path.of(System.getProperty("libraryDirectory", "crazysnowmannonsense/cheezwhizz"), new String[0]), new LinkOption[0])) {
            throw new IllegalStateException("Missing libraryDirectory system property, cannot continue");
        }
        return libsPath;
    }

    public static Path findJarPathFor(String className, String jarName) {
        URL resource = LibraryFinder.class.getClassLoader().getResource(className);
        return LibraryFinder.findJarPathFor(className, jarName, resource);
    }

    public static Path findJarPathFor(String resourceName, String jarName, URL resource) {
        try {
            Path path;
            URI uri = resource.toURI();
            if (uri.getScheme().equals("jar") && uri.getRawSchemeSpecificPart().contains("!/")) {
                int lastExcl = uri.getRawSchemeSpecificPart().lastIndexOf("!/");
                path = Paths.get(new URI(uri.getRawSchemeSpecificPart().substring(0, lastExcl)));
            } else {
                path = Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - resourceName.length())));
            }
            LOGGER.debug(LogMarkers.CORE, "Found JAR {} at path {}", (Object)jarName, (Object)path.toString());
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.fatal(LogMarkers.CORE, "Failed to find JAR for class {} - {}", (Object)resourceName, (Object)jarName);
            throw new RuntimeException("Unable to locate " + resourceName + " - " + jarName, e);
        }
    }

    static Path getForgeLibraryPath(String mcVersion, String forgeVersion, String forgeGroup) {
        Path forgePath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(forgeGroup, "forge", "", "universal", mcVersion + "-" + forgeVersion));
        LOGGER.debug(LogMarkers.CORE, "Found forge path {} is {}", (Object)forgePath, (Object)LibraryFinder.pathStatus(forgePath));
        return forgePath;
    }

    static String pathStatus(Path path) {
        return Files.exists(path, new LinkOption[0]) ? "present" : "missing";
    }

    static Path[] getMCPaths(String mcVersion, String mcpVersion, String forgeVersion, String forgeGroup, String type) {
        Path srgMcPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get("net.minecraft", type, "", "srg", mcVersion + "-" + mcpVersion));
        Path mcExtrasPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get("net.minecraft", type, "", "extra", mcVersion + "-" + mcpVersion));
        Path patchedBinariesPath = LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(forgeGroup, "forge", "", type, mcVersion + "-" + forgeVersion));
        LOGGER.debug(LogMarkers.CORE, "SRG MC at {} is {}", (Object)srgMcPath.toString(), (Object)LibraryFinder.pathStatus(srgMcPath));
        LOGGER.debug(LogMarkers.CORE, "MC Extras at {} is {}", (Object)mcExtrasPath.toString(), (Object)LibraryFinder.pathStatus(mcExtrasPath));
        LOGGER.debug(LogMarkers.CORE, "Forge patches at {} is {}", (Object)patchedBinariesPath.toString(), (Object)LibraryFinder.pathStatus(patchedBinariesPath));
        return new Path[]{patchedBinariesPath, mcExtrasPath, srgMcPath};
    }

    public static Path findPathForMaven(String group, String artifact, String extension, String classifier, String version) {
        return LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(group, artifact, extension, classifier, version));
    }

    public static Path findPathForMaven(String maven) {
        return LibraryFinder.findLibsPath().resolve(MavenCoordinateResolver.get(maven));
    }
}

