/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClasspathLocator
extends AbstractJarFileLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MODS_TOML = "META-INF/mods.toml";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private final List<String> ignoreList = Arrays.stream(System.getProperty("ignoreList", "").split(",")).toList();
    private boolean enabled = false;

    public String name() {
        return "userdev classpath";
    }

    @Override
    public List<IModFile> scanMods() {
        if (!this.enabled) {
            return List.of();
        }
        try {
            Stream.Builder<IModFile> modCoords = Stream.builder();
            this.locateMods(modCoords, MODS_TOML, "classpath_mod", sj -> true);
            this.locateMods(modCoords, MANIFEST, "manifest_jar", sj -> ClasspathLocator.isValidManifest(sj) && sj.getManifest().getMainAttributes().getValue(ModFile.TYPE) != null);
            return modCoords.build().toList();
        }
        catch (IOException e) {
            LOGGER.fatal(LogMarkers.CORE, "Error trying to find resources", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<Path> scanCandidates() {
        return Stream.of(new Path[0]);
    }

    private void locateMods(Stream.Builder<IModFile> modCoords, String resource, String name, Predicate<SecureJar> filter) throws IOException {
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(resource);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Path path = LibraryFinder.findJarPathFor(resource, name, url);
            if (this.ignoreList.stream().anyMatch(path.toString()::contains) || Files.isDirectory(path, new LinkOption[0])) continue;
            ModJarMetadata.buildFile((IModLocator)this, filter, path).ifPresent(mf -> {
                LOGGER.debug(LogMarkers.CORE, "Found classpath mod: {}", (Object)path);
                modCoords.add((IModFile)mf);
            });
        }
    }

    public void initArguments(Map<String, ?> arguments) {
        String launchTarget = (String)arguments.get("launchTarget");
        this.enabled = launchTarget != null && launchTarget.contains("dev");
    }

    private static boolean isValidManifest(SecureJar sj) {
        boolean bl;
        JarInputStream jis = new JarInputStream(Files.newInputStream(sj.getRootPath(), new OpenOption[0]));
        try {
            bl = jis.getManifest() != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jis.close();
        return bl;
    }
}

