/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.IModLoadingState;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingPhase;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.ModStateManager;
import net.minecraftforge.fml.ModWorkManager;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModIdentifier;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.locating.ForgeFeature;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ModLoader INSTANCE;
    private final LoadingModList loadingModList;
    private final List<ModLoadingException> loadingExceptions;
    private final List<ModLoadingWarning> loadingWarnings;
    private final ModStateManager stateManager;
    private boolean loadingStateValid;
    private final Optional<Consumer<String>> statusConsumer = StartupNotificationManager.modLoaderConsumer();
    private final Set<IModLoadingState> completedStates = new HashSet<IModLoadingState>();
    private ModList modList;
    private static boolean runningDataGen;

    private ModLoader() {
        INSTANCE = this;
        this.loadingModList = FMLLoader.getLoadingModList();
        this.loadingExceptions = FMLLoader.getLoadingModList().getErrors().stream().flatMap(ModLoadingException::fromEarlyException).collect(Collectors.toList());
        this.loadingWarnings = FMLLoader.getLoadingModList().getBrokenFiles().stream().map(file -> new ModLoadingWarning(null, ModLoadingStage.VALIDATE, InvalidModIdentifier.identifyJarProblem((Path)file.getFilePath()).orElse("fml.modloading.brokenfile"), file.getFileName())).collect(Collectors.toList());
        FMLLoader.getLoadingModList().getModFiles().stream().filter(ModFileInfo::missingLicense).filter(modFileInfo -> modFileInfo.getMods().stream().noneMatch(thisModInfo -> this.loadingExceptions.stream().map(ModLoadingException::getModInfo).anyMatch(otherInfo -> otherInfo == thisModInfo))).map(modFileInfo -> new ModLoadingException(null, ModLoadingStage.VALIDATE, "fml.modloading.missinglicense", null, modFileInfo.getFile())).forEach(this.loadingExceptions::add);
        this.stateManager = new ModStateManager();
        CrashReportCallables.registerCrashCallable("ModLauncher", FMLLoader::getLauncherInfo);
        CrashReportCallables.registerCrashCallable("ModLauncher launch target", FMLLoader::launcherHandlerName);
        CrashReportCallables.registerCrashCallable("ModLauncher naming", FMLLoader::getNaming);
        CrashReportCallables.registerCrashCallable("ModLauncher services", this::computeModLauncherServiceList);
        CrashReportCallables.registerCrashCallable("FML Language Providers", this::computeLanguageList);
    }

    private String computeLanguageList() {
        return "\n" + FMLLoader.getLanguageLoadingProvider().applyForEach(lp -> lp.name() + "@" + lp.getClass().getPackage().getImplementationVersion()).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    private String computeModLauncherServiceList() {
        List mods = FMLLoader.modLauncherModList();
        return "\n" + mods.stream().map(mod -> mod.getOrDefault("file", "nofile") + " " + mod.getOrDefault("name", "missing") + " " + mod.getOrDefault("type", "NOTYPE") + " " + mod.getOrDefault("description", "")).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    public static ModLoader get() {
        return INSTANCE == null ? (INSTANCE = new ModLoader()) : INSTANCE;
    }

    public void gatherAndInitializeMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        ForgeFeature.registerFeature((String)"java_version", (ForgeFeature.IFeatureTest)ForgeFeature.VersionFeatureTest.forVersionString((IModInfo.DependencySide)IModInfo.DependencySide.BOTH, (String)System.getProperty("java.version")));
        ForgeFeature.registerFeature((String)"openGLVersion", (ForgeFeature.IFeatureTest)ForgeFeature.VersionFeatureTest.forVersionString((IModInfo.DependencySide)IModInfo.DependencySide.CLIENT, (String)ImmediateWindowHandler.getGLVersion()));
        this.loadingStateValid = true;
        FMLLoader.backgroundScanHandler.waitForScanToComplete(periodicTask);
        ModList modList = ModList.of(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).toList(), this.loadingModList.getMods());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Error during pre-loading phase", (Throwable)this.loadingExceptions.get(0));
            this.statusConsumer.ifPresent(c -> c.accept("ERROR DURING MOD LOADING"));
            modList.setLoadedMods(Collections.emptyList());
            this.loadingStateValid = false;
            throw new LoadingFailedException(this.loadingExceptions);
        }
        List<ForgeFeature.Bound> failedBounds = this.loadingModList.getMods().stream().map(ModInfo::getForgeFeatures).flatMap(Collection::stream).filter(bound -> !ForgeFeature.testFeature((Dist)FMLEnvironment.dist, (ForgeFeature.Bound)bound)).toList();
        if (!failedBounds.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to validate feature bounds for mods");
            this.statusConsumer.ifPresent(c -> c.accept("ERROR DURING MOD LOADING"));
            modList.setLoadedMods(Collections.emptyList());
            this.loadingStateValid = false;
            throw new LoadingFailedException(failedBounds.stream().map(fb -> new ModLoadingException(fb.modInfo(), ModLoadingStage.CONSTRUCT, "fml.modloading.feature.missing", null, fb.featureName(), fb.featureBound(), ForgeFeature.featureValue((ForgeFeature.Bound)fb))).toList());
        }
        List<ModContainer> modContainers = this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).map(this::buildMods).mapMulti(Iterable::forEach).toList();
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to initialize mod containers", (Throwable)this.loadingExceptions.get(0));
            this.statusConsumer.ifPresent(c -> c.accept("ERROR DURING MOD LOADING"));
            modList.setLoadedMods(Collections.emptyList());
            this.loadingStateValid = false;
            throw new LoadingFailedException(this.loadingExceptions);
        }
        modList.setLoadedMods(modContainers);
        this.modList = modList;
        List<IModLoadingState> stateList = this.stateManager.getStates(ModLoadingPhase.GATHER);
        ProgressMeter progress = StartupMessageManager.addProgressBar("Mod Gather", stateList.stream().mapToInt(mls -> mls.size().applyAsInt(modList)).sum());
        stateList.forEach(mls -> this.dispatchAndHandleError((IModLoadingState)mls, syncExecutor, parallelExecutor, periodicTask, progress));
        progress.complete();
    }

    public void loadMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        List<IModLoadingState> stateList = this.stateManager.getStates(ModLoadingPhase.LOAD);
        ProgressMeter progress = StartupMessageManager.addProgressBar("Mod Loading", stateList.stream().mapToInt(mls -> mls.size().applyAsInt(this.modList)).sum());
        stateList.forEach(mls -> this.dispatchAndHandleError((IModLoadingState)mls, syncExecutor, parallelExecutor, periodicTask, progress));
        progress.complete();
    }

    public void finishMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        List<IModLoadingState> stateList = this.stateManager.getStates(ModLoadingPhase.COMPLETE);
        ProgressMeter progress = StartupMessageManager.addProgressBar("Mod Complete", stateList.stream().mapToInt(mls -> mls.size().applyAsInt(this.modList)).sum());
        stateList.forEach(mls -> this.dispatchAndHandleError((IModLoadingState)mls, syncExecutor, parallelExecutor, periodicTask, progress));
        this.statusConsumer.ifPresent(c -> c.accept(String.format("Mod loading complete - %d mods loaded", this.modList.size())));
        progress.complete();
    }

    private void dispatchAndHandleError(IModLoadingState state, ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable ticker, ProgressMeter progressBar) {
        if (!ModLoader.isLoadingStateValid()) {
            LOGGER.error("Cowardly refusing to process mod state change request from {}", (Object)state);
            return;
        }
        progressBar.label(progressBar.name() + " working");
        state.inlineRunnable().ifPresent(a -> a.accept(this.modList));
        state.buildTransition(syncExecutor, parallelExecutor, progressBar).ifPresent(t -> this.waitForTransition(state, syncExecutor, ticker, (CompletableFuture<Void>)t));
        this.completedStates.add(state);
    }

    private void waitForTransition(IModLoadingState state, ModWorkManager.DrivenExecutor syncExecutor, Runnable ticker, CompletableFuture<Void> transition) {
        while (!transition.isDone()) {
            syncExecutor.drive(ticker);
        }
        try {
            transition.join();
        }
        catch (CompletionException e) {
            this.loadingStateValid = false;
            Throwable t = e.getCause();
            List notModLoading = Arrays.stream(t.getSuppressed()).filter(obj -> !(obj instanceof ModLoadingException)).collect(Collectors.toList());
            if (!notModLoading.isEmpty()) {
                LOGGER.fatal("Encountered non-modloading exceptions!", (Throwable)e);
                this.statusConsumer.ifPresent(c -> c.accept("ERROR DURING MOD LOADING"));
                throw e;
            }
            List<ModLoadingException> modLoadingExceptions = Arrays.stream(t.getSuppressed()).filter(ModLoadingException.class::isInstance).map(ModLoadingException.class::cast).collect(Collectors.toList());
            LOGGER.fatal(Logging.LOADING, "Failed to complete lifecycle event {}, {} errors found", (Object)state.name(), (Object)modLoadingExceptions.size());
            this.statusConsumer.ifPresent(c -> c.accept("ERROR DURING MOD LOADING"));
            throw new LoadingFailedException(modLoadingExceptions);
        }
    }

    private List<ModContainer> buildMods(IModFile modFile) {
        Map modInfoMap = modFile.getModFileInfo().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, Function.identity()));
        LOGGER.trace(Logging.LOADING, "ModContainer is {}", (Object)ModContainer.class.getClassLoader());
        List containers = modFile.getScanResult().getTargets().entrySet().stream().map(e -> this.buildModContainerFromTOML(modFile, modInfoMap, (Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader>)e)).filter(Objects::nonNull).collect(Collectors.toList());
        if (containers.size() != modInfoMap.size()) {
            List modIds = modInfoMap.values().stream().map(IModInfo::getModId).sorted().collect(Collectors.toList());
            List containerIds = containers.stream().map(c -> c != null ? c.getModId() : "(null)").sorted().collect(Collectors.toList());
            LOGGER.fatal(Logging.LOADING, "File {} constructed {} mods: {}, but had {} mods specified: {}", (Object)modFile.getFilePath(), (Object)containers.size(), containerIds, (Object)modInfoMap.size(), modIds);
            ArrayList missingClasses = new ArrayList(modIds);
            missingClasses.removeAll(containerIds);
            LOGGER.fatal(Logging.LOADING, "The following classes are missing, but are reported in the mods.toml: {}", missingClasses);
            ArrayList missingMods = new ArrayList(containerIds);
            missingMods.removeAll(modIds);
            LOGGER.fatal(Logging.LOADING, "The following mods are missing, but have classes in the jar: {}", missingMods);
            this.loadingExceptions.add(new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingclasses", null, modFile.getFilePath()));
        }
        return containers.stream().filter(mc -> mc.modLoadingStage != ModLoadingStage.ERROR).collect(Collectors.toList());
    }

    private ModContainer buildModContainerFromTOML(IModFile modFile, Map<String, IModInfo> modInfoMap, Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader> idToProviderEntry) {
        try {
            String modId = idToProviderEntry.getKey();
            IModLanguageProvider.IModLanguageLoader languageLoader = idToProviderEntry.getValue();
            IModInfo info = Optional.ofNullable(modInfoMap.get(modId)).orElseThrow(() -> new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingmetadata", null, modId));
            return (ModContainer)languageLoader.loadMod(info, modFile.getScanResult(), FMLLoader.getGameLayer());
        }
        catch (ModLoadingException mle) {
            this.loadingExceptions.add(mle);
            return new ErroredModContainer();
        }
    }

    public static boolean isLoadingStateValid() {
        return ModLoader.get().loadingStateValid;
    }

    public boolean hasCompletedState(String stateName) {
        IModLoadingState state = this.stateManager.findState(stateName);
        return this.completedStates.contains(state);
    }

    public <T extends Event> void runEventGenerator(Function<ModContainer, T> generator) {
        if (!this.loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event generator to a broken mod state");
            return;
        }
        ModList.get().forEachModInOrder(mc -> mc.acceptEvent((Event)generator.apply((ModContainer)mc)));
    }

    public <T extends Event> void postEvent(T e) {
        if (!this.loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        ModList.get().forEachModInOrder(mc -> mc.acceptEvent(e));
    }

    public <T extends Event> T postEventWithReturn(T e) {
        if (!this.loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return e;
        }
        ModList.get().forEachModInOrder(mc -> mc.acceptEvent(e));
        return e;
    }

    public <T extends Event> void postEventWrapContainerInModOrder(T event) {
        this.postEventWithWrapInModOrder(event, (mc, e) -> ModLoadingContext.get().setActiveContainer((ModContainer)mc), (mc, e) -> ModLoadingContext.get().setActiveContainer(null));
    }

    public <T extends Event> void postEventWithWrapInModOrder(T e, BiConsumer<ModContainer, T> pre, BiConsumer<ModContainer, T> post) {
        if (!this.loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        ModList.get().forEachModInOrder(mc -> {
            pre.accept((ModContainer)mc, e);
            mc.acceptEvent(e);
            post.accept((ModContainer)mc, e);
        });
    }

    public List<ModLoadingWarning> getWarnings() {
        return ImmutableList.copyOf(this.loadingWarnings);
    }

    public void addWarning(ModLoadingWarning warning) {
        this.loadingWarnings.add(warning);
    }

    public static boolean isDataGenRunning() {
        return runningDataGen;
    }

    static {
        runningDataGen = false;
    }

    private static class ErroredModContainer
    extends ModContainer {
        @Override
        public boolean matches(Object mod) {
            return false;
        }

        @Override
        public Object getMod() {
            return null;
        }
    }
}

