/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.NoopTransition;
import net.minecraftforge.fml.ThreadSelector;

public interface IModStateTransition {
    public static IModStateTransition buildNoopTransition() {
        return new NoopTransition();
    }

    default public <T extends Event> CompletableFuture<List<Throwable>> build(Executor syncExecutor, Executor parallelExecutor, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        ArrayList cfs = new ArrayList();
        this.eventFunctionStream().get().map(f -> f).reduce((head, tail) -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, cfs, (EventGenerator)head, ModLoadingStage::currentState, (EventGenerator)tail)).ifPresent(last -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, cfs, (EventGenerator)last, this.nextModLoadingStage(), null));
        CompletableFuture<Void> preSyncTaskCF = preSyncTask.apply(syncExecutor);
        CompletionStage eventDispatchCF = ModList.gather(cfs).thenCompose(ModList::completableFutureFromExceptionList);
        CompletionStage postEventDispatchCF = ((CompletableFuture)preSyncTaskCF.thenComposeAsync(arg_0 -> IModStateTransition.lambda$build$3((CompletableFuture)eventDispatchCF, arg_0), parallelExecutor)).thenApply(r -> {
            postSyncTask.apply(syncExecutor);
            return r;
        });
        return this.finalActivityGenerator().apply(syncExecutor, (CompletableFuture<List<Throwable>>)postEventDispatchCF);
    }

    default public BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextModLoadingStage() {
        return ModLoadingStage::nextState;
    }

    private <T extends Event> EventGenerator<T> addCompletableFutureTaskForModDispatch(Executor syncExecutor, Executor parallelExecutor, List<CompletableFuture<List<Throwable>>> completeableFutures, EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextState, EventGenerator<T> nextGenerator) {
        completeableFutures.add(this.preDispatchHook().apply(this.threadSelector().apply(syncExecutor, parallelExecutor), eventGenerator));
        completeableFutures.add(ModList.get().futureVisitor(eventGenerator, nextState).apply(this.threadSelector().apply(syncExecutor, parallelExecutor)));
        completeableFutures.add(this.postDispatchHook().apply(this.threadSelector().apply(syncExecutor, parallelExecutor), eventGenerator));
        return nextGenerator;
    }

    public Supplier<Stream<EventGenerator<?>>> eventFunctionStream();

    public ThreadSelector threadSelector();

    public BiFunction<Executor, CompletableFuture<List<Throwable>>, CompletableFuture<List<Throwable>>> finalActivityGenerator();

    public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<List<Throwable>>> preDispatchHook();

    public BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<List<Throwable>>> postDispatchHook();

    private static /* synthetic */ CompletionStage lambda$build$3(CompletableFuture eventDispatchCF, Void n) {
        return eventDispatchCF;
    }

    public static interface EventGenerator<T extends Event>
    extends Function<ModContainer, T> {
        public static <FN extends Event> EventGenerator<FN> fromFunction(Function<ModContainer, FN> fn) {
            return fn::apply;
        }
    }
}

