/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class ModContainer {
    protected final String modId;
    protected final String namespace;
    protected final IModInfo modInfo;
    protected ModLoadingStage modLoadingStage;
    protected Supplier<?> contextExtension;
    protected final Map<ModLoadingStage, Runnable> activityMap = new HashMap<ModLoadingStage, Runnable>();
    protected final Map<Class<? extends IExtensionPoint<?>>, Supplier<?>> extensionPoints = new IdentityHashMap();
    protected final EnumMap<ModConfig.Type, ModConfig> configs = new EnumMap(ModConfig.Type.class);
    protected Optional<Consumer<IConfigEvent>> configHandler = Optional.empty();

    public ModContainer(IModInfo info) {
        this.namespace = this.modId = info.getModId();
        this.modInfo = info;
        this.modLoadingStage = ModLoadingStage.CONSTRUCT;
        this.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> this.modInfo.getVersion().toString(), (incoming, isNetwork) -> Objects.equals(incoming, this.modInfo.getVersion().toString())));
    }

    ModContainer() {
        this.modLoadingStage = ModLoadingStage.ERROR;
        this.modId = "BROKEN";
        this.namespace = "BROKEN";
        this.modInfo = null;
    }

    public final String getModId() {
        return this.modId;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public ModLoadingStage getCurrentState() {
        return this.modLoadingStage;
    }

    public static <T extends Event> CompletableFuture<Void> buildTransitionHandler(ModContainer target, IModStateTransition.EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> stateChangeHandler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ModLoadingContext.get().setActiveContainer(target);
            target.activityMap.getOrDefault((Object)target.modLoadingStage, () -> {}).run();
            target.acceptEvent((Event)eventGenerator.apply(target));
        }, executor).whenComplete((mc, exception) -> {
            target.modLoadingStage = (ModLoadingStage)((Object)((Object)stateChangeHandler.apply(target.modLoadingStage, (Throwable)exception)));
            ModLoadingContext.get().setActiveContainer(null);
        });
    }

    public IModInfo getModInfo() {
        return this.modInfo;
    }

    public <T extends Record> Optional<T> getCustomExtension(Class<? extends IExtensionPoint<T>> point) {
        return Optional.ofNullable((Record)this.extensionPoints.getOrDefault(point, () -> null).get());
    }

    public <T extends Record> void registerExtensionPoint(Class<? extends IExtensionPoint<T>> point, Supplier<T> extension) {
        this.extensionPoints.put(point, extension);
    }

    public void addConfig(ModConfig modConfig) {
        this.configs.put(modConfig.getType(), modConfig);
    }

    public void dispatchConfigEvent(IConfigEvent event) {
        this.configHandler.ifPresent(configHandler -> configHandler.accept(event));
    }

    public abstract boolean matches(Object var1);

    public abstract Object getMod();

    protected <T extends Event> void acceptEvent(T e) {
    }
}

