/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.functions.GenericIterableFactory;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IncompatibleSubstitutionException;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.Validate;

public class FMLControlledNamespacedRegistry<I>
extends eh {
    private final Class<I> superType;
    private Object optionalDefaultKey;
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private BiMap<String, I> persistentSubstitutions;
    private BiMap<String, I> activeSubstitutions = HashBiMap.create();

    FMLControlledNamespacedRegistry(Object defaultKey, int maxIdValue, int minIdValue, Class<I> type) {
        super(defaultKey);
        this.superType = type;
        this.optionalDefaultKey = defaultKey;
        this.maxId = maxIdValue;
        this.minId = minIdValue;
    }

    void validateContent(int maxId, String type, BitSet availabilityMap, Set<Integer> blockedIds, FMLControlledNamespacedRegistry<atr> iBlockRegistry) {
        for (I obj : this.typeSafeIterable()) {
            String nameS;
            oa loc;
            int id2 = this.getId(obj);
            Object name = this.c(obj);
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", type, obj, id2));
            }
            oa oa2 = loc = name instanceof oa ? (oa)name : null;
            String string = name instanceof String ? (String)name : (nameS = loc != null ? name.toString() : null);
            if (loc == null && nameS == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s name is invalid, must be a String or ResourceLocation %s", type, obj, name));
            }
            if (id2 < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", type, obj, name));
            }
            if (id2 > maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", type, obj, name));
            }
            if (name.toString().isEmpty()) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, yields an empty name.", type, obj, id2));
            }
            if (name.toString().indexOf(58) == -1) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, has the non-prefixed name %s.", type, obj, id2, name));
            }
            if (this.getRaw(id2) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id2, name, type, obj));
            }
            if (!this.activeSubstitutions.containsKey(name) && !this.activeSubstitutions.containsValue(name) && this.getRaw(nameS) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id2, type, obj));
            }
            if (!this.activeSubstitutions.containsKey(name) && !this.activeSubstitutions.containsValue(name) && this.getId(nameS) != id2) {
                throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id2));
            }
            if (!availabilityMap.get(id2)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as empty.", type, obj, id2, name));
            }
            if (blockedIds.contains(id2)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as dangling.", type, obj, id2, name));
            }
            if (!(obj instanceof aju) || obj instanceof ajs) continue;
            atr block = ((aju)obj).a;
            if (iBlockRegistry.getId(block) != id2) {
                throw new IllegalStateException(String.format("Registry entry for ItemBlock %s, id %d, is missing or uses the non-matching id %d.", obj, id2, iBlockRegistry.getId(block)));
            }
            if (id2 <= 4095) continue;
            throw new IllegalStateException(String.format("ItemBlock %s uses the id %d outside the block id range", name, id2));
        }
    }

    void setFrom(FMLControlledNamespacedRegistry<?> registry) {
        this.set(registry);
    }

    void set(FMLControlledNamespacedRegistry<I> registry) {
        if (this.superType != registry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        this.optionalDefaultKey = registry.optionalDefaultKey;
        this.maxId = registry.maxId;
        this.minId = registry.minId;
        this.aliases.clear();
        this.aliases.putAll(registry.aliases);
        this.a = new er();
        this.c.clear();
        for (I thing : registry.typeSafeIterable()) {
            this.addObjectRaw(registry.getId(thing), registry.c(thing), thing);
        }
    }

    @Deprecated
    public void a(int id2, Object name, Object thing) {
        Validate.isInstanceOf(oa.class, (Object)name);
        GameData.getMain().register(thing, name.toString(), id2);
    }

    @Deprecated
    public void a(Object objName, Object obj) {
        String name = objName.toString();
        I thing = this.superType.cast(obj);
        if (name == null) {
            throw new NullPointerException("Can't use a null-name for the registry.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Can't use an empty name for the registry.");
        }
        if (thing == null) {
            throw new NullPointerException("Can't add null-object to the registry.");
        }
        name = new oa(name).toString();
        Object existingName = this.c(thing);
        if (existingName == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", name, thing);
        } else if (existingName.equals(name)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", name, thing);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", name, thing, existingName);
            this.addAlias(name, existingName.toString());
        }
    }

    public I a(Object name) {
        I object = null;
        if (name instanceof oa) {
            object = this.getRaw((oa)name);
        }
        if (name instanceof String) {
            object = this.getRaw((String)name);
        }
        return object == null ? (I)this.optionalDefaultObject : object;
    }

    public I a(int id2) {
        I object = this.getRaw(id2);
        return object == null ? this.optionalDefaultObject : object;
    }

    @Deprecated
    public I get(int id2) {
        return this.a(id2);
    }

    @Deprecated
    public I get(String name) {
        return this.a(name);
    }

    public int getId(I thing) {
        return this.b(thing);
    }

    public I getRaw(int id2) {
        return this.superType.cast(super.a(id2));
    }

    public I getRaw(String name) {
        return this.getRaw(new oa(name));
    }

    private I getRaw(oa loc) {
        String name;
        I ret = this.superType.cast(super.a((Object)loc));
        if (ret == null && (name = this.aliases.get(loc.toString())) != null) {
            return this.getRaw(name);
        }
        return ret;
    }

    public boolean d(Object name) {
        boolean ret = super.d(name);
        if (!ret && (name = this.aliases.get(name)) != null) {
            return this.d(name);
        }
        return ret;
    }

    public int getId(String itemName) {
        I obj = this.getRaw(itemName);
        if (obj == null) {
            return -1;
        }
        return this.getId(obj);
    }

    @Deprecated
    public boolean contains(String itemName) {
        return this.d(itemName);
    }

    public Iterable<I> typeSafeIterable() {
        FMLControlledNamespacedRegistry self = this;
        return GenericIterableFactory.newCastingIterable(self, this.superType);
    }

    public void serializeInto(Map<String, Integer> idMapping) {
        for (I thing : this.typeSafeIterable()) {
            idMapping.put(this.c(thing).toString(), this.getId(thing));
        }
    }

    public void serializeAliases(Map<String, String> map) {
        map.putAll(this.aliases);
    }

    public void serializeSubstitutions(Set<String> set) {
        set.addAll(this.activeSubstitutions.keySet());
    }

    int add(int id2, String name, I thing, BitSet availabilityMap) {
        if (name == null) {
            throw new NullPointerException(String.format("Can't use a null-name for the registry, object %s.", thing));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't use an empty name for the registry, object %s.", thing));
        }
        if (name.indexOf(58) == -1) {
            throw new IllegalArgumentException(String.format("Can't add the name (%s) without a prefix, object %s", name, thing));
        }
        if (thing == null) {
            throw new NullPointerException(String.format("Can't add null-object to the registry, name %s.", name));
        }
        if (this.optionalDefaultKey != null && this.optionalDefaultKey.toString().equals(name) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if (this.getPersistentSubstitutions().containsValue(thing)) {
            throw new IllegalArgumentException(String.format("The object %s (%s) cannot be added to the registry. It is already being used as a substitute for %s", thing.getClass(), name, this.getPersistentSubstitutions().inverse().get(thing)));
        }
        int idToUse = id2;
        if (idToUse < 0 || availabilityMap.get(idToUse)) {
            idToUse = availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int foundId = this.getId(thing);
            I otherThing = this.getRaw(foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.c(thing), name, otherThing, System.identityHashCode(otherThing)));
        }
        if (GameData.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        if (this.activeSubstitutions.containsKey((Object)name)) {
            thing = this.activeSubstitutions.get((Object)name);
        }
        this.addObjectRaw(idToUse, new oa(name), thing);
        FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, idToUse, thing, id2);
        return idToUse;
    }

    void addAlias(String from, String to) {
        this.aliases.put(from, to);
        FMLLog.finer("Registry alias: %s -> %s", from, to);
    }

    Map<String, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (I thing : this.typeSafeIterable()) {
            if (registry.b.containsKey(thing) || registry.activeSubstitutions.containsKey((Object)this.c(thing).toString())) continue;
            ret.put(this.c(thing).toString(), this.getId(thing));
        }
        return ret;
    }

    void dump() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (I thing : this.typeSafeIterable()) {
            ids.add(this.getId(thing));
        }
        Collections.sort(ids);
        Iterator<Object> i$ = ids.iterator();
        while (i$.hasNext()) {
            int id2 = (Integer)i$.next();
            I thing = this.getRaw(id2);
            FMLLog.finer("Registry: %s %d %s", this.c(thing), id2, thing);
        }
    }

    private void addObjectRaw(int id2, Object name, I thing) {
        if (name == null) {
            throw new NullPointerException("The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (thing == null) {
            throw new NullPointerException("The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (!this.superType.isInstance(thing)) {
            throw new IllegalArgumentException("The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        }
        this.a.a(thing, id2);
        super.a(name, thing);
    }

    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }

    public RegistryDelegate<I> getDelegate(I thing, Class<I> clazz) {
        return GameData.buildDelegate(thing, clazz);
    }

    void activateSubstitution(String nameToReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace)) {
            this.activeSubstitutions.put((Object)nameToReplace, this.getPersistentSubstitutions().get((Object)nameToReplace));
        }
    }

    void addSubstitutionAlias(String modId, String nameToReplace, Object toReplace) throws ExistingSubstitutionException {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace) || this.getPersistentSubstitutions().containsValue(toReplace)) {
            FMLLog.severe("The substitution of %s has already occured. You cannot duplicate substitutions", nameToReplace);
            throw new ExistingSubstitutionException(nameToReplace, toReplace);
        }
        I replacement = this.superType.cast(toReplace);
        I original = this.getRaw(nameToReplace);
        if (original == null) {
            throw new NullPointerException("The replacement target is not present. This won't work");
        }
        if (!original.getClass().isAssignableFrom(replacement.getClass())) {
            FMLLog.severe("The substitute %s for %s (type %s) is type incompatible. This won't work", replacement.getClass().getName(), nameToReplace, original.getClass().getName());
            throw new IncompatibleSubstitutionException(nameToReplace, replacement, original);
        }
        int existingId = this.getId(replacement);
        if (existingId != -1) {
            FMLLog.severe("The substitute %s for %s is registered into the game independently. This won't work", replacement.getClass().getName(), nameToReplace);
            throw new IllegalArgumentException("The object substitution is already registered. This won't work");
        }
        this.getPersistentSubstitutions().put((Object)nameToReplace, replacement);
    }

    private BiMap<String, I> getPersistentSubstitutions() {
        if (this.persistentSubstitutions == null) {
            this.persistentSubstitutions = GameData.getMain().getPersistentSubstitutionMap(this.superType);
        }
        return this.persistentSubstitutions;
    }

    public void a() {
        if (this.optionalDefaultKey != null) {
            Validate.notNull(this.optionalDefaultObject);
        }
    }

    FMLControlledNamespacedRegistry<I> makeShallowCopy() {
        return new FMLControlledNamespacedRegistry<I>(this.optionalDefaultKey, this.maxId, this.minId, this.superType);
    }
}

