/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiScrollingList {
    private final bsu client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    protected final int slotHeight;
    private int scrollUpActionId;
    private int scrollDownActionId;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    private float scrollDistance;
    protected int selectedIndex = -1;
    private long lastClickTime = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;

    public GuiScrollingList(bsu client, int width, int height, int top, int bottom, int left, int entryHeight) {
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + this.left;
    }

    public void func_27258_a(boolean p_27258_1_) {
        this.field_25123_p = p_27258_1_;
    }

    protected void func_27259_a(boolean p_27259_1_, int p_27259_2_) {
        this.field_27262_q = p_27259_1_;
        this.field_27261_r = p_27259_2_;
        if (!p_27259_1_) {
            this.field_27261_r = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.field_27261_r;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, ckx var5);

    protected void func_27260_a(int p_27260_1_, int p_27260_2_, ckx p_27260_3_) {
    }

    protected void func_27255_a(int p_27255_1_, int p_27255_2_) {
    }

    protected void func_27257_b(int p_27257_1_, int p_27257_2_) {
    }

    public int func_27256_c(int p_27256_1_, int p_27256_2_) {
        int var3 = this.left + 1;
        int var4 = this.left + this.listWidth - 7;
        int var5 = p_27256_2_ - this.top - this.field_27261_r + (int)this.scrollDistance - 4;
        int var6 = var5 / this.slotHeight;
        return p_27256_1_ >= var3 && p_27256_1_ <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
    }

    public void registerScrollButtons(List p_22240_1_, int p_22240_2_, int p_22240_3_) {
        this.scrollUpActionId = p_22240_2_;
        this.scrollDownActionId = p_22240_3_;
    }

    private void applyScrollLimits() {
        int var1 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var1 < 0) {
            var1 /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)var1) {
            this.scrollDistance = var1;
        }
    }

    public void actionPerformed(bug button) {
        if (button.l) {
            if (button.k == this.scrollUpActionId) {
                this.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.k == this.scrollDownActionId) {
                this.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float p_22243_3_) {
        int var13;
        int var19;
        int var11;
        int var10;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        int listLength = this.getSize();
        int scrollBarXStart = this.left + this.listWidth - 6;
        int scrollBarXEnd = scrollBarXStart + 6;
        int boxLeft = this.left;
        int boxRight = scrollBarXStart - 1;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                boolean var7 = true;
                if (mouseY >= this.top && mouseY <= this.bottom) {
                    var10 = mouseY - this.top - this.field_27261_r + (int)this.scrollDistance - 4;
                    var11 = var10 / this.slotHeight;
                    if (mouseX >= boxLeft && mouseX <= boxRight && var11 >= 0 && var10 >= 0 && var11 < listLength) {
                        boolean var12 = var11 == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L;
                        this.elementClicked(var11, var12);
                        this.selectedIndex = var11;
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= boxLeft && mouseX <= boxRight && var10 < 0) {
                        this.func_27255_a(mouseX - boxLeft, mouseY - this.top + (int)this.scrollDistance - 4);
                        var7 = false;
                    }
                    if (mouseX >= scrollBarXStart && mouseX <= scrollBarXEnd) {
                        this.scrollFactor = -1.0f;
                        var19 = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (var19 < 1) {
                            var19 = 1;
                        }
                        if ((var13 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > this.bottom - this.top - 8) {
                            var13 = this.bottom - this.top - 8;
                        }
                        this.scrollFactor /= (float)(this.bottom - this.top - var13) / (float)var19;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = var7 ? (float)mouseY : -2.0f;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            while (Mouse.next()) {
                int var16 = Mouse.getEventDWheel();
                if (var16 == 0) continue;
                if (var16 > 0) {
                    var16 = -1;
                } else if (var16 < 0) {
                    var16 = 1;
                }
                this.scrollDistance += (float)(var16 * this.slotHeight / 2);
            }
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        ckx tess = ckx.a();
        civ worldr = tess.c();
        if (this.client.f != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            this.client.O.a(bub.b);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float var17 = 32.0f;
            worldr.b();
            worldr.c(0x202020);
            worldr.a((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / var17), (double)((float)(this.bottom + (int)this.scrollDistance) / var17));
            worldr.a((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / var17), (double)((float)(this.bottom + (int)this.scrollDistance) / var17));
            worldr.a((double)this.right, (double)this.top, 0.0, (double)((float)this.right / var17), (double)((float)(this.top + (int)this.scrollDistance) / var17));
            worldr.a((double)this.left, (double)this.top, 0.0, (double)((float)this.left / var17), (double)((float)(this.top + (int)this.scrollDistance) / var17));
            tess.b();
        }
        var10 = this.top + 4 - (int)this.scrollDistance;
        if (this.field_27262_q) {
            this.func_27260_a(boxRight, var10, tess);
        }
        for (var11 = 0; var11 < listLength; ++var11) {
            var19 = var10 + var11 * this.slotHeight + this.field_27261_r;
            var13 = this.slotHeight - 4;
            if (var19 > this.bottom || var19 + var13 < this.top) continue;
            if (this.field_25123_p && this.isSelected(var11)) {
                int var14 = boxLeft;
                int var15 = boxRight;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                worldr.b();
                worldr.c(0x808080);
                worldr.a((double)var14, (double)(var19 + var13 + 2), 0.0, 0.0, 1.0);
                worldr.a((double)var15, (double)(var19 + var13 + 2), 0.0, 1.0, 1.0);
                worldr.a((double)var15, (double)(var19 - 2), 0.0, 1.0, 0.0);
                worldr.a((double)var14, (double)(var19 - 2), 0.0, 0.0, 0.0);
                worldr.c(0);
                worldr.a((double)(var14 + 1), (double)(var19 + var13 + 1), 0.0, 0.0, 1.0);
                worldr.a((double)(var15 - 1), (double)(var19 + var13 + 1), 0.0, 1.0, 1.0);
                worldr.a((double)(var15 - 1), (double)(var19 - 1), 0.0, 1.0, 0.0);
                worldr.a((double)(var14 + 1), (double)(var19 - 1), 0.0, 0.0, 0.0);
                tess.b();
                GL11.glEnable((int)3553);
            }
            this.drawSlot(var11, boxRight, var19, var13, tess);
        }
        GL11.glDisable((int)2929);
        int var20 = 4;
        if (this.client.f == null) {
            this.overlayBackground(0, this.top, 255, 255);
            this.overlayBackground(this.bottom, this.listHeight, 255, 255);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        worldr.b();
        worldr.a(0, 0);
        worldr.a((double)this.left, (double)(this.top + var20), 0.0, 0.0, 1.0);
        worldr.a((double)this.right, (double)(this.top + var20), 0.0, 1.0, 1.0);
        worldr.a(0, 255);
        worldr.a((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        worldr.a((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tess.b();
        worldr.b();
        worldr.a(0, 255);
        worldr.a((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        worldr.a((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        worldr.a(0, 0);
        worldr.a((double)this.right, (double)(this.bottom - var20), 0.0, 1.0, 0.0);
        worldr.a((double)this.left, (double)(this.bottom - var20), 0.0, 0.0, 0.0);
        tess.b();
        var19 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var19 > 0) {
            int var14;
            var13 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (var13 < 32) {
                var13 = 32;
            }
            if (var13 > this.bottom - this.top - 8) {
                var13 = this.bottom - this.top - 8;
            }
            if ((var14 = (int)this.scrollDistance * (this.bottom - this.top - var13) / var19 + this.top) < this.top) {
                var14 = this.top;
            }
            worldr.b();
            worldr.a(0, 255);
            worldr.a((double)scrollBarXStart, (double)this.bottom, 0.0, 0.0, 1.0);
            worldr.a((double)scrollBarXEnd, (double)this.bottom, 0.0, 1.0, 1.0);
            worldr.a((double)scrollBarXEnd, (double)this.top, 0.0, 1.0, 0.0);
            worldr.a((double)scrollBarXStart, (double)this.top, 0.0, 0.0, 0.0);
            tess.b();
            worldr.b();
            worldr.a(0x808080, 255);
            worldr.a((double)scrollBarXStart, (double)(var14 + var13), 0.0, 0.0, 1.0);
            worldr.a((double)scrollBarXEnd, (double)(var14 + var13), 0.0, 1.0, 1.0);
            worldr.a((double)scrollBarXEnd, (double)var14, 0.0, 1.0, 0.0);
            worldr.a((double)scrollBarXStart, (double)var14, 0.0, 0.0, 0.0);
            tess.b();
            worldr.b();
            worldr.a(0xC0C0C0, 255);
            worldr.a((double)scrollBarXStart, (double)(var14 + var13 - 1), 0.0, 0.0, 1.0);
            worldr.a((double)(scrollBarXEnd - 1), (double)(var14 + var13 - 1), 0.0, 1.0, 1.0);
            worldr.a((double)(scrollBarXEnd - 1), (double)var14, 0.0, 1.0, 0.0);
            worldr.a((double)scrollBarXStart, (double)var14, 0.0, 0.0, 0.0);
            tess.b();
        }
        this.func_27257_b(mouseX, mouseY);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void overlayBackground(int p_22239_1_, int p_22239_2_, int p_22239_3_, int p_22239_4_) {
        ckx var5 = ckx.a();
        civ worldr = var5.c();
        this.client.O.a(bub.b);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var6 = 32.0f;
        worldr.b();
        worldr.a(0x404040, p_22239_4_);
        worldr.a(0.0, (double)p_22239_2_, 0.0, 0.0, (double)((float)p_22239_2_ / var6));
        worldr.a((double)this.listWidth + 30.0, (double)p_22239_2_, 0.0, (double)((float)(this.listWidth + 30) / var6), (double)((float)p_22239_2_ / var6));
        worldr.a(0x404040, p_22239_3_);
        worldr.a((double)this.listWidth + 30.0, (double)p_22239_1_, 0.0, (double)((float)(this.listWidth + 30) / var6), (double)((float)p_22239_1_ / var6));
        worldr.a(0.0, (double)p_22239_1_, 0.0, 0.0, (double)((float)p_22239_1_ / var6));
        var5.b();
    }

    protected void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        dax.c((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        ckx tessellator = ckx.a();
        civ worldrenderer = tessellator.c();
        worldrenderer.b();
        worldrenderer.a(f1, f2, f3, f);
        worldrenderer.b((double)par3, (double)par2, 0.0);
        worldrenderer.b((double)par1, (double)par2, 0.0);
        worldrenderer.a(f5, f6, f7, f4);
        worldrenderer.b((double)par1, (double)par4, 0.0);
        worldrenderer.b((double)par3, (double)par4, 0.0);
        tessellator.b();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

