/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.imageio.ImageIO;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiSlotModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class GuiModList
extends bxf {
    private bxf mainMenu;
    private GuiSlotModList modList;
    private int selected = -1;
    private ModContainer selectedMod;
    private int listWidth;
    private ArrayList<ModContainer> mods;
    private bug configModButton;
    private bug disableModButton;
    private oa cachedLogo;
    private Dimension cachedLogoDimensions;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private bul search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiModList(bxf mainMenu) {
        this.mainMenu = mainMenu;
        this.mods = new ArrayList();
        FMLClientHandler.instance().addSpecialModEntries(this.mods);
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getMetadata() != null && mod.getMetadata().parentMod == null && !Strings.isNullOrEmpty((String)mod.getMetadata().parent)) {
                String parentMod = mod.getMetadata().parent;
                ModContainer parentContainer = Loader.instance().getIndexedModList().get(parentMod);
                if (parentContainer != null) {
                    mod.getMetadata().parentMod = parentContainer;
                    parentContainer.getMetadata().childMods.add(mod);
                    continue;
                }
            } else if (mod.getMetadata() != null && mod.getMetadata().parentMod != null) continue;
            this.mods.add(mod);
        }
    }

    public void b() {
        for (ModContainer mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().a(mod.getName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().a(mod.getVersion()) + 10);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.modList = new GuiSlotModList(this, this.mods, this.listWidth);
        this.modList.registerScrollButtons(this.n, 7, 8);
        this.n.add(new bug(6, (this.modList.right + this.l) / 2 - 100, this.m - 38, cwc.a((String)"gui.done", (Object[])new Object[0])));
        this.configModButton = new bug(20, 10, this.m - 49, this.listWidth, 20, "Config");
        this.disableModButton = new bug(21, 10, this.m - 27, this.listWidth, 20, "Disable");
        this.n.add(this.configModButton);
        this.n.add(this.disableModButton);
        this.search = new bul(0, this.getFontRenderer(), 12, this.modList.bottom + 17, this.modList.listWidth - 4, 14);
        this.search.b(true);
        this.search.d(true);
        int width = this.modList.listWidth / this.numButtons;
        int x = 10;
        int y = 10;
        bug normalSort = new bug(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, cwc.a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.l = false;
        this.n.add(normalSort);
        this.n.add(new bug(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.n.add(new bug(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
    }

    protected void a(int x, int y, int button) throws IOException {
        super.a(x, y, button);
        this.search.a(x, y, button);
        if (button == 1 && x >= this.search.a && x < this.search.a + this.l && y >= this.search.f && y < this.search.f + this.m) {
            this.search.a("");
        }
    }

    protected void a(char c, int keyCode) throws IOException {
        super.a(c, keyCode);
        this.search.a(c, keyCode);
    }

    public void e() {
        super.e();
        this.search.a();
        if (!this.search.b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            switch (this.sortType) {
                case A_TO_Z: {
                    Collections.sort(this.modList.getMods(), new Comparator<ModContainer>(){

                        @Override
                        public int compare(ModContainer o1, ModContainer o2) {
                            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                        }
                    });
                    break;
                }
                case Z_TO_A: {
                    Collections.sort(this.modList.getMods(), new Comparator<ModContainer>(){

                        @Override
                        public int compare(ModContainer o1, ModContainer o2) {
                            return o2.getName().toLowerCase().compareTo(o1.getName().toLowerCase());
                        }
                    });
                    break;
                }
                default: {
                    this.reloadMods();
                }
            }
            this.mods = this.modList.getMods();
            this.selected = this.modList.selectedIndex = this.mods.indexOf(this.selectedMod);
            this.sorted = true;
        }
    }

    private void reloadMods() {
        ArrayList<ModContainer> mods = this.modList.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getName().toLowerCase().contains(this.search.b().toLowerCase()) || m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.mods = mods;
        this.lastFilterText = this.search.b();
    }

    protected void a(bug button) throws IOException {
        if (button.l) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                for (bug b2 : this.n) {
                    if (SortType.getTypeForButton(b2) == null) continue;
                    b2.l = true;
                }
                button.l = false;
                this.sorted = false;
                this.sortType = type;
                this.mods = this.modList.getMods();
            } else {
                switch (button.k) {
                    case 6: {
                        this.j.a(this.mainMenu);
                        return;
                    }
                    case 20: {
                        try {
                            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                            bxf newScreen = guiFactory.mainConfigGuiClass().getConstructor(bxf.class).newInstance(new Object[]{this});
                            this.j.a(newScreen);
                        }
                        catch (Exception e) {
                            FMLLog.log(Level.ERROR, e, "There was a critical issue trying to build the config GUI for %s", this.selectedMod.getModId());
                        }
                        return;
                    }
                }
            }
        }
        super.a(button);
    }

    public int drawLine(String line, int offset, int shifty) {
        this.q.a(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    public void a(int p_571_1_, int p_571_2_, float p_571_3_) {
        this.modList.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        this.a(this.q, "Mod List", this.l / 2, 16, 0xFFFFFF);
        int offset = this.listWidth + 20;
        if (this.selectedMod != null) {
            GL11.glEnable((int)3042);
            if (!this.selectedMod.getMetadata().autogenerated) {
                ModContainer.Disableable disableable;
                this.configModButton.m = true;
                this.disableModButton.m = true;
                this.disableModButton.packedFGColour = 0xFF3377;
                this.configModButton.l = false;
                int shifty = 35;
                String logoFile = this.selectedMod.getMetadata().logoFile;
                if (!logoFile.isEmpty()) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    cug tm = this.j.N();
                    cvm pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
                    try {
                        if (this.cachedLogo == null) {
                            BufferedImage logo = null;
                            if (pack != null) {
                                logo = pack.a();
                            } else {
                                InputStream logoResource = ((Object)((Object)this)).getClass().getResourceAsStream(logoFile);
                                if (logoResource != null) {
                                    logo = ImageIO.read(logoResource);
                                }
                            }
                            if (logo != null) {
                                this.cachedLogo = tm.a("modlogo", new ctp(logo));
                                this.cachedLogoDimensions = new Dimension(logo.getWidth(), logo.getHeight());
                            }
                        }
                        if (this.cachedLogo != null) {
                            this.j.O.a(this.cachedLogo);
                            double scaleX = (double)this.cachedLogoDimensions.width / 200.0;
                            double scaleY = (double)this.cachedLogoDimensions.height / 65.0;
                            double scale = 1.0;
                            if (scaleX > 1.0 || scaleY > 1.0) {
                                scale = 1.0 / Math.max(scaleX, scaleY);
                            }
                            this.cachedLogoDimensions.width = (int)((double)this.cachedLogoDimensions.width * scale);
                            this.cachedLogoDimensions.height = (int)((double)this.cachedLogoDimensions.height * scale);
                            int top = 32;
                            ckx tess = ckx.a();
                            civ world = tess.c();
                            world.b();
                            world.a((double)offset, (double)(top + this.cachedLogoDimensions.height), (double)this.e, 0.0, 1.0);
                            world.a((double)(offset + this.cachedLogoDimensions.width), (double)(top + this.cachedLogoDimensions.height), (double)this.e, 1.0, 1.0);
                            world.a((double)(offset + this.cachedLogoDimensions.width), (double)top, (double)this.e, 1.0, 0.0);
                            world.a((double)offset, (double)top, (double)this.e, 0.0, 0.0);
                            tess.b();
                            shifty += 65;
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.q.a(this.selectedMod.getMetadata().name, (float)offset, (float)shifty, 0xFFFFFF);
                shifty += 12;
                shifty = this.drawLine(String.format("Version: %s (%s)", this.selectedMod.getDisplayVersion(), this.selectedMod.getVersion()), offset, shifty);
                shifty = this.drawLine(String.format("Mod ID: '%s' Mod State: %s", new Object[]{this.selectedMod.getModId(), Loader.instance().getModState(this.selectedMod)}), offset, shifty);
                if (!this.selectedMod.getMetadata().credits.isEmpty()) {
                    shifty = this.drawLine(String.format("Credits: %s", this.selectedMod.getMetadata().credits), offset, shifty);
                }
                shifty = this.drawLine(String.format("Authors: %s", this.selectedMod.getMetadata().getAuthorList()), offset, shifty);
                shifty = this.drawLine(String.format("URL: %s", this.selectedMod.getMetadata().url), offset, shifty);
                shifty = this.drawLine(this.selectedMod.getMetadata().childMods.isEmpty() ? "No child mods for this mod" : String.format("Child mods: %s", this.selectedMod.getMetadata().getChildModList()), offset, shifty);
                int rightSide = this.l - offset - 20;
                if (rightSide > 20) {
                    this.getFontRenderer().a(this.selectedMod.getMetadata().description, offset, shifty + 10, rightSide, 0xDDDDDD);
                }
                if ((disableable = this.selectedMod.canBeDisabled()) == ModContainer.Disableable.RESTART) {
                    this.disableModButton.l = true;
                    this.disableModButton.m = true;
                    this.disableModButton.packedFGColour = 0xFF3377;
                } else if (disableable == ModContainer.Disableable.YES) {
                    this.disableModButton.l = true;
                    this.disableModButton.m = true;
                    this.disableModButton.packedFGColour = 0;
                } else {
                    this.disableModButton.packedFGColour = 0;
                    this.disableModButton.m = true;
                    this.disableModButton.l = false;
                }
                IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                if (guiFactory == null || guiFactory.mainConfigGuiClass() == null) {
                    this.configModButton.m = true;
                    this.configModButton.l = false;
                } else {
                    this.configModButton.m = true;
                    this.configModButton.l = true;
                }
            } else {
                offset = (this.listWidth + this.l) / 2;
                this.a(this.q, this.selectedMod.getName(), offset, 35, 0xFFFFFF);
                this.a(this.q, String.format("Version: %s", this.selectedMod.getVersion()), offset, 45, 0xFFFFFF);
                this.a(this.q, String.format("Mod State: %s", new Object[]{Loader.instance().getModState(this.selectedMod)}), offset, 55, 0xFFFFFF);
                this.a(this.q, "No mod information found", offset, 65, 0xDDDDDD);
                this.a(this.q, "Ask your mod author to provide a mod mcmod.info file", offset, 75, 0xDDDDDD);
                this.configModButton.m = false;
                this.disableModButton.m = false;
            }
            GL11.glDisable((int)3042);
        } else {
            this.configModButton.m = false;
            this.disableModButton.m = false;
        }
        super.a(p_571_1_, p_571_2_, p_571_3_);
        String text = cwc.a((String)"fml.menu.mods.search", (Object[])new Object[0]);
        int x = (10 + this.modList.right) / 2 - this.getFontRenderer().a(text) / 2;
        this.getFontRenderer().a(text, x, this.modList.bottom + 5, 0xFFFFFF);
        this.search.g();
    }

    bsu getMinecraftInstance() {
        return this.j;
    }

    bty getFontRenderer() {
        return this.q;
    }

    public void selectModIndex(int var1) {
        this.selected = var1;
        this.selectedMod = var1 >= 0 && var1 <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.cachedLogo = null;
    }

    public boolean modIndexSelected(int var1) {
        return var1 == this.selected;
    }

    private static enum SortType {
        NORMAL(24),
        A_TO_Z(25),
        Z_TO_A(26);

        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        public static SortType getTypeForButton(bug button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.k) continue;
                return t;
            }
            return null;
        }
    }
}

