/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public fn getDataForWriting(bqm handler, bqo info) {
        fn fmlData = new fn();
        fv modList = new fv();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            fn mod = new fn();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            modList.a((gd)mod);
        }
        fmlData.a("ModList", (gd)modList);
        fn registries = new fn();
        fmlData.a("Registries", (gd)registries);
        FMLLog.fine("Gathering id map for writing to world save %s", info.k());
        GameData.GameDataSnapshot dataSnapshot = GameData.takeSnapshot();
        for (Map.Entry<String, GameData.GameDataSnapshot.Entry> e : dataSnapshot.entries.entrySet()) {
            fn data = new fn();
            registries.a(e.getKey(), (gd)data);
            fv ids = new fv();
            for (Map.Entry<String, Integer> item : e.getValue().ids.entrySet()) {
                fn tag = new fn();
                tag.a("K", item.getKey());
                tag.a("V", item.getValue().intValue());
                ids.a((gd)tag);
            }
            data.a("ids", (gd)ids);
            fv aliases = new fv();
            for (Map.Entry<String, String> entry : e.getValue().aliases.entrySet()) {
                fn tag = new fn();
                tag.a("K", entry.getKey());
                tag.a("V", entry.getValue());
                aliases.a((gd)tag);
            }
            data.a("aliases", (gd)aliases);
            fv subs = new fv();
            for (String entry : e.getValue().substitutions) {
                fn tag = new fn();
                tag.a("K", entry);
                subs.a((gd)tag);
            }
            data.a("substitutions", (gd)subs);
            int[] blocked = new int[e.getValue().blocked.size()];
            int idx = 0;
            for (Integer i : e.getValue().blocked) {
                blocked[idx++] = i;
            }
            data.a("blocked", blocked);
        }
        return fmlData;
    }

    @Override
    public void readData(bqm handler, bqo info, Map<String, gd> propertyMap, fn tag) {
        if (tag.c("ModList")) {
            fv modList = tag.c("ModList", 10);
            for (int i = 0; i < modList.c(); ++i) {
                fn mod = modList.b(i);
                String modId = mod.j("ModId");
                String modVersion = mod.j("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.c("ModItemData")) {
            GameData.GameDataSnapshot snapshot = new GameData.GameDataSnapshot();
            GameData.GameDataSnapshot.Entry items = new GameData.GameDataSnapshot.Entry();
            snapshot.entries.put("fml:blocks", new GameData.GameDataSnapshot.Entry());
            snapshot.entries.put("fml:items", items);
            FMLLog.info("Attempting to convert old world data to new system. This may be trouble!", new Object[0]);
            fv modList = tag.c("ModItemData", 10);
            for (int i = 0; i < modList.c(); ++i) {
                String forcedName;
                fn data = modList.b(i);
                String forcedModId = data.c("ForcedModId") ? data.j("ForcedModId") : null;
                String string = forcedName = data.c("ForcedName") ? data.j("ForcedName") : null;
                if (forcedName == null) {
                    FMLLog.warning("Found unlabelled item in world save, this may cause problems. The item type %s:%d will not be present", data.j("ItemType"), data.f("ordinal"));
                    continue;
                }
                String itemLabel = String.format("%s:%s", forcedModId != null ? forcedModId : data.j("ModId"), forcedName);
                items.ids.put(itemLabel, data.f("ItemId"));
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        } else if (tag.c("ItemData")) {
            int i;
            GameData.GameDataSnapshot snapshot = new GameData.GameDataSnapshot();
            GameData.GameDataSnapshot.Entry blocks = new GameData.GameDataSnapshot.Entry();
            GameData.GameDataSnapshot.Entry items = new GameData.GameDataSnapshot.Entry();
            snapshot.entries.put("fml:blocks", blocks);
            snapshot.entries.put("fml:items", items);
            fv list = tag.c("ItemData", 10);
            for (int i2 = 0; i2 < list.c(); ++i2) {
                fn e = list.b(i2);
                String name = e.j("K");
                if (name.charAt(0) == '\u0001') {
                    blocks.ids.put(name.substring(1), e.f("V"));
                    continue;
                }
                if (name.charAt(0) != '\u0002') continue;
                items.ids.put(name.substring(1), e.f("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            if (!tag.c("BlockedItemIds")) {
                GameData.fixBrokenIds(blocks, items, blockedIds);
            } else {
                for (int id2 : tag.l("BlockedItemIds")) {
                    blockedIds.add(id2);
                }
            }
            blocks.blocked.addAll(blockedIds);
            items.blocked.addAll(blockedIds);
            list = tag.c("BlockAliases", 10);
            for (i = 0; i < list.c(); ++i) {
                fn dataTag = list.b(i);
                blocks.aliases.put(dataTag.j("K"), dataTag.j("V"));
            }
            if (tag.b("BlockSubstitutions", 9)) {
                list = tag.c("BlockSubstitutions", 10);
                for (i = 0; i < list.c(); ++i) {
                    fn dataTag = list.b(i);
                    blocks.substitutions.add(dataTag.j("K"));
                }
            }
            list = tag.c("ItemAliases", 10);
            for (i = 0; i < list.c(); ++i) {
                fn dataTag = list.b(i);
                items.aliases.put(dataTag.j("K"), dataTag.j("V"));
            }
            if (tag.b("ItemSubstitutions", 9)) {
                list = tag.c("ItemSubstitutions", 10);
                for (i = 0; i < list.c(); ++i) {
                    fn dataTag = list.b(i);
                    items.substitutions.add(dataTag.j("K"));
                }
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        } else if (tag.c("Registries")) {
            GameData.GameDataSnapshot snapshot = new GameData.GameDataSnapshot();
            fn regs = tag.m("Registries");
            for (String key : regs.c()) {
                int[] blocked;
                fn e;
                int x;
                GameData.GameDataSnapshot.Entry entry = new GameData.GameDataSnapshot.Entry();
                snapshot.entries.put(key, entry);
                fv list = regs.m(key).c("ids", 10);
                for (x = 0; x < list.c(); ++x) {
                    e = list.b(x);
                    entry.ids.put(e.j("K"), e.f("V"));
                }
                list = regs.m(key).c("aliases", 10);
                for (x = 0; x < list.c(); ++x) {
                    e = list.b(x);
                    entry.aliases.put(e.j("K"), e.j("V"));
                }
                list = regs.m(key).c("substitutions", 10);
                for (x = 0; x < list.c(); ++x) {
                    e = list.b(x);
                    entry.substitutions.add(e.j("K"));
                }
                for (int i : blocked = regs.m(key).l("blocked")) {
                    entry.blocked.add(i);
                }
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

