/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private BitSet availableIndicies;
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends wv>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
        this.availableIndicies = new BitSet(256);
        this.availableIndicies.set(1, 255);
        for (Object id2 : xb.e.keySet()) {
            this.availableIndicies.clear((Integer)id2);
        }
    }

    public static void registerModEntity(Class<? extends wv> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id2, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    private void doModEntityRegistration(Class<? extends wv> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc2 = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc2, entityClass, entityName, id2, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            this.entityNames.put(entityName, mc2);
            if (!xb.d.containsKey(entityClass)) {
                String entityModName = String.format("%s.%s", mc2.getModId(), entityName);
                xb.d.put(entityClass, entityModName);
                xb.c.put(entityModName, entityClass);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc2.getModId(), entityName, entityModName);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", mc2.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException e) {
            FMLLog.log(Level.WARN, e, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc2.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc2, (Object)er2);
    }

    public static void registerGlobalEntityID(Class<? extends wv> entityClass, String entityName, int id2) {
        if (xb.d.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        id2 = EntityRegistry.instance().validateAndClaimId(id2);
        xb.a(entityClass, (String)entityName, (int)id2);
    }

    private int validateAndClaimId(int id2) {
        int realId = id2;
        if (id2 < -128) {
            FMLLog.warning("Compensating for modloader out of range compensation by mod : entityId %d for mod %s is now %d", id2, Loader.instance().activeModContainer().getModId(), realId);
            realId += 3000;
        }
        if (realId < 0) {
            realId += 127;
        }
        try {
            UnsignedBytes.checkedCast((long)realId);
        }
        catch (IllegalArgumentException e) {
            FMLLog.log(Level.ERROR, "The entity ID %d for mod %s is not an unsigned byte and may not work", id2, Loader.instance().activeModContainer().getModId());
        }
        if (!this.availableIndicies.get(realId)) {
            FMLLog.severe("The mod %s has attempted to register an entity ID %d which is already reserved. This could cause severe problems", Loader.instance().activeModContainer().getModId(), id2);
        }
        this.availableIndicies.clear(realId);
        return realId;
    }

    public static void registerGlobalEntityID(Class<? extends wv> entityClass, String entityName, int id2, int backgroundEggColour, int foregroundEggColour) {
        if (xb.d.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        EntityRegistry.instance().validateAndClaimId(id2);
        xb.a(entityClass, (String)entityName, (int)id2, (int)backgroundEggColour, (int)foregroundEggColour);
    }

    public static void addSpawn(Class<? extends xn> entityClass, int weightedProb, int min, int max, xp typeOfCreature, arm ... biomes) {
        for (arm biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            for (arq entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                break;
            }
            spawns.add(new arq(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, xp spawnList, arm ... biomes) {
        Class entityClazz = (Class)xb.c.get(entityName);
        if (xn.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static void removeSpawn(Class<? extends xn> entityClass, xp typeOfCreature, arm ... biomes) {
        for (arm biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                arq entry = (arq)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, xp spawnList, arm ... biomes) {
        Class entityClazz = (Class)xb.c.get(entityName);
        if (xn.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, spawnList, biomes);
        }
    }

    public static int findGlobalUniqueEntityId() {
        int res = EntityRegistry.instance().availableIndicies.nextSetBit(0);
        if (res < 0) {
            throw new RuntimeException("No more entity indicies left");
        }
        return res;
    }

    public EntityRegistration lookupModSpawn(Class<? extends wv> clazz, boolean keepLooking) {
        Class<? extends wv> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking = !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc2, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc2)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(qn entityTracker, wv entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public class EntityRegistration {
        private Class<? extends wv> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, wv> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc2, Class<? extends wv> entityClass, String entityName, int id2, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc2;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id2;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends wv> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public wv doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (wv)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, wv> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

