/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.FMLSecurityManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TerminalTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassWriter writer;
        if (basicClass == null) {
            return null;
        }
        ClassReader reader = new ClassReader(basicClass);
        Object visitor = writer = new ClassWriter(1);
        visitor = new ExitVisitor((ClassVisitor)visitor);
        reader.accept((ClassVisitor)visitor, 0);
        return writer.toByteArray();
    }

    public static class ExitVisitor
    extends ClassVisitor {
        private String clsName = null;
        private static final String callbackOwner = Type.getInternalName(ExitVisitor.class);

        private ExitVisitor(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.clsName = name;
        }

        public MethodVisitor visitMethod(int mAccess, final String mName, final String mDesc, String mSignature, String[] mExceptions) {
            final boolean warn = !this.clsName.equals("net/minecraft/client/Minecraft") && !this.clsName.equals("net/minecraft/server/dedicated/DedicatedServer") && !this.clsName.equals("net/minecraft/server/dedicated/ServerHangWatchdog") && !this.clsName.equals("net/minecraft/server/dedicated/ServerHangWatchdog$1") && !this.clsName.equals("net/minecraftforge/fml/common/FMLCommonHandler") && !this.clsName.startsWith("com/jcraft/jogg/") && !this.clsName.startsWith("scala/sys/") && !this.clsName.startsWith("net/minecraft/server/gui/MinecraftServerGui");
            return new MethodVisitor(262144, super.visitMethod(mAccess, mName, mDesc, mSignature, mExceptions)){

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isIntf) {
                    if (opcode == 184 && owner.equals("java/lang/System") && name.equals("exit") && desc.equals("(I)V")) {
                        if (warn) {
                            FMLRelaunchLog.warning("=============================================================", new Object[0]);
                            FMLRelaunchLog.warning("MOD HAS DIRECT REFERENCE System.exit() THIS IS NOT ALLOWED REROUTING TO FML!", new Object[0]);
                            FMLRelaunchLog.warning("Offendor: %s.%s%s", ExitVisitor.this.clsName, mName, mDesc);
                            FMLRelaunchLog.warning("Use FMLCommonHandler.exitJava instead", new Object[0]);
                            FMLRelaunchLog.warning("=============================================================", new Object[0]);
                        }
                        owner = callbackOwner;
                        name = "systemExitCalled";
                    } else if (opcode == 182 && owner.equals("java/lang/Runtime") && name.equals("exit") && desc.equals("(I)V")) {
                        if (warn) {
                            FMLRelaunchLog.warning("=============================================================", new Object[0]);
                            FMLRelaunchLog.warning("MOD HAS DIRECT REFERENCE Runtime.exit() THIS IS NOT ALLOWED REROUTING TO FML!", new Object[0]);
                            FMLRelaunchLog.warning("Offendor: %s.%s%s", ExitVisitor.this.clsName, mName, mDesc);
                            FMLRelaunchLog.warning("Use FMLCommonHandler.exitJava instead", new Object[0]);
                            FMLRelaunchLog.warning("=============================================================", new Object[0]);
                        }
                        opcode = 184;
                        owner = callbackOwner;
                        name = "runtimeExitCalled";
                        desc = "(Ljava/lang/Runtime;I)V";
                    } else if (opcode == 182 && owner.equals("java/lang/Runtime") && name.equals("halt") && desc.equals("(I)V")) {
                        if (warn) {
                            FMLRelaunchLog.warning("=============================================================", new Object[0]);
                            FMLRelaunchLog.warning("MOD HAS DIRECT REFERENCE Runtime.halt() THIS IS NOT ALLOWED REROUTING TO FML!", new Object[0]);
                            FMLRelaunchLog.warning("Offendor: %s.%s%s", ExitVisitor.this.clsName, mName, mDesc);
                            FMLRelaunchLog.warning("Use FMLCommonHandler.exitJava instead", new Object[0]);
                            FMLRelaunchLog.warning("=============================================================", new Object[0]);
                        }
                        opcode = 184;
                        owner = callbackOwner;
                        name = "runtimeHaltCalled";
                        desc = "(Ljava/lang/Runtime;I)V";
                    }
                    super.visitMethodInsn(opcode, owner, name, desc, isIntf);
                }
            };
        }

        public static void systemExitCalled(int status) {
            ExitVisitor.checkAccess();
            System.exit(status);
        }

        public static void runtimeExitCalled(Runtime runtime, int status) {
            ExitVisitor.checkAccess();
            runtime.exit(status);
        }

        public static void runtimeHaltCalled(Runtime runtime, int status) {
            ExitVisitor.checkAccess();
            runtime.halt(status);
        }

        private static void checkAccess() {
            String callingParent;
            StackTraceElement[] cause = Thread.currentThread().getStackTrace();
            String callingClass = cause.length > 2 ? cause[3].getClassName() : "none";
            String string = callingParent = cause.length > 3 ? cause[4].getClassName() : "none";
            if (!(callingClass.startsWith("net.minecraftforge.fml.") || "net.minecraft.client.Minecraft".equals(callingClass) && "net.minecraft.client.Minecraft".equals(callingParent) || "net.minecraft.server.gui.MinecraftServerGui$1".equals(callingClass) && "java.awt.AWTEventMulticaster".equals(callingParent) || "net.minecraft.server.dedicated.DedicatedServer".equals(callingClass) && "net.minecraft.server.MinecraftServer".equals(callingParent))) {
                throw new FMLSecurityManager.ExitTrappedException();
            }
        }
    }
}

