/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.registry.GameData;

public abstract class FMLHandshakeMessage {
    public static FMLProxyPacket makeCustomChannelRegistration(Set<String> channels) {
        String salutation = Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML|HS", "FML", "FML|MP"), channels));
        FMLProxyPacket proxy = new FMLProxyPacket(new hd(Unpooled.wrappedBuffer((byte[])salutation.getBytes(Charsets.UTF_8))), "REGISTER");
        return proxy;
    }

    public void fromBytes(ByteBuf buffer) {
    }

    public void toBytes(ByteBuf buffer) {
    }

    public String toString(Class<? extends Enum<?>> side) {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(36));
    }

    public static class HandshakeReset
    extends FMLHandshakeMessage {
    }

    public static class HandshakeAck
    extends FMLHandshakeMessage {
        int phase;

        public HandshakeAck() {
        }

        HandshakeAck(int phase) {
            this.phase = phase;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.phase = buffer.readByte();
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(this.phase);
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":{" + this.phase + "}";
        }
    }

    public static class ModIdData
    extends FMLHandshakeMessage {
        private Map<String, Integer> modIds;
        private Set<String> blockSubstitutions;
        private Set<String> itemSubstitutions;

        public ModIdData() {
        }

        public ModIdData(GameData.GameDataSnapshot snapshot) {
            this.modIds = snapshot.idMap;
            this.blockSubstitutions = snapshot.blockSubstitutions;
            this.itemSubstitutions = snapshot.itemSubstitutions;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            int i;
            int length = ByteBufUtils.readVarInt(buffer, 3);
            this.modIds = Maps.newHashMap();
            this.blockSubstitutions = Sets.newHashSet();
            this.itemSubstitutions = Sets.newHashSet();
            for (i = 0; i < length; ++i) {
                this.modIds.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readVarInt(buffer, 3));
            }
            if (!buffer.isReadable()) {
                return;
            }
            length = ByteBufUtils.readVarInt(buffer, 3);
            for (i = 0; i < length; ++i) {
                this.blockSubstitutions.add(ByteBufUtils.readUTF8String(buffer));
            }
            length = ByteBufUtils.readVarInt(buffer, 3);
            for (i = 0; i < length; ++i) {
                this.itemSubstitutions.add(ByteBufUtils.readUTF8String(buffer));
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            ByteBufUtils.writeVarInt(buffer, this.modIds.size(), 3);
            for (Map.Entry<String, Integer> entry : this.modIds.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, entry.getKey());
                ByteBufUtils.writeVarInt(buffer, entry.getValue(), 3);
            }
            ByteBufUtils.writeVarInt(buffer, this.blockSubstitutions.size(), 3);
            for (String string : this.blockSubstitutions) {
                ByteBufUtils.writeUTF8String(buffer, string);
            }
            ByteBufUtils.writeVarInt(buffer, this.blockSubstitutions.size(), 3);
            for (String string : this.itemSubstitutions) {
                ByteBufUtils.writeUTF8String(buffer, string);
            }
        }

        public Map<String, Integer> dataList() {
            return this.modIds;
        }

        public Set<String> blockSubstitutions() {
            return this.blockSubstitutions;
        }

        public Set<String> itemSubstitutions() {
            return this.itemSubstitutions;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.modIds.size() + " mappings";
        }
    }

    public static class ModList
    extends FMLHandshakeMessage {
        private Map<String, String> modTags = Maps.newHashMap();

        public ModList() {
        }

        public ModList(List<ModContainer> modList) {
            for (ModContainer mod : modList) {
                this.modTags.put(mod.getModId(), mod.getVersion());
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            super.toBytes(buffer);
            ByteBufUtils.writeVarInt(buffer, this.modTags.size(), 2);
            for (Map.Entry<String, String> modTag : this.modTags.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, modTag.getKey());
                ByteBufUtils.writeUTF8String(buffer, modTag.getValue());
            }
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            super.fromBytes(buffer);
            int modCount = ByteBufUtils.readVarInt(buffer, 2);
            for (int i = 0; i < modCount; ++i) {
                this.modTags.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readUTF8String(buffer));
            }
        }

        public String modListAsString() {
            return Joiner.on((char)',').withKeyValueSeparator("@").join(this.modTags);
        }

        public int modListSize() {
            return this.modTags.size();
        }

        public Map<String, String> modList() {
            return this.modTags;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.modTags.size() + " mods";
        }
    }

    public static class ClientHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(1);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }
    }

    public static class ServerHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(1);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }
    }
}

