/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ItemStackTransformer
implements IClassTransformer {
    private static final String ITEM_TYPE = "Lnet/minecraft/item/Item;";
    private static final String GETITEM_DESC = "()Lnet/minecraft/item/Item;";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!"net.minecraft.item.ItemStack".equals(name)) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        FieldNode itemField = null;
        for (FieldNode f : classNode.fields) {
            if (ITEM_TYPE.equals(f.desc) && itemField == null) {
                itemField = f;
                continue;
            }
            if (!ITEM_TYPE.equals(f.desc)) continue;
            throw new RuntimeException("Error processing ItemStack - found a duplicate Item field");
        }
        if (itemField == null) {
            throw new RuntimeException("Error processing ItemStack - no Item field declared (is the code somehow obfuscated?)");
        }
        MethodNode getItemMethod = null;
        for (MethodNode m : classNode.methods) {
            if (GETITEM_DESC.equals(m.desc) && getItemMethod == null) {
                getItemMethod = m;
                continue;
            }
            if (!GETITEM_DESC.equals(m.desc)) continue;
            throw new RuntimeException("Error processing ItemStack - duplicate getItem method found");
        }
        if (getItemMethod == null) {
            throw new RuntimeException("Error processing ItemStack - no getItem method found (is the code somehow obfuscated?)");
        }
        for (MethodNode m : classNode.methods) {
            ListIterator it = m.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                if (insnNode.getType() != 4) continue;
                FieldInsnNode fi = (FieldInsnNode)insnNode;
                if (!itemField.name.equals(fi.name) || fi.getOpcode() != 180) continue;
                it.remove();
                MethodInsnNode replace = new MethodInsnNode(182, "net/minecraft/item/ItemStack", getItemMethod.name, getItemMethod.desc, false);
                it.add(replace);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

