/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.ExtendedServerListData;
import net.minecraftforge.fml.client.GuiAccessDenied;
import net.minecraftforge.fml.client.GuiConfirmation;
import net.minecraftforge.fml.client.GuiCustomModLoadingErrorScreen;
import net.minecraftforge.fml.client.GuiDupesFound;
import net.minecraftforge.fml.client.GuiIngameModOptions;
import net.minecraftforge.fml.client.GuiModsMissing;
import net.minecraftforge.fml.client.GuiNotification;
import net.minecraftforge.fml.client.GuiOldSaveLoadConfirm;
import net.minecraftforge.fml.client.GuiSortingProblem;
import net.minecraftforge.fml.client.GuiWrongMinecraft;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.DuplicateModsFoundException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.LanguageRegistry;
import net.minecraftforge.fml.common.toposort.ModSortingException;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Mouse;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private bsu client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;
    private MissingModsException modsMissing;
    private ModSortingException modSorting;
    private boolean loading = true;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;
    private DuplicateModsFoundException dupesFound;
    private boolean serverShouldBeKilledQuietly;
    private List<cvm> resourcePackList;
    private cvi resourceManager;
    private Map<String, cvm> resourcePackMap;
    private BiMap<ModContainer, IModGuiFactory> guiFactories;
    private Map<np, JsonObject> extraServerListData;
    private Map<cew, ExtendedServerListData> serverDataTag;
    private WeakReference<cee> currentPlayClient;
    private static final oa iconSheet = new oa("fml:textures/gui/icons.png");
    private static final CountDownLatch startupConnectionData = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginMinecraftLoading(bsu minecraft, List resourcePackList, cvi resourceManager) {
        this.client = minecraft;
        this.resourcePackList = resourcePackList;
        this.resourceManager = resourceManager;
        this.resourcePackMap = Maps.newHashMap();
        if (minecraft.s()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        FMLCommonHandler.instance().beginLoading(this);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info"), "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (DuplicateModsFoundException dupes) {
            this.dupesFound = dupes;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (ModSortingException sorting) {
            this.modSorting = sorting;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        finally {
            this.client.e();
        }
        try {
            Loader.instance().preinitializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        Map sharedModList = (Map)Launch.blackboard.get("modList");
        if (sharedModList == null) {
            sharedModList = Maps.newHashMap();
            Launch.blackboard.put("modList", sharedModList);
        }
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            Map<String, String> sharedModDescriptor = mc.getSharedModDescriptor();
            if (sharedModDescriptor == null) continue;
            String sharedModId = "fml:" + mc.getModId();
            sharedModList.put(sharedModId, sharedModDescriptor);
        }
    }

    @Override
    public void haltGame(String message, Throwable t) {
        this.client.c(new b(message, t));
        throw Throwables.propagate((Throwable)t);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null || this.customError != null || this.dupesFound != null || this.modSorting != null) {
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.ERROR, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            return;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        this.client.e();
        this.guiFactories = HashBiMap.create();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            String className = mc.getGuiClassName();
            if (Strings.isNullOrEmpty((String)className)) continue;
            try {
                Class<?> clazz = Class.forName(className, true, Loader.instance().getModClassLoader());
                Class<IModGuiFactory> guiClassFactory = clazz.asSubclass(IModGuiFactory.class);
                IModGuiFactory guiFactory = guiClassFactory.newInstance();
                guiFactory.initialize(this.client);
                this.guiFactories.put((Object)mc, (Object)guiFactory);
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "A critical error occurred instantiating the gui factory for mod %s", mc.getModId());
            }
        }
        this.loading = false;
        this.client.t.a();
    }

    public void extendModList() {
        Map modList = (Map)Launch.blackboard.get("modList");
        if (modList != null) {
            for (Map.Entry modEntry : modList.entrySet()) {
                String sharedModId = (String)modEntry.getKey();
                String system = sharedModId.split(":")[0];
                if ("fml".equals(system)) continue;
                Map mod = (Map)modEntry.getValue();
                String modSystem = (String)mod.get("modsystem");
                String modId = (String)mod.get("id");
                String modVersion = (String)mod.get("version");
                String modName = (String)mod.get("name");
                String modURL = (String)mod.get("url");
                String modAuthors = (String)mod.get("authors");
                String modDescription = (String)mod.get("description");
            }
        }
    }

    public void onInitializationComplete() {
        if (this.wrongMC != null) {
            this.showGuiScreen((Object)new GuiWrongMinecraft(this.wrongMC));
        } else if (this.modsMissing != null) {
            this.showGuiScreen((Object)new GuiModsMissing(this.modsMissing));
        } else if (this.dupesFound != null) {
            this.showGuiScreen((Object)new GuiDupesFound(this.dupesFound));
        } else if (this.modSorting != null) {
            this.showGuiScreen((Object)new GuiSortingProblem(this.modSorting));
        } else if (this.customError != null) {
            this.showGuiScreen((Object)new GuiCustomModLoadingErrorScreen(this.customError));
        }
    }

    public bsu getClient() {
        return this.client;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(ahd player, bxf gui) {
        if (this.client.h == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        bxf gui = (bxf)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            this.client.a((bxf)new GuiNotification(query));
        } else {
            this.client.a((bxf)new GuiConfirmation(query));
        }
        if (query.isSynchronous()) {
            while (this.client.m instanceof GuiNotification) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.client.n.c("");
                Thread.sleep(50L);
            }
            this.client.n.c("");
        }
    }

    public boolean handleLoadingScreen(buf scaledResolution) throws IOException {
        if (this.client.m instanceof GuiNotification) {
            int width = scaledResolution.a();
            int height = scaledResolution.b();
            int mouseX = Mouse.getX() * width / this.client.d;
            int mouseZ = height - Mouse.getY() * height / this.client.e - 1;
            this.client.m.a(mouseX, mouseZ, 0.0f);
            this.client.m.p();
            return true;
        }
        return false;
    }

    public cen getWorldClient() {
        return this.client.f;
    }

    public cio getClientPlayerEntity() {
        return this.client.h;
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public File getSavesDirectory() {
        return ((bqn)this.client.f()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.F();
    }

    public void displayMissingMods(Object modMissingPacket) {
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    public boolean isGUIOpen(Class<? extends bxf> gui) {
        return this.client.m != null && this.client.m.getClass().equals(gui);
    }

    @Override
    public void addModAsResource(ModContainer container) {
        LanguageRegistry.instance().loadLanguagesFor(container, Side.CLIENT);
        Class<?> resourcePackType = container.getCustomResourcePackClass();
        if (resourcePackType != null) {
            try {
                cvm pack = (cvm)resourcePackType.getConstructor(ModContainer.class).newInstance(container);
                this.resourcePackList.add(pack);
                this.resourcePackMap.put(container.getModId(), pack);
            }
            catch (NoSuchMethodException e) {
                FMLLog.log(Level.ERROR, "The container %s (type %s) returned an invalid class for it's resource pack.", container.getName(), container.getClass().getName());
                return;
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "An unexpected exception occurred constructing the custom resource pack for %s", container.getName());
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public cvm getResourcePackFor(String modId) {
        return this.resourcePackMap.get(modId);
    }

    @Override
    public String getCurrentLanguage() {
        return this.client.Q().c().a();
    }

    @Override
    public void serverStopped() {
        MinecraftServer server = this.getServer();
        if (server != null && !server.ap()) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(true), "field_71296_Q", "serverIsRunning");
        }
    }

    @Override
    public hg getClientPlayHandler() {
        return this.currentPlayClient == null ? null : (cee)this.currentPlayClient.get();
    }

    @Override
    public gr getClientToServerNetworkManager() {
        return this.client.t() != null ? this.client.t().a() : null;
    }

    public void handleClientWorldClosing(cen world) {
        gr client = this.getClientToServerNetworkManager();
        if (client != null && !client.c()) {
            GameData.revertToFrozen();
        }
    }

    public void startIntegratedServer(String id, String name, arb settings) {
    }

    public File getSavesDir() {
        return new File(this.client.v, "saves");
    }

    public void tryLoadExistingWorld(bxg selectWorldGUI, String dirName, String saveName) {
        fn leveldat;
        File dir = new File(this.getSavesDir(), dirName);
        try {
            leveldat = fz.a((InputStream)new FileInputStream(new File(dir, "level.dat")));
        }
        catch (Exception e) {
            try {
                leveldat = fz.a((InputStream)new FileInputStream(new File(dir, "level.dat_old")));
            }
            catch (Exception e1) {
                FMLLog.warning("There appears to be a problem loading the save %s, both level files are unreadable.", dirName);
                return;
            }
        }
        fn fmlData = leveldat.m("FML");
        if (fmlData.c("ModItemData")) {
            this.showGuiScreen((Object)new GuiOldSaveLoadConfirm(dirName, saveName, (bxf)selectWorldGUI));
        } else {
            try {
                this.client.a(dirName, saveName, (arb)null);
            }
            catch (StartupQuery.AbortedException e) {
                // empty catch block
            }
        }
    }

    public void showInGameModOptions(bwy guiIngameMenu) {
        this.showGuiScreen((Object)new GuiIngameModOptions((bxf)guiIngameMenu));
    }

    public IModGuiFactory getGuiFactoryFor(ModContainer selectedMod) {
        return (IModGuiFactory)this.guiFactories.get((Object)selectedMod);
    }

    public void setupServerList() {
        this.extraServerListData = Collections.synchronizedMap(Maps.newHashMap());
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    public void captureAdditionalData(np serverstatusresponse, JsonObject jsonobject) {
        if (jsonobject.has("modinfo")) {
            JsonObject fmlData = jsonobject.get("modinfo").getAsJsonObject();
            this.extraServerListData.put(serverstatusresponse, fmlData);
        }
    }

    public void bindServerListData(cew data, np originalResponse) {
        if (this.extraServerListData.containsKey(originalResponse)) {
            JsonObject jsonData = this.extraServerListData.get(originalResponse);
            String type = jsonData.get("type").getAsString();
            JsonArray modDataArray = jsonData.get("modList").getAsJsonArray();
            boolean moddedClientAllowed = jsonData.has("clientModsAllowed") ? jsonData.get("clientModsAllowed").getAsBoolean() : true;
            ImmutableMap.Builder modListBldr = ImmutableMap.builder();
            for (JsonElement obj : modDataArray) {
                JsonObject modObj = obj.getAsJsonObject();
                modListBldr.put((Object)modObj.get("modid").getAsString(), (Object)modObj.get("version").getAsString());
            }
            ImmutableMap modListMap = modListBldr.build();
            this.serverDataTag.put(data, new ExtendedServerListData(type, FMLNetworkHandler.checkModList((Map<String, String>)modListMap, Side.SERVER) == null, (Map<String, String>)modListMap, !moddedClientAllowed));
        } else {
            String serverDescription = data.d;
            boolean moddedClientAllowed = true;
            if (!Strings.isNullOrEmpty((String)serverDescription)) {
                moddedClientAllowed = !serverDescription.endsWith(":NOFML\u00a7r");
            }
            this.serverDataTag.put(data, new ExtendedServerListData("VANILLA", false, (Map<String, String>)ImmutableMap.of(), !moddedClientAllowed));
        }
        startupConnectionData.countDown();
    }

    public String enhanceServerListEntry(bzs serverListEntry, cew serverEntry, int x, int width, int y, int relativeMouseX, int relativeMouseY) {
        String tooltip;
        int idx;
        ExtendedServerListData extendedData;
        boolean blocked = false;
        if (this.serverDataTag.containsKey(serverEntry)) {
            extendedData = this.serverDataTag.get(serverEntry);
            if ("FML".equals(extendedData.type) && extendedData.isCompatible) {
                idx = 0;
                tooltip = String.format("Compatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("FML".equals(extendedData.type) && !extendedData.isCompatible) {
                idx = 16;
                tooltip = String.format("Incompatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("BUKKIT".equals(extendedData.type)) {
                idx = 32;
                tooltip = String.format("Bukkit modded server", new Object[0]);
            } else if ("VANILLA".equals(extendedData.type)) {
                idx = 48;
                tooltip = String.format("Vanilla server", new Object[0]);
            } else {
                idx = 64;
                tooltip = String.format("Unknown server data", new Object[0]);
            }
        } else {
            return null;
        }
        blocked = extendedData.isBlocked;
        this.client.N().a(iconSheet);
        bub.a((int)(x + width - 18), (int)(y + 10), (float)0.0f, (float)idx, (int)16, (int)16, (float)256.0f, (float)256.0f);
        if (blocked) {
            bub.a((int)(x + width - 18), (int)(y + 10), (float)0.0f, (float)80.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
        return relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26 ? tooltip : null;
    }

    public String fixDescription(String description) {
        return description.endsWith(":NOFML\u00a7r") ? description.substring(0, description.length() - 8) + "\u00a7r" : description;
    }

    public void connectToServerAtStartup(String host, int port) {
        this.setupServerList();
        cez osp = new cez();
        cew serverData = new cew("Command Line", host + ":" + port);
        try {
            osp.a(serverData);
            startupConnectionData.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.showGuiScreen(new bwb((bxf)new bxq(), this.client, host, port));
            return;
        }
        this.connectToServer((bxf)new bxq(), serverData);
    }

    public void connectToServer(bxf guiMultiplayer, cew serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen((Object)new GuiAccessDenied(guiMultiplayer, serverEntry));
        } else {
            this.showGuiScreen(new bwb(guiMultiplayer, this.client, serverEntry));
        }
    }

    public void connectToRealmsServer(String host, int port) {
    }

    public void setPlayClient(cee netHandlerPlayClient) {
        this.currentPlayClient = new WeakReference<cee>(netHandlerPlayClient);
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus, gr manager, Set<String> channelSet, String channel, Side side) {
        if (side == Side.CLIENT) {
            bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<cee>(manager, channelSet, channel, side, cee.class));
        } else {
            bus.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<rj>(manager, channelSet, channel, side, rj.class));
        }
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return true;
    }

    @Override
    public void allowLogins() {
    }
}

