/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class GameData {
    private static Table<String, String, abp> customItemStacks = HashBasedTable.create();
    public static final FMLControlledNamespacedRegistry<ahu> blockRegistry = new FMLControlledNamespacedRegistry<ahu>("air", 4095, 0, ahu.class, '\u0001');
    public static final FMLControlledNamespacedRegistry<abn> itemRegistry = new FMLControlledNamespacedRegistry<abn>(null, 32000, 4096, abn.class, '\u0002');
    private static Map<GameRegistry.UniqueIdentifier, ModContainer> customOwners = Maps.newHashMap();

    public static Map<String, Integer> buildItemDataList() {
        HashMap idMapping = Maps.newHashMap();
        blockRegistry.serializeInto(idMapping);
        itemRegistry.serializeInto(idMapping);
        return idMapping;
    }

    static abn findItem(String modId, String name) {
        return itemRegistry.a(modId + ":" + name);
    }

    static ahu findBlock(String modId, String name) {
        return blockRegistry.a(modId + ":" + name);
    }

    static abp findItemStack(String modId, String name) {
        ahu b2;
        abn i;
        abp is = (abp)customItemStacks.get((Object)modId, (Object)name);
        if (is == null && (i = GameData.findItem(modId, name)) != null) {
            is = new abp(i, 0, 0);
        }
        if (is == null && (b2 = GameData.findBlock(modId, name)) != null) {
            is = new abp(b2, 0, Short.MAX_VALUE);
        }
        return is;
    }

    static void registerCustomItemStack(String name, abp itemStack) {
        customItemStacks.put((Object)Loader.instance().activeModContainer().getModId(), (Object)name, (Object)itemStack);
    }

    public static void dumpRegistry(File minecraftDir) {
        if (customItemStacks == null) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("fml.dumpRegistry", "false")).booleanValue()) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String modId : customItemStacks.rowKeySet()) {
                builder.putAll((Object)modId, customItemStacks.row((Object)modId).keySet());
            }
            File f = new File(minecraftDir, "itemStackRegistry.csv");
            Joiner.MapJoiner mapJoiner = Joiner.on((String)"\n").withKeyValueSeparator(",");
            try {
                Files.write((CharSequence)mapJoiner.join((Iterable)builder.build().entries()), (File)f, (Charset)Charsets.UTF_8);
                FMLLog.log(Level.INFO, "Dumped item registry data to %s", f.getAbsolutePath());
            }
            catch (IOException e) {
                FMLLog.log(Level.ERROR, e, "Failed to write registry data to %s", f.getAbsolutePath());
            }
        }
    }

    static GameRegistry.UniqueIdentifier getUniqueName(ahu block) {
        if (block == null) {
            return null;
        }
        String name = blockRegistry.c(block);
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(name);
        if (customItemStacks.contains((Object)ui.modId, (Object)ui.name)) {
            return null;
        }
        return ui;
    }

    static GameRegistry.UniqueIdentifier getUniqueName(abn item) {
        if (item == null) {
            return null;
        }
        String name = itemRegistry.c(item);
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(name);
        if (customItemStacks.contains((Object)ui.modId, (Object)ui.name)) {
            return null;
        }
        return ui;
    }

    static void registerBlockAndItem(zt item, ahu block, String name, String modId) {
        int blockId;
        int itemId;
        ModContainer mc = Loader.instance().activeModContainer();
        if (modId != null) {
            customOwners.put(new GameRegistry.UniqueIdentifier(modId, name), mc);
        }
        if ((itemId = itemRegistry.add(blockId = blockRegistry.add(0, name, block), name, (abn)item)) != blockId) {
            throw new RuntimeException();
        }
    }

    static void registerItem(abn item, String name, String modId) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (modId != null) {
            customOwners.put(new GameRegistry.UniqueIdentifier(modId, name), mc);
        }
        if (item instanceof zt) {
            throw new RuntimeException("Cannot register an itemblock separately from it's block");
        }
        int itemId = itemRegistry.add(0, name, item);
        blockRegistry.useSlot(itemId);
    }

    static void registerBlock(ahu block, String name, String modId) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (modId != null) {
            customOwners.put(new GameRegistry.UniqueIdentifier(modId, name), mc);
        }
        int blockId = blockRegistry.add(0, name, block);
        itemRegistry.useSlot(blockId);
    }

    public static ModContainer findModOwner(String string) {
        GameRegistry.UniqueIdentifier ui = new GameRegistry.UniqueIdentifier(string);
        if (customOwners.containsKey(ui)) {
            return customOwners.get(ui);
        }
        return Loader.instance().getIndexedModList().get(ui.modId);
    }

    public static void fixupRegistries() {
        for (Integer id : blockRegistry.usedIds()) {
            itemRegistry.useSlot(id);
        }
        for (Integer id : itemRegistry.usedIds()) {
            blockRegistry.useSlot(id);
        }
    }

    public static boolean injectWorldIDMap(Map<String, Integer> dataList, boolean injectFrozenData) {
        HashMap remaps = Maps.newHashMap();
        ArrayListMultimap missing = ArrayListMultimap.create();
        blockRegistry.dump();
        itemRegistry.dump();
        blockRegistry.beginIdSwap();
        itemRegistry.beginIdSwap();
        for (Map.Entry<String, Integer> entry : dataList.entrySet()) {
            String itemName = entry.getKey();
            char discriminator = itemName.charAt(0);
            itemName = itemName.substring(1);
            Integer newId = entry.getValue();
            boolean isBlock = discriminator == '\u0001';
            int currId = isBlock ? blockRegistry.getId(itemName) : itemRegistry.getId(itemName);
            if (currId == -1) {
                FMLLog.info("Found a missing id from the world %s", itemName);
                missing.put((Object)itemName.substring(0, itemName.indexOf(58)), (Object)itemName);
            } else if (currId != newId) {
                FMLLog.info("Found %s id mismatch %s : %d %d", isBlock ? "block" : "item", itemName, currId, newId);
                remaps.put(itemName, new Integer[]{currId, newId});
            }
            if (isBlock) {
                blockRegistry.reassignMapping(itemName, newId);
                continue;
            }
            itemRegistry.reassignMapping(itemName, newId);
        }
        boolean successfullyLoaded = Loader.instance().fireMissingMappingEvent((ArrayListMultimap<String, String>)missing);
        if (!successfullyLoaded) {
            blockRegistry.revertSwap();
            itemRegistry.revertSwap();
            return false;
        }
        if (injectFrozenData) {
            FMLLog.info("Injecting new block and item data into this server instance", new Object[0]);
            HashMap missingBlocks = Maps.newHashMap(blockRegistry.getMissingMappings());
            HashMap missingItems = Maps.newHashMap(itemRegistry.getMissingMappings());
            for (Map.Entry item : missingItems.entrySet()) {
                String itemName = (String)item.getKey();
                if (missingBlocks.containsKey(itemName)) {
                    int blockId = blockRegistry.swap((Integer)item.getValue(), itemName, blockRegistry.get(itemName));
                    itemRegistry.swap(blockId, itemName, itemRegistry.get(itemName));
                    FMLLog.info("Injecting new block/item %s : %d", itemName, blockId);
                    missingBlocks.remove(itemName);
                    if (Integer.valueOf(blockId) == item.getValue()) continue;
                    remaps.put(itemName, new Integer[]{(Integer)item.getValue(), blockId});
                    continue;
                }
                FMLLog.info("Injecting new item %s", itemName);
                int itemId = itemRegistry.swap((Integer)item.getValue(), itemName, itemRegistry.get(itemName));
                if (Integer.valueOf(itemId) == item.getValue()) continue;
                remaps.put(itemName, new Integer[]{(Integer)item.getValue(), itemId});
            }
            for (Map.Entry block : missingBlocks.entrySet()) {
                FMLLog.info("Injecting new block %s", block.getKey());
                int blockId = blockRegistry.swap((Integer)block.getValue(), (String)block.getKey(), blockRegistry.get((String)block.getKey()));
                if (Integer.valueOf(blockId) == block.getValue()) continue;
                remaps.put(block.getKey(), new Integer[]{(Integer)block.getValue(), blockId});
            }
        }
        blockRegistry.completeIdSwap();
        itemRegistry.completeIdSwap();
        blockRegistry.dump();
        itemRegistry.dump();
        Loader.instance().fireRemapEvent(remaps);
        return true;
    }

    public static boolean processIdRematches(List<FMLMissingMappingsEvent.MissingMapping> remaps) {
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        for (FMLMissingMappingsEvent.MissingMapping remap : remaps) {
            FMLMissingMappingsEvent.Action action = remap.getAction();
            if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(remap.name);
                continue;
            }
            warned.add(remap.name);
        }
        if (!warned.isEmpty()) {
            FMLLog.severe("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return false;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", ignored.size());
        }
        return true;
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        blockRegistry.freezeMap();
        itemRegistry.freezeMap();
    }

    public static void revertToFrozen() {
        FMLLog.fine("Reverting to frozen data state", new Object[0]);
        blockRegistry.revertToFrozen();
        itemRegistry.revertToFrozen();
    }
}

