/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.util.List;

public class FMLOutboundHandler
extends ChannelOutboundHandlerAdapter {
    public static final AttributeKey<OutboundTarget> FML_MESSAGETARGET = new AttributeKey("fml:outboundTarget");
    public static final AttributeKey<Object> FML_MESSAGETARGETARGS = new AttributeKey("fml:outboundTargetArgs");

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        OutboundTarget outboundTarget;
        if (!(msg instanceof FMLProxyPacket)) {
            return;
        }
        FMLProxyPacket pkt = (FMLProxyPacket)((Object)msg);
        Object args = null;
        NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        if (dispatcher != null) {
            ctx.write(msg, promise);
            return;
        }
        if (ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get() == Side.CLIENT) {
            outboundTarget = OutboundTarget.TOSERVER;
        } else {
            outboundTarget = (OutboundTarget)((Object)ctx.channel().attr(FML_MESSAGETARGET).get());
            args = ctx.channel().attr(FML_MESSAGETARGETARGS).get();
            outboundTarget.validateArgs(args);
        }
        List<NetworkDispatcher> dispatchers = outboundTarget.selectNetworks(args, ctx, pkt);
        if (dispatchers == null) {
            ctx.write(msg, promise);
            return;
        }
        for (NetworkDispatcher targetDispatcher : dispatchers) {
            targetDispatcher.sendProxy((FMLProxyPacket)((Object)msg));
        }
    }

    public static enum OutboundTarget {
        NOWHERE{

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                return null;
            }
        }
        ,
        REPLY{

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                return ImmutableList.of((Object)((Object)packet.getDispatcher()));
            }
        }
        ,
        PLAYER{

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof mm)) {
                    throw new RuntimeException("PLAYER target expects a Player arg");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                mm player = (mm)args;
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                return ImmutableList.of((Object)((Object)dispatcher));
            }
        }
        ,
        ALL{

            @Override
            public void validateArgs(Object args) {
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (mm player : FMLCommonHandler.instance().getMinecraftServerInstance().af().a) {
                    NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                    builder.add((Object)dispatcher);
                }
                return builder.build();
            }
        }
        ,
        DIMENSION{

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof Integer)) {
                    throw new RuntimeException("DIMENSION expects an integer argument");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                int dimension = (Integer)args;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (mm player : FMLCommonHandler.instance().getMinecraftServerInstance().af().a) {
                    if (dimension != player.aq) continue;
                    NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                    builder.add((Object)dispatcher);
                }
                return builder.build();
            }
        }
        ,
        ALLAROUNDPOINT{

            @Override
            public void validateArgs(Object args) {
                if (!(args instanceof NetworkRegistry.TargetPoint)) {
                    throw new RuntimeException("ALLAROUNDPOINT expects a TargetPoint argument");
                }
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                NetworkRegistry.TargetPoint tp = (NetworkRegistry.TargetPoint)args;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (mm player : FMLCommonHandler.instance().getMinecraftServerInstance().af().a) {
                    double d6;
                    double d5;
                    double d4;
                    if (player.aq != tp.dimension || !((d4 = tp.x - player.t) * d4 + (d5 = tp.y - player.u) * d5 + (d6 = tp.z - player.v) * d6 < tp.range * tp.range)) continue;
                    NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)player.a.a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                    builder.add((Object)dispatcher);
                }
                return builder.build();
            }
        }
        ,
        TOSERVER{

            @Override
            public void validateArgs(Object args) {
                throw new RuntimeException("Cannot set TOSERVER as a target on the server");
            }

            @Override
            public List<NetworkDispatcher> selectNetworks(Object args, ChannelHandlerContext context, FMLProxyPacket packet) {
                ef clientConnection = FMLCommonHandler.instance().getClientToServerNetworkManager();
                return clientConnection == null ? ImmutableList.of() : ImmutableList.of((Object)clientConnection.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            }
        };


        public abstract void validateArgs(Object var1);

        public abstract List<NetworkDispatcher> selectNetworks(Object var1, ChannelHandlerContext var2, FMLProxyPacket var3);
    }
}

