/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLEvent;
import java.util.Collection;
import java.util.List;

public class FMLMissingMappingsEvent
extends FMLEvent {
    private ListMultimap<String, MissingMapping> missing;
    private ModContainer activeContainer;
    private List<MissingMapping> currentList;

    public FMLMissingMappingsEvent(ListMultimap<String, MissingMapping> missingMappings) {
        this.missing = missingMappings;
    }

    @Override
    public void applyModContainer(ModContainer activeContainer) {
        super.applyModContainer(activeContainer);
        this.activeContainer = activeContainer;
        this.currentList = null;
    }

    public List<MissingMapping> get() {
        if (this.currentList == null) {
            this.currentList = ImmutableList.copyOf((Collection)this.missing.removeAll((Object)this.activeContainer.getModId()));
        }
        return this.currentList;
    }

    public static class MissingMapping {
        public final Type type;
        public final String name;
        private Action action;
        private List<MissingMapping> remaps;

        public MissingMapping(String name, List<MissingMapping> remaps) {
            this.type = name.charAt(0) == '\u0001' ? Type.BLOCK : Type.ITEM;
            this.name = name;
            this.remaps = remaps;
            this.action = Action.WARN;
        }

        public void setAction(Action target) {
            this.action = target;
            this.remaps.add(this);
        }

        public Action getAction() {
            return this.action;
        }
    }

    public static enum Action {
        IGNORE,
        WARN;

    }

    public static enum Type {
        BLOCK,
        ITEM;

    }
}

