/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class FMLControlledNamespacedRegistry<I>
extends cv {
    private final Class<I> superType;
    private String optionalDefaultName;
    private I optionalDefaultObject;
    private BiMap<String, Integer> namedIds = HashBiMap.create();
    private BiMap<String, Integer> frozenIds;
    private Map<String, Integer> transactionalNamedIds;
    private BitSet transactionalAvailabilityMap;
    private BitSet availabilityMap;
    private int maxId;
    private int minId;
    private char discriminator;

    public FMLControlledNamespacedRegistry(String optionalDefault, int maxIdValue, int minIdValue, Class<I> type, char discriminator) {
        this.superType = type;
        this.discriminator = discriminator;
        this.optionalDefaultName = optionalDefault;
        this.availabilityMap = new BitSet(maxIdValue);
        this.maxId = maxIdValue;
        this.minId = minIdValue;
        this.a = new FMLObjectIntIdentityMap();
    }

    public void a(int id, String name, Object thing) {
        FMLLog.info("Add : %s %d %s", name, id, thing);
        this.add(id, name, this.superType.cast(thing));
    }

    int swap(int id, String name, I thing) {
        FMLLog.info("Swap : %s %d %s", name, id, thing);
        BitSet temporary = this.availabilityMap;
        this.availabilityMap = this.transactionalAvailabilityMap;
        int idToUse = id;
        if (id == 0 || this.availabilityMap.get(id)) {
            idToUse = this.availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse >= this.maxId) {
            throw new RuntimeException(String.format("Invalid id %s - not accepted", id));
        }
        this.namedIds.forcePut((Object)FMLControlledNamespacedRegistry.c((String)name), (Object)idToUse);
        this.reassignMapping(name, idToUse);
        this.useSlot(idToUse);
        this.availabilityMap = temporary;
        FMLLog.info("Swap : %s %d %s", name, idToUse, thing);
        return idToUse;
    }

    public int add(int id, String name, I thing) {
        if (name.equals(this.optionalDefaultName)) {
            this.optionalDefaultObject = thing;
        }
        int idToUse = id;
        if (id == 0 || this.availabilityMap.get(id)) {
            idToUse = this.availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse >= this.maxId) {
            throw new RuntimeException(String.format("Invalid id %s - not accepted", id));
        }
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc != null) {
            String prefix = mc.getModId();
            name = prefix + ":" + name;
        }
        this.namedIds.forcePut((Object)FMLControlledNamespacedRegistry.c((String)name), (Object)idToUse);
        super.a(idToUse, name, thing);
        this.useSlot(idToUse);
        FMLLog.info("Add : %s %d %s", name, idToUse, thing);
        return idToUse;
    }

    public I a(String name) {
        I object = this.superType.cast(super.a(name));
        return object == null ? this.optionalDefaultObject : object;
    }

    public I a(int id) {
        I object = this.superType.cast(super.a(id));
        return object == null ? this.optionalDefaultObject : object;
    }

    private FMLObjectIntIdentityMap idMap() {
        return (FMLObjectIntIdentityMap)this.a;
    }

    private BiMap<String, I> nameMap() {
        return (BiMap)this.c;
    }

    void beginIdSwap() {
        this.idMap().beginSwap();
        this.transactionalNamedIds = Maps.newHashMap();
        this.transactionalAvailabilityMap = new BitSet();
    }

    void reassignMapping(String name, int newId) {
        Object item = this.nameMap().get((Object)name);
        this.idMap().putNew(newId, item);
        this.transactionalNamedIds.put(name, newId);
        this.transactionalAvailabilityMap.set(newId);
    }

    void freezeMap() {
        if (this.frozenIds == null) {
            this.frozenIds = ImmutableBiMap.copyOf(this.namedIds);
            this.idMap().freezeMap();
        }
    }

    void revertToFrozen() {
        this.namedIds = HashBiMap.create(this.frozenIds);
        this.idMap().revertToFrozen();
    }

    Map<String, Integer> getMissingMappings() {
        return Maps.difference(this.frozenIds, this.transactionalNamedIds).entriesOnlyOnLeft();
    }

    void completeIdSwap() {
        this.idMap().completeSwap();
        this.namedIds.clear();
        this.namedIds.putAll(this.transactionalNamedIds);
        this.transactionalNamedIds = null;
    }

    void revertSwap() {
        this.idMap().revertSwap();
        this.transactionalNamedIds = null;
    }

    public I get(int id) {
        return this.a(id);
    }

    public I get(String name) {
        return this.a(name);
    }

    public int getId(I thing) {
        return this.b(thing);
    }

    public void serializeInto(Map<String, Integer> idMapping) {
        for (Map.Entry id : this.namedIds.entrySet()) {
            idMapping.put(this.discriminator + (String)id.getKey(), (Integer)id.getValue());
        }
    }

    public void useSlot(int id) {
        if (id >= this.maxId) {
            return;
        }
        this.availabilityMap.set(id);
    }

    List<Integer> usedIds() {
        return ((FMLObjectIntIdentityMap)this.a).usedIds();
    }

    public int getId(String itemName) {
        if (this.namedIds.containsKey((Object)itemName)) {
            return (Integer)this.namedIds.get((Object)itemName);
        }
        return -1;
    }

    public boolean contains(String itemName) {
        return this.namedIds.containsKey((Object)itemName);
    }

    void dump() {
        for (Map.Entry entry : this.namedIds.entrySet()) {
            String name = (String)entry.getKey();
            Object thing = this.idMap().get((Integer)entry.getValue());
            FMLLog.info("Registry : %s %d %s", name, entry.getValue(), thing);
        }
    }

    static class FMLObjectIntIdentityMap
    extends cs {
        private TIntIntHashMap frozenMap;
        private TIntIntHashMap oldMap;
        private TIntIntHashMap newMap;
        private ArrayList<Integer> frozenIndex;
        private ArrayList<Integer> oldIndex;
        private ArrayList<Integer> newIndex;

        boolean containsID(int id) {
            return this.b(id);
        }

        Object get(int id) {
            return this.a(id);
        }

        int get(Object obj) {
            return this.b(obj);
        }

        void beginSwap() {
            this.oldMap = this.a;
            this.newMap = new TIntIntHashMap(256, 0.5f, -1, -1);
            this.oldIndex = (ArrayList)this.b;
            this.newIndex = new ArrayList(this.oldIndex.size());
        }

        void freezeMap() {
            this.frozenMap = new TIntIntHashMap((TIntIntMap)this.a);
            this.frozenIndex = new ArrayList(this.b);
        }

        void revertToFrozen() {
            this.a = this.frozenMap;
            this.b = this.frozenIndex;
        }

        void completeSwap() {
            this.a = this.newMap;
            this.b = this.newIndex;
            this.newIndex = null;
            this.oldIndex = null;
            this.newMap = null;
            this.oldMap = null;
        }

        void revertSwap() {
            this.a = this.oldMap;
            this.b = this.oldIndex;
            this.newIndex = null;
            this.oldIndex = null;
            this.newMap = null;
            this.oldMap = null;
        }

        void putNew(int id, Object item) {
            this.a = this.newMap;
            this.b = this.newIndex;
            super.a(item, id);
            this.a = this.oldMap;
            this.b = this.oldIndex;
        }

        List<Integer> usedIds() {
            return Ints.asList((int[])this.a.keys());
        }
    }
}

