/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkHandshakeEstablished;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.NetworkModHolder;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public enum NetworkRegistry {
    INSTANCE;

    private EnumMap<Side, Map<String, FMLEmbeddedChannel>> channels = Maps.newEnumMap(Side.class);
    private Map<ModContainer, NetworkModHolder> registry = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();
    public static final AttributeKey<String> FML_CHANNEL;
    public static final AttributeKey<Side> CHANNEL_SOURCE;
    public static final AttributeKey<ModContainer> MOD_CONTAINER;
    public static final AttributeKey<es> NET_HANDLER;
    public static final byte FML_PROTOCOL = 1;

    private NetworkRegistry() {
        this.channels.put(Side.CLIENT, Maps.newConcurrentMap());
        this.channels.put(Side.SERVER, Maps.newConcurrentMap());
    }

    public EnumMap<Side, FMLEmbeddedChannel> newChannel(String name, ChannelHandler ... handlers) {
        if (this.channels.containsKey(name) || name.startsWith("MC|") || name.startsWith("\u0001") || name.startsWith("FML")) {
            throw new RuntimeException("That channel is already registered");
        }
        EnumMap result = Maps.newEnumMap(Side.class);
        for (Side side : Side.values()) {
            FMLEmbeddedChannel channel = new FMLEmbeddedChannel(name, side, handlers);
            this.channels.get((Object)side).put(name, channel);
            result.put(side, channel);
        }
        return result;
    }

    public FMLEventChannel newEventDrivenChannel(String name) {
        return new FMLEventChannel(name);
    }

    public EnumMap<Side, FMLEmbeddedChannel> newChannel(ModContainer container, String name, ChannelHandler ... handlers) {
        if (this.channels.containsKey(name) || name.startsWith("MC|") || name.startsWith("\u0001") || name.startsWith("FML") && !"FML".equals(container.getModId())) {
            throw new RuntimeException("That channel is already registered");
        }
        EnumMap result = Maps.newEnumMap(Side.class);
        for (Side side : Side.values()) {
            FMLEmbeddedChannel channel = new FMLEmbeddedChannel(container, name, side, handlers);
            this.channels.get((Object)side).put(name, channel);
            result.put(side, channel);
        }
        return result;
    }

    public FMLEmbeddedChannel getChannel(String name, Side source) {
        return this.channels.get((Object)source).get(name);
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            FMLLog.log(Level.ERROR, "Mod of type %s attempted to register a gui network handler during a construction phase", mod.getClass().getName());
            throw new RuntimeException("Invalid attempt to create a GUI during mod construction. Use an EventHandler instead");
        }
        this.serverGuiHandlers.put(mc, handler);
        this.clientGuiHandlers.put(mc, handler);
    }

    public ye getRemoteGuiContainer(ModContainer mc, mm player, int modGuiId, afn world, int x, int y, int z2) {
        IGuiHandler handler = this.serverGuiHandlers.get(mc);
        if (handler != null) {
            return (ye)handler.getServerGuiElement(modGuiId, (xl)player, world, x, y, z2);
        }
        return null;
    }

    public Object getLocalGuiContainer(ModContainer mc, xl player, int modGuiId, afn world, int x, int y, int z2) {
        IGuiHandler handler = this.clientGuiHandlers.get(mc);
        return handler.getClientGuiElement(modGuiId, player, world, x, y, z2);
    }

    public boolean hasChannel(String channelName, Side source) {
        return this.channels.get((Object)source).containsKey(channelName);
    }

    public void register(ModContainer fmlModContainer, Class<?> clazz, String remoteVersionRange, ASMDataTable asmHarvestedData) {
        NetworkModHolder networkModHolder = new NetworkModHolder(fmlModContainer, clazz, remoteVersionRange, asmHarvestedData);
        this.registry.put(fmlModContainer, networkModHolder);
    }

    public Map<ModContainer, NetworkModHolder> registry() {
        return ImmutableMap.copyOf(this.registry);
    }

    public Set<String> channelNamesFor(Side side) {
        return this.channels.get((Object)side).keySet();
    }

    public void fireNetworkHandshake(NetworkDispatcher networkDispatcher, Side origin) {
        NetworkHandshakeEstablished handshake = new NetworkHandshakeEstablished(networkDispatcher, networkDispatcher.getNetHandler(), origin);
        for (Map.Entry<String, FMLEmbeddedChannel> channel : this.channels.get((Object)origin).entrySet()) {
            channel.getValue().pipeline().fireUserEventTriggered((Object)handshake);
        }
    }

    static {
        FML_CHANNEL = new AttributeKey("fml:channelName");
        CHANNEL_SOURCE = new AttributeKey("fml:channelSource");
        MOD_CONTAINER = new AttributeKey("fml:modContainer");
        NET_HANDLER = new AttributeKey("fml:netHandler");
    }

    public static class TargetPoint {
        public final double x;
        public final double y;
        public final double z;
        public final double range;
        public final int dimension;

        public TargetPoint(int dimension, double x, double y, double z2, double range) {
            this.x = x;
            this.y = y;
            this.z = z2;
            this.range = range;
            this.dimension = dimension;
        }
    }
}

