/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.server;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.server.MinecraftServer;

public class FMLServerHandler
implements IFMLSidedHandler {
    private static final FMLServerHandler INSTANCE = new FMLServerHandler();
    private MinecraftServer server;
    private static final Pattern assetENUSLang = Pattern.compile("assets/(.*)/lang/en_US.lang");

    private FMLServerHandler() {
        FMLCommonHandler.instance().beginLoading(this);
    }

    @Override
    public void beginServerLoading(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
        Loader.instance().loadMods();
    }

    @Override
    public void finishServerLoading() {
        Loader.instance().initializeMods();
        LanguageRegistry.reloadLanguageTable();
    }

    @Override
    public void haltGame(String message, Throwable exception) {
        throw new RuntimeException(message, exception);
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    public static FMLServerHandler instance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return false;
    }

    @Override
    public void addModAsResource(ModContainer container) {
        File source = container.getSource();
        try {
            if (source.isDirectory()) {
                this.searchDirForENUSLanguage(source, "");
            } else {
                this.searchZipForENUSLanguage(source);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void searchZipForENUSLanguage(File source) throws IOException {
        ZipFile zf = new ZipFile(source);
        for (ZipEntry zipEntry : Collections.list(zf.entries())) {
            Matcher matcher = assetENUSLang.matcher(zipEntry.getName());
            if (!matcher.matches()) continue;
            FMLLog.fine("Injecting found translation data in zip file %s at %s into language system", source.getName(), zipEntry.getName());
            dd.inject((InputStream)zf.getInputStream(zipEntry));
        }
        zf.close();
    }

    private void searchDirForENUSLanguage(File source, String path) throws IOException {
        for (File file : source.listFiles()) {
            Matcher matcher;
            String currPath = path + file.getName();
            if (file.isDirectory()) {
                this.searchDirForENUSLanguage(file, currPath + '/');
            }
            if (!(matcher = assetENUSLang.matcher(currPath)).matches()) continue;
            FMLLog.fine("Injecting found translation data at %s into language system", currPath);
            dd.inject((InputStream)new FileInputStream(file));
        }
    }

    @Override
    public void updateResourcePackList() {
    }

    @Override
    public String getCurrentLanguage() {
        return "en_US";
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public ef getClientToServerNetworkManager() {
        throw new RuntimeException("Missing");
    }
}

