/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import cpw.mods.fml.common.network.handshake.IHandshakeState;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandlerContext;

enum FMLHandshakeClientState implements IHandshakeState<FMLHandshakeClientState>
{
    START{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.clientListenForServerHandshake();
            return HELLO;
        }
    }
    ,
    HELLO{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            FMLLog.info("Server protocol version %x", ((FMLHandshakeMessage.ServerHello)msg).protocolVersion());
            ctx.writeAndFlush((Object)FMLHandshakeMessage.makeCustomChannelRegistration(NetworkRegistry.INSTANCE.channelNamesFor(Side.CLIENT)));
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ClientHello());
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ModList(Loader.instance().getActiveModList()));
            return WAITINGSERVERDATA;
        }
    }
    ,
    WAITINGSERVERDATA{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            String result = FMLNetworkHandler.checkModList((FMLHandshakeMessage.ModList)msg, Side.SERVER);
            if (result != null) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake(result);
                return ERROR;
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal()));
            if (!((Boolean)ctx.channel().attr(NetworkDispatcher.IS_LOCAL).get()).booleanValue()) {
                return WAITINGSERVERCOMPLETE;
            }
            return PENDINGCOMPLETE;
        }
    }
    ,
    WAITINGSERVERCOMPLETE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            FMLHandshakeMessage.ModIdData modIds = (FMLHandshakeMessage.ModIdData)msg;
            if (!GameData.injectWorldIDMap(modIds.dataList(), false)) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake("Fatally missing blocks and items");
                return ERROR;
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal()));
            return PENDINGCOMPLETE;
        }
    }
    ,
    PENDINGCOMPLETE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal()));
            return COMPLETE;
        }
    }
    ,
    COMPLETE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.completeClientHandshake();
            FMLMessage.CompleteHandshake complete = new FMLMessage.CompleteHandshake(Side.CLIENT);
            ctx.fireChannelRead((Object)complete);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal()));
            return DONE;
        }
    }
    ,
    DONE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            return this;
        }
    }
    ,
    ERROR{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            return this;
        }
    };

}

