/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;

@ChannelHandler.Sharable
public abstract class FMLIndexedMessageToMessageCodec<A>
extends MessageToMessageCodec<FMLProxyPacket, A> {
    private TByteObjectHashMap<Class<? extends A>> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends A>> types = new TObjectByteHashMap();

    public FMLIndexedMessageToMessageCodec<A> addDiscriminator(int discriminator, Class<? extends A> type) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        return this;
    }

    public abstract void encodeInto(ChannelHandlerContext var1, A var2, ByteBuf var3) throws Exception;

    protected final void encode(ChannelHandlerContext ctx, A msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte discriminator = this.types.get(clazz);
        buffer.writeByte((int)discriminator);
        this.encodeInto(ctx, msg, buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add((Object)proxy);
    }

    public abstract void decodeInto(ChannelHandlerContext var1, ByteBuf var2, A var3);

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class clazz = (Class)this.discriminators.get(discriminator);
        Object newMsg = clazz.newInstance();
        this.decodeInto(ctx, payload.slice(), newMsg);
        out.add(newMsg);
    }
}

