/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw, LexManos");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dg getDataForWriting(axc handler, axe info) {
        dg fmlData = new dg();
        dp list = new dp();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            dg mod = new dg();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            list.a((du)mod);
        }
        fmlData.a("ModList", (du)list);
        dp dataList = new dp();
        Map<String, Integer> itemList = GameData.buildItemDataList();
        for (Map.Entry<String, Integer> item : itemList.entrySet()) {
            dg tag = new dg();
            tag.a("K", item.getKey());
            tag.a("V", item.getValue().intValue());
            dataList.a((du)tag);
        }
        fmlData.a("ItemData", (du)dataList);
        return fmlData;
    }

    @Override
    public void readData(axc handler, axe info, Map<String, du> propertyMap, dg tag) {
        dp modList;
        if (tag.c("ModList")) {
            modList = tag.c("ModList", 10);
            for (int i = 0; i < modList.c(); ++i) {
                dg mod = modList.b(i);
                String modId = mod.j("ModId");
                String modVersion = mod.j("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        if (tag.c("ModItemData")) {
            modList = tag.c("ModItemData", 10);
        } else if (tag.c("ItemData")) {
            dp list = tag.c("ItemData", 10);
            LinkedHashMap dataList = Maps.newLinkedHashMap();
            for (int i = 0; i < list.c(); ++i) {
                dg dataTag = list.b(i);
                dataList.put(dataTag.j("K"), dataTag.f("V"));
            }
            boolean successfullyInjected = GameData.injectWorldIDMap(dataList, true);
            if (!successfullyInjected) {
                throw new RuntimeException("Failed to load the world - there are fatal block and item id issues");
            }
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }
}

