/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.List;
import java.util.Map;

public class RenderingRegistry {
    private static final RenderingRegistry INSTANCE = new RenderingRegistry();
    private int nextRenderId = 40;
    private Map<Integer, ISimpleBlockRenderingHandler> blockRenderers = Maps.newHashMap();
    private List<EntityRendererInfo> entityRenderers = Lists.newArrayList();

    public static int addNewArmourRendererPrefix(String armor) {
        bno.l = (String[])ObjectArrays.concat((Object[])bno.l, (Object)armor);
        return bno.l.length - 1;
    }

    public static void registerEntityRenderingHandler(Class<? extends qn> entityClass, bng renderer) {
        RenderingRegistry.instance().entityRenderers.add(new EntityRendererInfo(entityClass, renderer));
    }

    public static void registerBlockHandler(ISimpleBlockRenderingHandler handler) {
        RenderingRegistry.instance().blockRenderers.put(handler.getRenderId(), handler);
    }

    public static void registerBlockHandler(int renderId, ISimpleBlockRenderingHandler handler) {
        RenderingRegistry.instance().blockRenderers.put(renderId, handler);
    }

    public static int getNextAvailableRenderId() {
        return RenderingRegistry.instance().nextRenderId++;
    }

    @Deprecated
    public static RenderingRegistry instance() {
        return INSTANCE;
    }

    public boolean renderWorldBlock(ble renderer, afx world, int x, int y, int z, ahu block, int modelId) {
        if (!this.blockRenderers.containsKey(modelId)) {
            return false;
        }
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelId);
        return bri.renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    public void renderInventoryBlock(ble renderer, ahu block, int metadata, int modelID) {
        if (!this.blockRenderers.containsKey(modelID)) {
            return;
        }
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelID);
        bri.renderInventoryBlock(block, metadata, modelID, renderer);
    }

    public boolean renderItemAsFull3DBlock(int modelId) {
        ISimpleBlockRenderingHandler bri = this.blockRenderers.get(modelId);
        return bri != null && bri.shouldRender3DInInventory(modelId);
    }

    public void loadEntityRenderers(Map<Class<? extends qn>, bng> rendererMap) {
        for (EntityRendererInfo info : this.entityRenderers) {
            rendererMap.put(info.target, info.renderer);
            info.renderer.a(bnf.a);
        }
    }

    private static class EntityRendererInfo {
        private Class<? extends qn> target;
        private bng renderer;

        public EntityRendererInfo(Class<? extends qn> target, bng renderer) {
            this.target = target;
            this.renderer = renderer;
        }
    }
}

